/*----------------------------------------------------------------------------
 *      U S B  -  K e r n e l
 *----------------------------------------------------------------------------
 *      Name:    USBDESC.C
 *      Purpose: USB Descriptors
 *      Version: V1.10
 *----------------------------------------------------------------------------
 *      This file is part of the uVision/ARM development tools.
 *      This software may only be used under the terms of a valid, current,
 *      end user licence from KEIL for a compatible version of KEIL software
 *      development tools. Nothing else gives you the right to use it.
 *
 *      Copyright (c) 2005-2007 Keil Software.
 *---------------------------------------------------------------------------*/


#include "usb.h"
#include "hid.h"
#include "usbcfg.h"
#include "usbdesc.h"
//#include "boardcfg.h"


BYTE InReport[INREPORT_SIZE];             /* HID Input Report  */
BYTE OutReport[OUTREPORT_SIZE];             /* HID Output Report */

const BYTE HID_ReportDescriptor[] = {
  HID_UsagePageVendor( 0x00                                   ),
  HID_Usage(           0x01                                   ),
  HID_Collection(      HID_Application                        ),
    HID_LogicalMin(    0                                      ),
    HID_LogicalMaxS(   0xFF                                   ),
    HID_ReportSize(    8                                      ),  // bits
    HID_ReportCount(   INREPORT_SIZE                          ),  // bytes
    HID_Usage(         0x01                                   ),
    HID_Input(         HID_Data | HID_Variable | HID_Absolute ),
    HID_ReportCount(   OUTREPORT_SIZE                         ),  // bytes
    HID_Usage(         0x01                                   ),
    HID_Output(        HID_Data | HID_Variable | HID_Absolute ),
  HID_EndCollection,
};
/* HID Report Descriptor */


const WORD HID_ReportDescSize = sizeof(HID_ReportDescriptor);


/* USB Standard Device Descriptor */
const BYTE USB_DeviceDescriptor[] = {
  USB_DEVICE_DESC_SIZE,              /* bLength */
  USB_DEVICE_DESCRIPTOR_TYPE,        /* bDescriptorType */
  WBVAL(0x0200), /* 1.10 */          /* bcdUSB */
  0x00,                              /* bDeviceClass */
  0x00,                              /* bDeviceSubClass */
  0x00,                              /* bDeviceProtocol */
  USB_MAX_PACKET0,                   /* bMaxPacketSize0 */
  WBVAL(USB_VID),                     /* idVendor */
  WBVAL(USB_PID),                     /* idProduct */
  WBVAL(0x0200), /* 1.00 */          /* bcdDevice */
  0x04,                              /* iManufacturer */
  0x20,                              /* iProduct */
  0x44,                              /* iSerialNumber */
  0x01                               /* bNumConfigurations */
};

/* USB Configuration Descriptor */
/*   All Descriptors (Configuration, Interface, Endpoint, Class, Vendor */
const BYTE USB_ConfigDescriptor[] = {
/* Configuration 1 */
  USB_CONFIGUARTION_DESC_SIZE,       /* bLength */
  USB_CONFIGURATION_DESCRIPTOR_TYPE, /* bDescriptorType */
  WBVAL(                             /* wTotalLength */
    USB_CONFIGUARTION_DESC_SIZE +
    USB_INTERFACE_DESC_SIZE     +
    HID_DESC_SIZE               +
    USB_ENDPOINT_DESC_SIZE		+
	USB_ENDPOINT_DESC_SIZE
  ),
  0x01,                              /* bNumInterfaces */
  0x01,                              /* bConfigurationValue */
  0x00,                              /* iConfiguration */
  USB_CONFIG_BUS_POWERED /*|*/       /* bmAttributes */
/*USB_CONFIG_REMOTE_WAKEUP*/,
  USB_CONFIG_POWER_MA(250),          /* bMaxPower */
/* Interface 0, Alternate Setting 0, HID Class */
  USB_INTERFACE_DESC_SIZE,           /* bLength */
  USB_INTERFACE_DESCRIPTOR_TYPE,     /* bDescriptorType */
  0x00,                              /* bInterfaceNumber */
  0x00,                              /* bAlternateSetting */
  0x02,                              /* bNumEndpoints */
  USB_DEVICE_CLASS_HUMAN_INTERFACE,  /* bInterfaceClass */
  HID_SUBCLASS_NONE,                 /* bInterfaceSubClass */
  HID_PROTOCOL_NONE,                 /* bInterfaceProtocol */
  0x5E,                              /* 0x5EiInterface */
/* HID Class Descriptor */
/* HID_DESC_OFFSET = 0x0012 */
  HID_DESC_SIZE,                     /* bLength */
  HID_HID_DESCRIPTOR_TYPE,           /* bDescriptorType */
  WBVAL(0x0200), /* 1.00 */          /* bcdHID */
  0x00,                              /* bCountryCode */
  0x02,                              /* bNumDescriptors */
  HID_REPORT_DESCRIPTOR_TYPE,        /* bDescriptorType */
  WBVAL(HID_REPORT_DESC_SIZE),       /* wDescriptorLength */
 /* Endpoint, HID Interrupt In //Ausgang zum PC*/
  USB_ENDPOINT_DESC_SIZE,            /* bLength */
  USB_ENDPOINT_DESCRIPTOR_TYPE,      /* bDescriptorType */
  USB_ENDPOINT_IN(1),                /* bEndpointAddress */
//  USB_ENDPOINT_TYPE_ISOCHRONOUS,
  USB_ENDPOINT_TYPE_INTERRUPT,      /* bmAttributes */
//  WBVAL(0x03FF),  
  WBVAL(0x0040),                     /* wMaxPacketSize */
  USB_IN_SPEED,          /* 32ms */          /* bInterval #####################################*/
/* Endpoint, HID Interrupt Out //Eingang vom PC*/
  USB_ENDPOINT_DESC_SIZE,            /* bLength */
  USB_ENDPOINT_DESCRIPTOR_TYPE,      /* bDescriptorType */
  USB_ENDPOINT_OUT(1),               /* bEndpointAddress */
  USB_ENDPOINT_TYPE_INTERRUPT,     /* bmAttributes */
  WBVAL(0x0040),                     /* wMaxPacketSize */
  USB_OUT_SPEED,          /* 32ms */          /* bInterval #####################################*/
/* Terminator */
  0                                  /* bLength */
};

/* USB String Descriptor (optional) */
const BYTE USB_StringDescriptor[] = {
/* Index 0x00: LANGID Codes */
  0x04,                              /* bLength */
  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
  WBVAL(0x0409), /* US English */    /* wLANGID */
/* Index 0x04: Manufacturer */
  0x1C,                              /* bLength */
  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
  'K',0,
  'e',0,
  'i',0,
  'l',0,
  ' ',0,
  'S',0,
  'o',0,
  'f',0,
  't',0,
  'w',0,
  'a',0,
  'r',0,
  'e',0,
/* Index 0x20: Product */
  0x24,                              /* bLength */
  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
  'K',0,
  'e',0,
  'i',0,
  'l',0,
  ' ',0,
  'M',0,
  'C',0,
  'B',0,
  'S',0,
  'T',0,
  'M',0,
  '3',0,
  '2',0,
  ' ',0,
  'H',0,
  'I',0,
  'D',0,
/* Index 0x44: Serial Number */
  0x1A,                              /* bLength */
  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
  'D',0,
  'E',0,
  'M',0,
  'O',0,
  ' ',0,
  '0',0,
  '1',0,
  '.',0,
  '0',0,
  '0',0,
  ' ',0,
  ' ',0,
/* Index 0x5E: Interface 0, Alternate Setting 0 */
  0x08,                              /* bLength */
  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
  'H',0,
  '2',0,
  'D',0,
};
