#include "boardcfg.h"
#include "hw_config.h"
#include "lcd.h"
#include "stm32f10x_adc.h"
#include "stm32f10x_spi.h"
#include "stm32f10x_dma.h"
#include "stm32f10x_rcc.h"
//#include "stm32f10x_tim.h"
#include "stm32f10x_usart.h"
#include "stm32f10x_pwr.h"
#include "stm32f10x_bkp.h"
#include "usb_pwr.h"
#include <string.h> /* strcpy,strlen */
#include "misc.h"

//#define ADC1_DR_Address    ((u32)0x4001244C)
void CB_Startup(void);
void stm32_Init(void);
vu16 ADCConvertedValue;
vu16 AdcValues[2];

static vu32 TimingDelay = 0;
u8 Last_SPI_Config=255;
u16 Delay;

//Importierte/Interne Funktionen
void USB_Init(void);
void RTC_Config(void);
void Encoder_Config(void);
void LCD_GPIO_Setup(void);

void System_Init(void) {


    #ifdef USE_KEIL_IDE
    stm32_Init();
    #else
    CB_Startup();
    #endif // USE_KEIL_IDE

	RCC_AHBPeriphClockCmd(BOARD_AHB_RCCs, ENABLE);
	RCC_APB1PeriphClockCmd(BOARD_APB1_RCCs, ENABLE);
	RCC_APB2PeriphClockCmd(BOARD_APB2_RCCs, ENABLE);

	PWR_WakeUpPinCmd(ENABLE);
	ADC_Config();
	USB_Config(ENABLE);
//	SPI_Config(Mode_0,Databit8,BaudScale_32);
	I2C_GPIO_Config();
	LCD_GPIO_Setup();
	LCD_Initializtion();
    RTC_Config();
    Encoder_Config();
}

void CB_Startup(void) {
    USART_InitTypeDef USART_InitStructure;
    GPIO_InitTypeDef GPIO_InitStructure;
    //Startup ########################################################
	//Statuspointer
	#define PLL_RDY (*((volatile unsigned long *) 0x42420064))
	#define HSE_RDY (*((volatile unsigned long *) 0x42420044))
	//Konfiguration einstellen
    FLASH->ACR = 0x00000012; //Flashzugriff
	RCC->CFGR = 0x001D8402; //RCC einstellen
	RCC->CR = 0x01010082; //RCC einschalten
	while(HSE_RDY==0){ ASM_NOP } //wait for HSE
	while(PLL_RDY==0){ ASM_NOP } //wait for PLL
	RCC->BDCR = 0x00008101; //
	//Peripherie Takte einschalten
	RCC->AHBENR = 0x00000000; //
	RCC->APB2ENR = 0x0000523D; //
	RCC->APB1ENR = 0x18800001; //

	//GPIO_Setup ######################################################
	//GPIOG Offline
	//GPIOF Offline
	//GPIOE Offline
	//GPIOD Setup:
	RCC->APB2ENR |= 1<<5; 	//Clock einschalten
	GPIOD->CRL = 0x44444444;   //IF IF IF IF  | IF IF IF IF  Pin 7-4|3-0
	GPIOD->CRH = 0x44444444;   //IF IF IF IF  | IF IF IF IF  Pin 15-12|11-8
	GPIOD->ODR = 0x00000000;   //Set/Reset Pins
	//GPIOC Setup:
	RCC->APB2ENR |= 1<<4; 	//Clock einschalten
	GPIOC->CRL = 0x44444444;   //IF IF IF IF  | IF IF IF IF  Pin 7-4|3-0
	GPIOC->CRH = 0x44433333;   //IF IF IF OP  | OP OP OP OP  Pin 15-12|11-8
	GPIOC->ODR = 0x00000000;   //Set/Reset Pins
	//GPIOB Setup:
	RCC->APB2ENR |= 1<<3; 	//Clock einschalten
	GPIOB->CRL = 0x33344444;   //OP OP OP IF  | IF IF IF IF  Pin 7-4|3-0
	GPIOB->CRH = 0x33333333;   //OP OP OP OP  | OP OP OP OP  Pin 15-12|11-8
	GPIOB->ODR = 0x00000000;   //Set/Reset Pins
	//GPIOA Setup:
	RCC->APB2ENR |= 1<<2; 	//Clock einschalten
	GPIOA->CRL = 0xB8B33344;   //AP IU AP OP  | OP OP IF IF  Pin 7-4|3-0
	GPIOA->CRH = 0x0444B404;   //IA IF IF IF  | AP IF IA IF  Pin 15-12|11-8
	GPIOA->ODR = 0x00000040;   //Set/Reset Pins
	RCC->APB2ENR |= 1; 	//Alternative Funktion Clock

	//UART_Setup ######################################################
	/* Configure USART1 Tx (PA.09) as alternate function push-pull */
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_9;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
    GPIO_Init(GPIOA, &GPIO_InitStructure);
    /* Configure USART1 Rx (PA.10) as input floating */
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_10;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
    GPIO_Init(GPIOA, &GPIO_InitStructure);

    USART_InitStructure.USART_BaudRate = 115200;
    USART_InitStructure.USART_WordLength = USART_WordLength_8b;
    USART_InitStructure.USART_StopBits = USART_StopBits_1;
    USART_InitStructure.USART_Parity = USART_Parity_No;
    USART_InitStructure.USART_HardwareFlowControl = USART_HardwareFlowControl_None;
    USART_InitStructure.USART_Mode = USART_Mode_Rx | USART_Mode_Tx;
    /* Configure USART1 */
    USART_Init(USART1, &USART_InitStructure);
    USART_ITConfig(USART1, USART_IT_RXNE, ENABLE);
    /* Enable the USART1 */
    USART_Cmd(USART1, ENABLE);

    //SysTick_Setup ######################################################
//    SysTick->LOAD  = 10*((72000000/8)/1000)-1;
    SysTick->CTRL  = 2;
    SysTick->VAL   = 0;
    SysTick->LOAD = 9000; //set 1ms
    SysTick->CTRL |= 1; //Enable
}

void Encoder_Config(void) {
    TIM_TimeBaseInitTypeDef TIM_TimeBaseStructure;

	RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM2, ENABLE);

    TIM_TimeBaseStructure.TIM_Prescaler = 0;
    TIM_TimeBaseStructure.TIM_Period = 65535; // Maximal
    TIM_TimeBaseStructure.TIM_ClockDivision = TIM_CKD_DIV1;
    TIM_TimeBaseStructure.TIM_CounterMode = TIM_CounterMode_Up;
    TIM_TimeBaseInit(TIM2, &TIM_TimeBaseStructure);

    TIM_EncoderInterfaceConfig(TIM2, TIM_EncoderMode_TI1, TIM_ICPolarity_Rising, TIM_ICPolarity_Rising);
    TIM3->CNT = 32767;
    TIM_Cmd(TIM2, ENABLE);
}
void LCD_GPIO_Setup(void) {
    GPIO_InitTypeDef  GPIO_InitStructure;

    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_Mode  = GPIO_Mode_Out_PP;
#ifdef Use_LCD_16Bit
    GPIO_InitStructure.GPIO_Pin   = 0x00FF; //GPIO 7-0
    GPIO_Init(LCD_DataPort_0to7, &GPIO_InitStructure);
    GPIO_InitStructure.GPIO_Pin   = 0xFF00; //GPIO 15-8
    GPIO_Init(LCD_DataPort_8to15, &GPIO_InitStructure);
#else //8Bit Transfer
    GPIO_InitStructure.GPIO_Pin   = 0xFF00; //GPIO 15-8
    GPIO_Init(LCD_DataPort_8to15, &GPIO_InitStructure);
    //unbenutzte als Eingnge
    GPIO_InitStructure.GPIO_Mode  = GPIO_Mode_IN_FLOATING;
    GPIO_InitStructure.GPIO_Pin   = 0x00FF; //GPIO 7-0
    GPIO_Init(LCD_DataPort_0to7, &GPIO_InitStructure);
#endif
}
void SPI_Config(u8 Mode, u8 Datasize, u8 Baudrate) {
	SPI_InitTypeDef  SPI_InitStructure;
	GPIO_InitTypeDef  GPIO_InitStructure;

	if (Mode==Mode_OFF) {
		SPI_SelectDevice(0);
		SPI_I2S_DeInit(SPI1);
		SPI_Cmd(SPI1, DISABLE);
		/* All SPI-Pins to input with weak internal pull-downs */
		GPIO_InitStructure.GPIO_Pin   = GPIO_Pin_SD_SCK | GPIO_Pin_SD_MISO | GPIO_Pin_SD_MOSI;
		GPIO_InitStructure.GPIO_Mode  = GPIO_Mode_IPD;
		GPIO_Init(GPIO_SD_Port, &GPIO_InitStructure);
		GPIO_SD_Port->BRR = GPIO_Pin_SD_SCK | GPIO_Pin_SD_MISO | GPIO_Pin_SD_MOSI;

		RCC_APB2PeriphClockCmd(RCC_APB2Periph_SPI1, DISABLE);
	}

	RCC_APB2PeriphClockCmd(RCC_APB2Periph_SPI1, ENABLE);

	/* Configure SPI pins: SCK and MOSI with default alternate function (not remapped) push-pull */
	GPIO_InitStructure.GPIO_Pin   = GPIO_Pin_SD_SCK | GPIO_Pin_SD_MOSI;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_InitStructure.GPIO_Mode  = GPIO_Mode_AF_PP;
	GPIO_Init(GPIO_SD_Port, &GPIO_InitStructure);

	/* Configure MISO as Input with internal pull-up */
	GPIO_InitStructure.GPIO_Pin   = GPIO_Pin_SD_MISO;
	GPIO_InitStructure.GPIO_Mode  = GPIO_Mode_IPU;
	GPIO_Init(GPIO_SD_Port, &GPIO_InitStructure);
	GPIO_SD_Port->BSRR = GPIO_Pin_SD_MISO;

	SPI_InitStructure.SPI_Direction = SPI_Direction_2Lines_FullDuplex;
	SPI_InitStructure.SPI_Mode = SPI_Mode_Master;
	switch (Mode) {
		case 0:
			SPI_InitStructure.SPI_CPOL = SPI_CPOL_Low;
			SPI_InitStructure.SPI_CPHA = SPI_CPHA_1Edge;
			break;
		case 1:
			SPI_InitStructure.SPI_CPOL = SPI_CPOL_Low;
			SPI_InitStructure.SPI_CPHA = SPI_CPHA_2Edge;
			break;
		case 2:
			SPI_InitStructure.SPI_CPOL = SPI_CPOL_High;
			SPI_InitStructure.SPI_CPHA = SPI_CPHA_1Edge;
			break;
		case 3:
			SPI_InitStructure.SPI_CPOL = SPI_CPOL_High;
			SPI_InitStructure.SPI_CPHA = SPI_CPHA_2Edge;
			break;
	}
	switch (Datasize) {
		case 8: SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b; break;
		case 16: SPI_InitStructure.SPI_DataSize = SPI_DataSize_16b; break;
	}
	switch (Baudrate) {//72000kHz/256=281.25 kHz
		case 2: SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_2; break; //36 MHz
		case 4: SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_4; break; //18 MHz
		case 8: SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_8; break; //9 MHz
		case 16: SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_16; break; //4.5 MHz
		case 32: SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_32; break; //2.25 MHz
		case 64: SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_64; break; //1.125 MHz
		case 128: SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_128; break; //562.5 KHz
		case 255: SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_256; break; //281.25 KHz
	}
	SPI_InitStructure.SPI_NSS = SPI_NSS_Soft;
	SPI_InitStructure.SPI_FirstBit = SPI_FirstBit_MSB;
	SPI_InitStructure.SPI_CRCPolynomial = 7;

	SPI_Init(SPI1, &SPI_InitStructure);
	SPI_CalculateCRC(SPI1, DISABLE);
	SPI_Cmd(SPI1, ENABLE);

	SPI_SSOutputCmd(SPI1, DISABLE);

	SPI_NSSInternalSoftwareConfig(SPI1, SPI_NSSInternalSoft_Set);

}
void SPI_SelectDevice(u8 Device) {
 //1=SD 2=TP 3=FLASH
	if (Last_SPI_Config==Device) { return; }
	Last_SPI_Config=Device;

	TP_OFF; SD_OFF; F_OFF;
	switch(Device) {
		case 1: SPI_Config(Mode_0,Databit8,BaudScale_32); SD_ON;  break; //
		case 2: SPI_Config(Mode_0,Databit16,BaudScale_64); TP_ON;  break; //
		case 3: SPI_Config(Mode_0,Databit8,BaudScale_32); F_ON;  break;	//
		case 255: SPI_Config(Mode_OFF,0,0); break;
	}
}
u16 TP_SPI_RW(u16 c) {
	u16 MSB, LSB, data, Timeout;

	SPI_I2S_SendData(SPI1, c); Timeout=5000;
	while (SPI_I2S_GetFlagStatus(SPI1, SPI_I2S_FLAG_RXNE) == RESET) { Timeout--; if	(Timeout==0) { return 0; } }
	MSB=SPI_I2S_ReceiveData(SPI1);

	SPI_I2S_SendData(SPI1, 0); Timeout=5000;
	while (SPI_I2S_GetFlagStatus(SPI1, SPI_I2S_FLAG_RXNE) == RESET) { Timeout--; if	(Timeout==0) { return 0; } }
	LSB=SPI_I2S_ReceiveData(SPI1);
    data=(((MSB<<4)&0x0FF0)|((LSB>>12)&0x000F))<<1;
	//TP_Deselect();
	return data;
}
void TP_GetAdXY(vs16 *x,vs16 *y) {
	u32 X,Y;
	X=TP_SPI_RW(0x9400); X+=TP_SPI_RW(0x9400); X+=TP_SPI_RW(0x9400); X+=TP_SPI_RW(0x9400);
	Y=TP_SPI_RW(0xD400); Y+=TP_SPI_RW(0xD400); Y+=TP_SPI_RW(0xD400); Y+=TP_SPI_RW(0xD400);
	Y=Y/4; X=X/4;
	#ifdef Switch_TP_Axis
	*y=((4094-X-260)/14.895);
	*x=((Y-240)/11.312);
//	*y=((4094-TP_SPI_RW(0x9400)-260)/14.895);
//	*x=((TP_SPI_RW(0xD400)-240)/11.312);
	#else
	*x=((4094-X-530)/10.5);
	*y=((Y-370)/14.16);
//	*x=((4094-TP_SPI_RW(0x9400)-530)/10.5);
//	*y=((TP_SPI_RW(0xD400)-370)/14.16);
	#endif
}

void ADC_Config(void) {
	ADC_InitTypeDef ADC_InitStructure;
	DMA_InitTypeDef DMA_InitStructure;
	/* DMA1 channel1 configuration ----------------------------------------------*/

	DMA_DeInit(DMA1_Channel1);
	DMA_InitStructure.DMA_PeripheralBaseAddr = (u32)&ADC1->DR;//0x4001244C; //ADC1_DR_Address
	DMA_InitStructure.DMA_MemoryBaseAddr = (u32)&AdcValues;//&ADCConvertedValue;
	DMA_InitStructure.DMA_DIR = DMA_DIR_PeripheralSRC;
	DMA_InitStructure.DMA_BufferSize = 2;
	DMA_InitStructure.DMA_PeripheralInc = DMA_PeripheralInc_Disable;//DMA_PeripheralInc_Enable;//
	DMA_InitStructure.DMA_MemoryInc = DMA_MemoryInc_Enable;//DMA_MemoryInc_Disable;//
	DMA_InitStructure.DMA_PeripheralDataSize = DMA_PeripheralDataSize_HalfWord;
	DMA_InitStructure.DMA_MemoryDataSize = DMA_MemoryDataSize_HalfWord;
	DMA_InitStructure.DMA_Mode = DMA_Mode_Circular;
	DMA_InitStructure.DMA_Priority = DMA_Priority_High;
	DMA_InitStructure.DMA_M2M = DMA_M2M_Disable;
	DMA_Init(DMA1_Channel1, &DMA_InitStructure);
	DMA_Cmd(DMA1_Channel1, ENABLE);
	/* ADC1 Configuration ------------------------------------------------------*/
	ADC_InitStructure.ADC_Mode = ADC_Mode_Independent;
	ADC_InitStructure.ADC_ScanConvMode = ENABLE;
	ADC_InitStructure.ADC_ContinuousConvMode = ENABLE;
	ADC_InitStructure.ADC_ExternalTrigConv = ADC_ExternalTrigConv_None;
	ADC_InitStructure.ADC_DataAlign = ADC_DataAlign_Right;
	ADC_InitStructure.ADC_NbrOfChannel = 2;
	ADC_Init(ADC1, &ADC_InitStructure);

//#define ADC_SampleTime_1Cycles5                    ((uint8_t)0x00)
//#define ADC_SampleTime_7Cycles5                    ((uint8_t)0x01)
//#define ADC_SampleTime_13Cycles5                   ((uint8_t)0x02)
//#define ADC_SampleTime_28Cycles5                   ((uint8_t)0x03)
//#define ADC_SampleTime_41Cycles5                   ((uint8_t)0x04)
//#define ADC_SampleTime_55Cycles5                   ((uint8_t)0x05)
//#define ADC_SampleTime_71Cycles5                   ((uint8_t)0x06)
//#define ADC_SampleTime_239Cycles5                  ((uint8_t)0x07)

	//B0->Ain8
	ADC_RegularChannelConfig(ADC1, ADC_Channel_8, 1, ADC_SampleTime_71Cycles5);//ADC_SampleTime_55Cycles5
	ADC_RegularChannelConfig(ADC1, ADC_Channel_9, 2, ADC_SampleTime_71Cycles5);
	ADC_Cmd(ADC1, ENABLE);
	ADC_DMACmd(ADC1, ENABLE);
	ADC_ResetCalibration(ADC1);
	while(ADC_GetResetCalibrationStatus(ADC1)) { ; }
	ADC_StartCalibration(ADC1);
	while(ADC_GetCalibrationStatus(ADC1)) { ; }
	ADC_SoftwareStartConvCmd(ADC1, ENABLE);
}
u16 readADC1(u8 channel) {
	u16 Timeout=5000;
	ADC_RegularChannelConfig(ADC1, channel, 1, ADC_SampleTime_1Cycles5);//
	ADC_SoftwareStartConvCmd(ADC1, ENABLE);
	while(ADC_GetFlagStatus(ADC1, ADC_FLAG_EOC) == RESET) {Timeout--; if	(Timeout==0) { return 0; }};
	return ADC_GetConversionValue(ADC1);
}
void USB_Config(u8 State) {
	NVIC_InitTypeDef NVIC_InitStructure;
	GPIO_InitTypeDef GPIO_InitStructure;
//	EXTI_InitTypeDef EXTI_InitStructure;

	if (State==DISABLE) {
		BOARD_USB_ENABLE_PORT->BSRR =  BOARD_USB_ENABLE_PIN; //OFF
	} else { //ENABLE
		RCC_USBCLKConfig(RCC_USBCLKSource_PLLCLK_1Div5);
		RCC_APB1PeriphClockCmd(RCC_APB1Periph_USB, ENABLE);

		/* USB_DISCONNECT used as USB pull-up */
		GPIO_InitStructure.GPIO_Pin = BOARD_USB_ENABLE_PIN;
		GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
		GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_OD;
		GPIO_Init(BOARD_USB_ENABLE_PORT, &GPIO_InitStructure);
		//  USB_DISCONNECT->BRR = USB_DISCONNECT_PIN;

		/* Additional EXTI configuration (configure both edges) */
		/* Configure Tamper EXTI Line to generate an interrupt rising & falling edges */
//		EXTI_InitStructure.EXTI_Line = EXTI_Line13;
//		EXTI_InitStructure.EXTI_Mode = EXTI_Mode_Interrupt;
//		EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Rising_Falling;
//		EXTI_InitStructure.EXTI_LineCmd = ENABLE;
//		EXTI_Init(&EXTI_InitStructure);EXTI_Line13|

		/* Configure the EXTI line 18 connected internally to the USB IP */
//		EXTI_ClearITPendingBit(EXTI_Line18);
//		EXTI_InitStructure.EXTI_Line = EXTI_Line18;
//		EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Rising;
//		EXTI_InitStructure.EXTI_LineCmd = ENABLE;
//		EXTI_Init(&EXTI_InitStructure);

		/* 2 bit for pre-emption priority, 2 bits for subpriority */
		NVIC_PriorityGroupConfig(NVIC_PriorityGroup_2);
		/* Enable the USB interrupt */
		NVIC_InitStructure.NVIC_IRQChannel = USB_LP_CAN1_RX0_IRQn;
		NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 1;
		NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
		NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
		NVIC_Init(&NVIC_InitStructure);

		/* Enable the USB Wake-up interrupt */
		NVIC_InitStructure.NVIC_IRQChannel = USBWakeUp_IRQn;
		NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
		NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
		NVIC_Init(&NVIC_InitStructure);
		/* Set the Vector Table base address at 0x08000000 */
//		NVIC_InitStructure.NVIC_IRQChannel = USB_LP_CAN_RX0_IRQChannel;
//		NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 1;
//		NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
//		NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
//		NVIC_Init(&NVIC_InitStructure);
//		//einschalten
//		BOARD_USB_ENABLE_PORT->BRR =  BOARD_USB_ENABLE_PIN; //ON
		USB_Init();
	}
}
void RTC_Config(void) {
    RCC->APB1ENR |= RCC_APB1Periph_PWR|RCC_APB1Periph_BKP; //Enable PWR and BKP clocks
    PWR->CR      |= PWR_CR_DBP; //Allow access to BKP Domain
    /* Allow access to BKP Domain */
    PWR_BackupAccessCmd(ENABLE);
    /* Reset Backup Domain */
    BKP_DeInit();
    /* Enable LSE */
    RCC_LSEConfig(RCC_LSE_ON);
    while (RCC_GetFlagStatus(RCC_FLAG_LSERDY) == RESET) { ; }
    /* Select LSE as RTC Clock Source */
    RCC->BDCR |= RCC_RTCCLKSource_LSE;
    //RCC_RTCCLKConfig(RCC_RTCCLKSource_LSE);
    /* Enable RTC Clock */
    RCC_RTCCLKCmd(ENABLE);
    /* Wait for RTC registers synchronization */
    RTC_WaitForSynchro();
    /* Wait until last write operation on RTC registers has finished */
    RTC_WaitForLastTask();
    /* Enable the RTC Second */
    //  RTC_ITConfig(RTC_IT_SEC, ENABLE);
    RTC->CRH |= RTC_IT_SEC;
    NVIC->ISER[0]  = (1 << (0x03 & 0x1F));            // enable interrupt
    /* Wait until last write operation on RTC registers has finished */
    RTC_WaitForLastTask();
    /* Set RTC prescaler: set RTC period to 1sec */
    RTC_SetPrescaler(32767); /* RTC period = RTCCLK/RTC_PR = (32.768 KHz)/(32767+1) */
    /* Wait until last write operation on RTC registers has finished */
    RTC_WaitForLastTask();
}

void StopMode(void) {
//	ErrorStatus HSEStartUpStatus;
	//Ausschalten
	LED2_Off(); LED3_Off();
	LCD_Enable(0);
	USB_Config(DISABLE);
//	PWR_EnterSTANDBYMode(); //turn off
	PWR_EnterSTOPMode(PWR_Regulator_LowPower,PWR_STOPEntry_WFI);

	//Code wird nach External GPIO Interrupt ausgefhrt
	//EXTI0 auf Pin A0 (button Key 1) ist als einziger aktiv
//	RCC_HSEConfig(RCC_HSE_ON);
//	HSEStartUpStatus = RCC_WaitForHSEStartUp();
//	if(HSEStartUpStatus == SET)	{
//		RCC_PLLCmd(ENABLE);
//		while(RCC_GetFlagStatus(RCC_FLAG_PLLRDY) == RESET) { }
//		RCC_SYSCLKConfig(RCC_SYSCLKSource_PLLCLK);
//		while(RCC_GetSYSCLKSource() != 0x08) { }
//	}
//	stm32_Init(); //STM32_Init.c
	System_Init(); //hw_config.c
}

void delay_us(u16 i) { while( i--) { ASM_NOP } }
void delay_ms(u16 time) { while(time--) { delay_us(6000); } }
void Decrement_TimingDelay(void) { if (TimingDelay != 0x00) { TimingDelay--; } }
//Usart und Ausgabefunktionen #########################################################################
//#########################################################################################################
void UART_Print(char *p) {
	while (*p) {
		USART_SendData(USART1, *p++);
		while(USART_GetFlagStatus(USART1, USART_FLAG_TC) == RESET) {;}
	}
}
void UART_Print_DEC(char *info,int i) {
	char buf[15],*p;
	itoa(i, buf, 10);
	p=buf;
	while (*info) {
		USART_SendData(USART1, *info++);
		while(USART_GetFlagStatus(USART1, USART_FLAG_TC) == RESET) {;}
	}
	while (*p) {
		USART_SendData(USART1, *p++);
		while(USART_GetFlagStatus(USART1, USART_FLAG_TC) == RESET) {;}
	}
}
void UART_Print_FRESULT(char *info,int FRES) {
	const char *p;
	static char str[] =
		"OK\0" "NOT_READY\0" "NO_FILE\0" "FR_NO_PATH\0" "INVALID_NAME\0" "INVALID_DRIVE\0"
		"DENIED\0" "EXIST\0" "RW_ERROR\0" "WRITE_PROTECTED\0" "NOT_ENABLED\0"
		"NO_FILESYSTEM\0" "INVALID_OBJECT\0" "MKFS_ABORTED\0";
	u8 i=0;
	for (p = str, i = 0; i != FRES && *p; i++) {
		while(*p++);
	}
	while (*info) {
		USART_SendData(USART1, *info++);
		while(USART_GetFlagStatus(USART1, USART_FLAG_TC) == RESET) {;}
	}
	while (*p) {
		USART_SendData(USART1, *p++);
		while(USART_GetFlagStatus(USART1, USART_FLAG_TC) == RESET) {;}
	}
}
char *itoa(int n, char *s, int b) { //n=nummer,*s=buffer,b=basis (dec=10,hex=16)
	static char digits[] = "0123456789ABCDEFghijklmnopqrstuvwxyz";
	int i=0, sign;
	if ((sign = n) < 0)
		n = -n;
	do {
		s[i++] = digits[n % b];
	} while ((n /= b) > 0);
	if (sign < 0)
		s[i++] = '-';
	s[i] = '\0';
	return strrev(s);
}
char *strrev(char *str) {
	char *p1, *p2;
	if (!str || !*str) return str;
	for (p1 = str, p2 = str + strlen(str) - 1; p2 > p1; ++p1, --p2) {
		*p1 ^= *p2;
		*p2 ^= *p1;
		*p1 ^= *p2;
	}
	return str;
}
//I2C Funktionen ##########################################################################################
//#########################################################################################################
u8 I2C_Send(u8 adresse, u8 reg, u8 data) {
	I2C_SendStart();
	if(0==I2C_WriteByte(adresse<<1)) { I2C_SendStop(); return(0); }
  	if(0==I2C_WriteByte(reg)) { I2C_SendStop(); return(0); }
  	if(0==I2C_WriteByte(data)) { I2C_SendStop(); return(0); }
  	I2C_SendStop();
  	return(1);
}
u8 I2C_Read(u8 adresse, u8 reg, u8 *data) {
	I2C_SendStart();
	if(0==I2C_WriteByte(adresse<<1)) { I2C_SendStop(); return(0); }
	if(0==I2C_WriteByte(reg)) { I2C_SendStop(); return(0); }
	I2C_SendStart();
	if(0==I2C_WriteByte(adresse<<1|1)) { I2C_SendStop(); return(0); } //adresse + read Bit
  	*data=I2C_ReadByte();
	I2C_SendnoAck();
  	I2C_SendStop();
  	return(1);
}
//I2C Kernel
void I2C_SendStart() {
	I2C_DATA_H(); I2C_Delay_Long();
	I2C_SCL_H(); I2C_Delay_Long();
	I2C_DATA_L(); I2C_Delay_Long();
	I2C_SCL_L();
}
void I2C_SendStop() {
	I2C_SetDataPort_OUT();
	I2C_SCL_L(); I2C_Delay_Long();
    I2C_DATA_L(); I2C_Delay_Long();
	I2C_SCL_H(); I2C_Delay_Long();
	I2C_DATA_H();
}
void I2C_SendnoAck() {
	I2C_DATA_H(); I2C_Delay_Short();
	I2C_SCL_H(); I2C_Delay_Short();
	I2C_SCL_L(); I2C_Delay_Long();
	I2C_DATA_L();
}
u8 I2C_WriteByte(u8 m_data) {
	u8 j,tem;

	for(j=0;j<8;j++) {
		if((m_data<<j)&0x80) {
			I2C_DATA_H();
		} else {
			I2C_DATA_L();
		}
		I2C_Delay_Short();
		I2C_SCL_H();
		I2C_Delay_Long();
		I2C_SCL_L();
	}
	I2C_SetDataPort_IN();
	I2C_SCL_H();
	I2C_Delay_Long();
	if(I2C_DATA_STATE) {tem=0;} else {tem=1;}
	I2C_SCL_L();
	while(!(I2C_SCL_STATE)) {;} //Clockstretching: w8 4 Slave
    I2C_SetDataPort_OUT();

	return (tem);
}
u8 I2C_ReadByte(void) {
	u8 read=0,j; Delay=0;
	I2C_SetDataPort_IN();
	I2C_Delay_Long();
	for(j=8;j>0;j--) {
		I2C_SCL_H();
		I2C_Delay_Long();
		read=read<<1;
		if(I2C_DATA_STATE) { read++; }
		I2C_SCL_L();
		I2C_Delay_Long();
	}
	I2C_SetDataPort_OUT();
	return(read);
}

void I2C_SetDataPort_OUT(void) {
#ifdef IC2_DATA_MACRO_OUT
	IC2_DATA_MACRO_OUT; LED2_On();//
#else
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_InitStructure.GPIO_Pin =  I2C_PIN_DATA;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_OD;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(I2C_PORT_DATA, &GPIO_InitStructure);
#endif
}
void I2C_SetDataPort_IN(void) {
#ifdef IC2_DATA_MACRO_IN
	IC2_DATA_MACRO_IN; LED2_Off();//
#else
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_InitStructure.GPIO_Pin =  I2C_PIN_DATA;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(I2C_PORT_DATA, &GPIO_InitStructure);
#endif
}
void I2C_GPIO_Config(void) {
	GPIO_InitTypeDef GPIO_InitStructure;
	I2C_SCL_H();
	I2C_DATA_H();
	GPIO_InitStructure.GPIO_Pin =  I2C_PIN_DATA;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_OD;
	GPIO_InitStructure.GPIO_Speed =GPIO_Speed_50MHz;
	GPIO_Init(I2C_PORT_DATA, &GPIO_InitStructure);
	GPIO_InitStructure.GPIO_Pin =  I2C_PIN_SCL;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_OD;
	GPIO_InitStructure.GPIO_Speed =GPIO_Speed_50MHz;
	GPIO_Init(I2C_PORT_SCL, &GPIO_InitStructure);

}
/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
