#include <stm32f10x.h>
// Uncomment the line below to enable peripheral header file inclusion
//#include "stm32f10x_adc.h"
//#include "stm32f10x_bkp.h"
//#include "stm32f10x_can.h"
//#include "stm32f10x_cec.h"
//#include "stm32f10x_crc.h"
//#include "stm32f10x_dac.h"
//#include "stm32f10x_dbgmcu.h"
//#include "stm32f10x_dma.h"
//#include "stm32f10x_exti.h"
//#include "stm32f10x_flash.h"
//#include "stm32f10x_fsmc.h"
#include "stm32f10x_gpio.h"
//#include "stm32f10x_i2c.h"
//#include "stm32f10x_iwdg.h"
//#include "stm32f10x_pwr.h"
#include "stm32f10x_rcc.h"
//#include "stm32f10x_rtc.h"
//#include "stm32f10x_sdio.h"
//#include "stm32f10x_spi.h"
//#include "stm32f10x_tim.h"
#include "stm32f10x_usart.h"
//#include "stm32f10x_wwdg.h"
// High level functions for NVIC and SysTick (add-on to CMSIS functions)
#include "misc.h"

#include "ff_Macros.h"
#include "lcd.h"
#include <string.h> /* strcpy */
#include <stdio.h> /* sprintf */
#include "hw_config.h"
#include "sd_spi_stm32.h"


extern char buf[12],text[60];
u8 LFF_Y=2,LFF_X=85; //LCD Fat FS Offsets
char FF_Path[255]= "";
FRESULT ff_res;
FATFS fatfs;
FIL file;

void ff_remove(char* filepath) {
	ff_LCD_FRESULT(LFF_X,LFF_Y,"f_unlink:",f_unlink(filepath)); LFF_Y+=8;
	ff_LCD_Text(LFF_X,LFF_Y,"...auto read Disk:","",Color_Red); LFF_Y+=8;
	strcpy(FF_Path,"");
	ff_DiscFindFiles(FF_Path);
}
void ff_TxtWrite(char* filepath, char* input, char WriteMode) {
    FRESULT fr;    /* FatFs return code */
	UINT cnt=0;
	char *inf=text,len=0;

	SPI_SelectDevice(1); //0=off 1=SD 2=TP
    /* Open a text file */
    fr = f_open(&file, filepath, FA_OPEN_ALWAYS|FA_WRITE); //erstellen wenn nicht da
    if (fr) {
		ff_LCD_Text(LFF_X,LFF_Y,"Open:",filepath,Color_Red); LFF_Y+=8;
		ff_LCD_FRESULT(LFF_X,LFF_Y," ERR:",fr); LFF_Y+=8;
		return;
	} else {
		ff_LCD_Text(LFF_X,LFF_Y,"Open:",filepath,Color_Green); LFF_Y+=8;
	}
	if (WriteMode!=ff_WrMode_Override) {
		f_lseek(&file,f_size(&file)); //mit: am ande anfgen, ohne: anfang berschreiben
	}

    /* format and write Line */
	if (WriteMode==ff_WrMode_AddNewLine) {
		strcpy(text,"\r\n"); strcat(text,input);
	} else {
		strcpy(text,""); strcat(text,input);
	}

	while (*inf++) { len++; } //herrausfinden, wie lang der String ist (sizeof(text) gibt nur die gre des ganzen Arrays)
	ff_LCD_Text(LFF_X,LFF_Y,"zu schreibender Text: ",text,Color_Yellow); LFF_Y+=8;
	ff_LCD_FRESULT(LFF_X,LFF_Y,"f_write: ",f_write(&file,&text,len,&cnt)); LFF_Y+=8;
	strcpy(text,""); itoa(cnt, buf, 10); strcat(text,buf);
	ff_LCD_Text(LFF_X,LFF_Y,"geschriebene Zeichen: ",text,Color_Yellow); LFF_Y+=8;

	/* file info */
	strcpy(text,""); itoa(f_size(&file), buf, 10); strcat(text,buf); strcat(text," Bytes");
	ff_LCD_Text(LFF_X,LFF_Y,"file size now: ",text,Color_Green); LFF_Y+=8;

    f_close(&file);
}
void ff_TxtRead(char* filepath) {
    char line[46]; /* Line buffer */
    FRESULT fr;    /* FatFs return code */
	char cnt=0;

	SPI_SelectDevice(1); //0=off 1=SD 2=TP
    /* Open a text file */
    fr = f_open(&file, filepath, FA_READ);
    if (fr) {
		ff_LCD_Text(LFF_X,LFF_Y,"Open:",filepath,Color_Red); LFF_Y+=8;
		ff_LCD_FRESULT(LFF_X,LFF_Y," ERR:",fr); LFF_Y+=8;
		return;
	} else {
		ff_LCD_Text(LFF_X,LFF_Y,"Open:",filepath,Color_Green); LFF_Y+=8;
	}
    /* Read all lines and display it */
    while (f_gets(line, sizeof line, &file)) {
		if (line[0]==0) { continue; } //leere Zeilen berspringen
		ff_LCD_Text(LFF_X,LFF_Y,"",line,Color_White);
		ff_LCD_Text(309,LFF_Y,"\r\n","",0); //damit neue Zeilen auf dem uart ausgegeben werden
		LFF_Y+=8; cnt++;
		if (cnt==20) {
			ff_LCD_Text(LFF_X,LFF_Y,"","\r\n...19 (oder mehr) Zeilen -> Vorzeitiges ENDE",Color_Green); LFF_Y+=8;
			f_close(&file); return;
		}
	}
	ff_LCD_Text(LFF_X,LFF_Y,"","\r\n####End of File###",Color_Green); LFF_Y+=8;
    f_close(&file);

}
FRESULT ff_DiscFindFiles(char* path) {
	FRESULT res;
    FILINFO fno;
    DIR dir;
    int i;

    char *fn;   /* This function is assuming non-Unicode cfg. */
#if _USE_LFN
    static char lfn[_MAX_LFN + 1];   /* Buffer to store the LFN */
    fno.lfname = lfn;
    fno.lfsize = sizeof lfn;
#endif

	SPI_SelectDevice(1); //0=off 1=SD 2=TP

    res = f_opendir(&dir, path);                       /* Open the directory */
    if (res == FR_OK) {
        i = strlen(path);
		strcpy(text,path); strcat(text,"/"); //strcat(str,fn);
        for (;;) {

            res = f_readdir(&dir, &fno);                   /* Read a directory item */
            if (res != FR_OK || fno.fname[0] == 0) break;  /* Break on error or end of dir */
            if (fno.fname[0] == '.') continue;             /* Ignore dot entry */
#if _USE_LFN
            fn = *fno.lfname ? fno.lfname : fno.fname;
#else
            fn = fno.fname;
#endif
            if (fno.fattrib & AM_DIR) {                    /* It is a directory */
				sprintf(&path[i], "/%s", fn);
				ff_LCD_Text(LFF_X,LFF_Y,"DIR:",path,Color_Green);
				ff_LCD_Text(309,LFF_Y,"\r\n","",0); LFF_Y+=8;
                res = ff_DiscFindFiles(path);
                if (res != FR_OK) break;
                path[i] = 0;
            } else {                                       /* It is a file. */
				ff_LCD_Text(LFF_X,LFF_Y,text,fn,Color_Green);
				ff_LCD_Text(309,LFF_Y,"\r\n","",0); LFF_Y+=8;
            }
        }
        f_closedir(&dir);
    } else {
		ff_LCD_FRESULT(LFF_X,LFF_Y,"f_opendir:",res); LFF_Y+=8;
	}
	return res;
}
//Usart und LCD Ausgabefunktionen #########################################################################
//#########################################################################################################
void ff_LCD_FRESULT(u16 x, u16 y, char *info,int FRES) {
	char *p,*inf=info;
	static char str[] =
		"OK\0" "NOT_READY\0" "NO_FILE\0" "FR_NO_PATH\0" "INVALID_NAME\0" "INVALID_DRIVE\0"
		"DENIED\0" "EXIST\0" "RW_ERROR\0" "WRITE_PROTECTED\0" "NOT_ENABLED\0"
		"NO_FILESYSTEM\0" "INVALID_OBJECT\0" "MKFS_ABORTED\0";
	u8 i=0;	u8 len=0;
	for (p = str, i = 0; i != FRES && *p; i++) {
		while(*p++);
	}
	while (*inf++) { len++; }
	LCD_DrawText(x,y,info,Color_White,Color_Black,font_5x8);
	if (FRES==0) {
		LCD_DrawText(x+(len*5),y,p,Color_Green,Color_Black,font_5x8);
	} else {
		LCD_DrawText(x+(len*5),y,p,Color_Red,Color_Black,font_5x8);
	}
	//Usart ausgabe paralell dazu
	if (LCD_GetButtonstate(5)==BtnIsOn) { //switch Uart
		while (*info) {
			USART_SendData(USED_UART, *info++);
			while(USART_GetFlagStatus(USED_UART, USART_FLAG_TC) == RESET) {;}
		}
		while (*p) {
			USART_SendData(USED_UART, *p++);
			while(USART_GetFlagStatus(USED_UART, USART_FLAG_TC) == RESET) {;}
		}
	}
}
void ff_LCD_Text(u16 x, u16 y, char *info, char *text, u16 charColor) {
	char len=0,*inf=info;
	while (*inf++) { len++; }
	LCD_DrawText(x,y,info,Color_White,Color_Black,font_5x8);
	LCD_DrawText(x+(len*5),y,text,charColor,Color_Black,font_5x8);
	//Usart ausgabe paralell dazu
	if (LCD_GetButtonstate(5)==BtnIsOn) { //switch Uart
		while (*info) {
			USART_SendData(USED_UART, *info++);
			while(USART_GetFlagStatus(USED_UART, USART_FLAG_TC) == RESET) {;}
		}
		while (*text) {
			USART_SendData(USED_UART, *text++);
			while(USART_GetFlagStatus(USED_UART, USART_FLAG_TC) == RESET) {;}
		}
	}
}
/*******END OF FILE****/
