/**
  ******************************************************************************
  * @file    usbd_desc.c
  * @author  MCD Application Team
  * @version V1.0.0
  * @date    19-September-2011
  * @brief   This file provides the USBD descriptors and string formating method.
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2011 STMicroelectronics</center></h2>
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "usbd_core.h"
#include "usbd_desc.h"
#include "usbd_req.h"
#include "usbd_conf.h"
#include "usb_regs.h"

#define USBD_VID                     0x0483
#define USBD_PID                     0x0001

#define USBD_LANGID_STRING            0x409
#define USBD_MANUFACTURER_STRING      "STMicroelectronics"

#define USBD_PRODUCT_HS_STRING        "HID I/O in HS Mode"
#define USBD_SERIALNUMBER_HS_STRING   "00000000011D"

#define USBD_PRODUCT_FS_STRING        "JCH HID-Board"
#define USBD_SERIALNUMBER_FS_STRING   "00000000011E"


#define USBD_CONFIGURATION_HS_STRING  "HID Config"
#define USBD_INTERFACE_HS_STRING      "HID Interface"

#define USBD_CONFIGURATION_FS_STRING  "HID Config"
#define USBD_INTERFACE_FS_STRING      "HID Interface"


USBD_DEVICE USR_desc =
{
  USBD_USR_DeviceDescriptor,
  USBD_USR_LangIDStrDescriptor,
  USBD_USR_ManufacturerStrDescriptor,
  USBD_USR_ProductStrDescriptor,
  USBD_USR_SerialStrDescriptor,
  USBD_USR_ConfigStrDescriptor,
  USBD_USR_InterfaceStrDescriptor,

};

//#ifdef USB_OTG_HS_INTERNAL_DMA_ENABLED
//  #if defined ( __ICCARM__ ) /*!< IAR Compiler */
//    #pragma data_alignment=4
//  #endif
//#endif /* USB_OTG_HS_INTERNAL_DMA_ENABLED */
/* USB Standard Device Descriptor */
__ALIGN_BEGIN uint8_t USBD_DeviceDesc[USB_SIZ_DEVICE_DESC] __ALIGN_END =
  {
    0x12,                       /*bLength */
    USB_DEVICE_DESCRIPTOR_TYPE, /*bDescriptorType*/
    0x00,                       /*bcdUSB */
    0x02,
    0x00,                       /*bDeviceClass*/
    0x00,                       /*bDeviceSubClass*/
    0x00,                       /*bDeviceProtocol*/
    USB_OTG_MAX_EP0_SIZE,      /*bMaxPacketSize*/
    LOBYTE(USBD_VID),           /*idVendor*/
    HIBYTE(USBD_VID),           /*idVendor*/
    LOBYTE(USBD_PID),           /*idVendor*/
    HIBYTE(USBD_PID),           /*idVendor*/
    0x00,                       /*bcdDevice rel. 2.00*/
    0x02,
    USBD_IDX_MFC_STR,           /*Index of manufacturer  string*/
    USBD_IDX_PRODUCT_STR,       /*Index of product string*/
    USBD_IDX_SERIAL_STR,        /*Index of serial number string*/
    USBD_CFG_MAX_NUM            /*bNumConfigurations*/
  } ; /* USB_DeviceDescriptor */

#ifdef USB_OTG_HS_INTERNAL_DMA_ENABLED
  #if defined ( __ICCARM__ ) /*!< IAR Compiler */
    #pragma data_alignment=4
  #endif
#endif /* USB_OTG_HS_INTERNAL_DMA_ENABLED */
/* USB Standard Device Descriptor */
__ALIGN_BEGIN uint8_t USBD_DeviceQualifierDesc[USB_LEN_DEV_QUALIFIER_DESC] __ALIGN_END =
{
  USB_LEN_DEV_QUALIFIER_DESC,
  USB_DESC_TYPE_DEVICE_QUALIFIER,
  0x00,
  0x02,
  0x00,
  0x00,
  0x00,
  0x40,
  0x01,
  0x00,
};

#ifdef USB_OTG_HS_INTERNAL_DMA_ENABLED
  #if defined ( __ICCARM__ ) /*!< IAR Compiler */
    #pragma data_alignment=4
  #endif
#endif /* USB_OTG_HS_INTERNAL_DMA_ENABLED */
/* USB Standard Device Descriptor */
__ALIGN_BEGIN uint8_t USBD_LangIDDesc[USB_SIZ_STRING_LANGID] __ALIGN_END =
{
     USB_SIZ_STRING_LANGID,
     USB_DESC_TYPE_STRING,
     LOBYTE(USBD_LANGID_STRING),
     HIBYTE(USBD_LANGID_STRING),
};
/**
  * @}
  */


/** @defgroup USBD_DESC_Private_FunctionPrototypes
  * @{
  */
/**
  * @}
  */


/** @defgroup USBD_DESC_Private_Functions
  * @{
  */

/**
* @brief  USBD_USR_DeviceDescriptor
*         return the device descriptor
* @param  speed : current device speed
* @param  length : pointer to data length variable
* @retval pointer to descriptor buffer
*/
uint8_t *  USBD_USR_DeviceDescriptor( uint8_t speed , uint16_t *length)
{
  *length = sizeof(USBD_DeviceDesc);
  return USBD_DeviceDesc;
}

/**
* @brief  USBD_USR_LangIDStrDescriptor
*         return the LangID string descriptor
* @param  speed : current device speed
* @param  length : pointer to data length variable
* @retval pointer to descriptor buffer
*/
uint8_t *  USBD_USR_LangIDStrDescriptor( uint8_t speed , uint16_t *length)
{
  *length =  sizeof(USBD_LangIDDesc);
  return USBD_LangIDDesc;
}


/**
* @brief  USBD_USR_ProductStrDescriptor
*         return the product string descriptor
* @param  speed : current device speed
* @param  length : pointer to data length variable
* @retval pointer to descriptor buffer
*/
uint8_t *  USBD_USR_ProductStrDescriptor( uint8_t speed , uint16_t *length)
{


  if(speed == 0)
  {
    USBD_GetString ((uint8_t *)USBD_PRODUCT_HS_STRING, USBD_StrDesc, length);
  }
  else
  {
    USBD_GetString ((uint8_t *)USBD_PRODUCT_FS_STRING, USBD_StrDesc, length);
  }
  return USBD_StrDesc;
}

/**
* @brief  USBD_USR_ManufacturerStrDescriptor
*         return the manufacturer string descriptor
* @param  speed : current device speed
* @param  length : pointer to data length variable
* @retval pointer to descriptor buffer
*/
uint8_t *  USBD_USR_ManufacturerStrDescriptor( uint8_t speed , uint16_t *length)
{
  USBD_GetString ((uint8_t *)USBD_MANUFACTURER_STRING, USBD_StrDesc, length);
  return USBD_StrDesc;
}

/**
* @brief  USBD_USR_SerialStrDescriptor
*         return the serial number string descriptor
* @param  speed : current device speed
* @param  length : pointer to data length variable
* @retval pointer to descriptor buffer
*/
uint8_t *  USBD_USR_SerialStrDescriptor( uint8_t speed , uint16_t *length)
{
  if(speed  == USB_OTG_SPEED_HIGH)
  {
    USBD_GetString ((uint8_t *)USBD_SERIALNUMBER_HS_STRING, USBD_StrDesc, length);
  }
  else
  {
    USBD_GetString ((uint8_t *)USBD_SERIALNUMBER_FS_STRING, USBD_StrDesc, length);
  }
  return USBD_StrDesc;
}

/**
* @brief  USBD_USR_ConfigStrDescriptor
*         return the configuration string descriptor
* @param  speed : current device speed
* @param  length : pointer to data length variable
* @retval pointer to descriptor buffer
*/
uint8_t *  USBD_USR_ConfigStrDescriptor( uint8_t speed , uint16_t *length)
{
  if(speed  == USB_OTG_SPEED_HIGH)
  {
    USBD_GetString ((uint8_t *)USBD_CONFIGURATION_HS_STRING, USBD_StrDesc, length);
  }
  else
  {
    USBD_GetString ((uint8_t *)USBD_CONFIGURATION_FS_STRING, USBD_StrDesc, length);
  }
  return USBD_StrDesc;
}


/**
* @brief  USBD_USR_InterfaceStrDescriptor
*         return the interface string descriptor
* @param  speed : current device speed
* @param  length : pointer to data length variable
* @retval pointer to descriptor buffer
*/
uint8_t *  USBD_USR_InterfaceStrDescriptor( uint8_t speed , uint16_t *length)
{
  if(speed == 0)
  {
    USBD_GetString ((uint8_t *)USBD_INTERFACE_HS_STRING, USBD_StrDesc, length);
  }
  else
  {
    USBD_GetString ((uint8_t *)USBD_INTERFACE_FS_STRING, USBD_StrDesc, length);
  }
  return USBD_StrDesc;
}

/**
  * @}
  */
//#define INREPORT_SIZE    63 //Ausgang zum USB
//#define OUTREPORT_SIZE   63 //Eingang vom USB
//uint8_t InReport[  INREPORT_SIZE  ];             /* HID Input Report  */
//uint8_t OutReport[ OUTREPORT_SIZE ];             /* HID Output Report */

//const uint8_t HID_ReportDescriptor[] = {
//  HID_UsagePageVendor(0x00),
//  HID_Usage(           0x01                                   ),
//  HID_Collection(      HID_Application                        ),
//    HID_LogicalMin(    0                                      ),
//    HID_LogicalMaxS(   0xFF                                   ),
//    HID_ReportSize(    8                                      ),  // bits
//    HID_ReportCount(   INREPORT_SIZE                          ),  // bytes
//    HID_Usage(         0x01                                   ),
//    HID_Input(         HID_Data | HID_Variable | HID_Absolute ),
//    HID_ReportCount(   OUTREPORT_SIZE                         ),  // bytes
//    HID_Usage(         0x01                                   ),
//    HID_Output(        HID_Data | HID_Variable | HID_Absolute ),
//  HID_EndCollection,
//};
/* HID Report Descriptor */

//const WORD HID_ReportDescSize = sizeof(HID_ReportDescriptor);
//const WORD HID_ReportDescSize  5

///* USB Standard Device Descriptor */
//const uint8_t USB_DeviceDescriptor[] = {
//  USB_DEVICE_DESC_SIZE,              /* bLength */
//  USB_DEVICE_DESCRIPTOR_TYPE,        /* bDescriptorType */
//  WBVAL(0x0200), /* 1.10 */          /* bcdUSB */
//  0x00,                              /* bDeviceClass */
//  0x00,                              /* bDeviceSubClass */
//  0x00,                              /* bDeviceProtocol */
//  USB_MAX_PACKET0,                   /* bMaxPacketSize0 */
//  WBVAL(USB_VID),                     /* idVendor */
//  WBVAL(USB_PID),                     /* idProduct */
//  WBVAL(0x0200), /* 1.00 */          /* bcdDevice */
//  0x04,                              /* iManufacturer */
//  0x20,                              /* iProduct */
//  0x44,                              /* iSerialNumber */
//  0x01                               /* bNumConfigurations */
//};
//
///* USB Configuration Descriptor */
///*   All Descriptors (Configuration, Interface, Endpoint, Class, Vendor */
//const uint8_t USB_ConfigDescriptor[] = {
///* Configuration 1 */
//  USB_CONFIGUARTION_DESC_SIZE,       /* bLength */
//  USB_CONFIGURATION_DESCRIPTOR_TYPE, /* bDescriptorType */
//  WBVAL(                             /* wTotalLength */
//    USB_CONFIGUARTION_DESC_SIZE +
//    USB_INTERFACE_DESC_SIZE     +
//    HID_DESC_SIZE               +
//    USB_ENDPOINT_DESC_SIZE		+
//	USB_ENDPOINT_DESC_SIZE
//  ),
//  0x01,                              /* bNumInterfaces */
//  0x01,                              /* bConfigurationValue */
//  0x00,                              /* iConfiguration */
//  USB_CONFIG_BUS_POWERED /*|*/       /* bmAttributes */
///*USB_CONFIG_REMOTE_WAKEUP*/,
//  USB_CONFIG_POWER_MA(250),          /* bMaxPower */
///* Interface 0, Alternate Setting 0, HID Class */
//  USB_INTERFACE_DESC_SIZE,           /* bLength */
//  USB_INTERFACE_DESCRIPTOR_TYPE,     /* bDescriptorType */
//  0x00,                              /* bInterfaceNumber */
//  0x00,                              /* bAlternateSetting */
//  0x02,                              /* bNumEndpoints */
//  USB_DEVICE_CLASS_HUMAN_INTERFACE,  /* bInterfaceClass */
//  HID_SUBCLASS_NONE,                 /* bInterfaceSubClass */
//  HID_PROTOCOL_NONE,                 /* bInterfaceProtocol */
//  0x5E,                              /* 0x5EiInterface */
///* HID Class Descriptor */
///* HID_DESC_OFFSET = 0x0012 */
//  HID_DESC_SIZE,                     /* bLength */
//  HID_HID_DESCRIPTOR_TYPE,           /* bDescriptorType */
//  WBVAL(0x0200), /* 1.00 */          /* bcdHID */
//  0x00,                              /* bCountryCode */
//  0x02,                              /* bNumDescriptors */
//  HID_REPORT_DESCRIPTOR_TYPE,        /* bDescriptorType */
//  WBVAL(HID_REPORT_DESC_SIZE),       /* wDescriptorLength */
// /* Endpoint, HID Interrupt In //Ausgang zum PC*/
//  USB_ENDPOINT_DESC_SIZE,            /* bLength */
//  USB_ENDPOINT_DESCRIPTOR_TYPE,      /* bDescriptorType */
//  USB_ENDPOINT_IN(1),                /* bEndpointAddress */
   //USB_ENDPOINT_TYPE_ISOCHRONOUS,
//  USB_ENDPOINT_TYPE_INTERRUPT,      /* bmAttributes */
    //WBVAL(0x03FF),
//  WBVAL(0x0040),                     /* wMaxPacketSize */
//  0x20,          /* 32ms */          /* bInterval #####################################*/
///* Endpoint, HID Interrupt Out //Eingang vom PC*/
//  USB_ENDPOINT_DESC_SIZE,            /* bLength */
//  USB_ENDPOINT_DESCRIPTOR_TYPE,      /* bDescriptorType */
//  USB_ENDPOINT_OUT(1),               /* bEndpointAddress */
//  USB_ENDPOINT_TYPE_INTERRUPT,     /* bmAttributes */
//  WBVAL(0x0040),                     /* wMaxPacketSize */
//  0x20,          /* 32ms */          /* bInterval #####################################*/
///* Terminator */
//  0                                  /* bLength */
//};
//
///* USB String Descriptor (optional) */
//const uint8_t USB_StringDescriptor[] = {
///* Index 0x00: LANGID Codes */
//  0x04,                              /* bLength */
//  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
//  WBVAL(0x0409), /* US English */    /* wLANGID */
///* Index 0x04: Manufacturer */
//  0x1C,                              /* bLength */
//  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
//  'K',0,
//  'e',0,
//  'i',0,
//  'l',0,
//  ' ',0,
//  'S',0,
//  'o',0,
//  'f',0,
//  't',0,
//  'w',0,
//  'a',0,
//  'r',0,
//  'e',0,
///* Index 0x20: Product */
//  0x24,                              /* bLength */
//  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
//  'K',0,
//  'e',0,
//  'i',0,
//  'l',0,
//  ' ',0,
//  'M',0,
//  'C',0,
//  'B',0,
//  'S',0,
//  'T',0,
//  'M',0,
//  '3',0,
//  '2',0,
//  ' ',0,
//  'H',0,
//  'I',0,
//  'D',0,
///* Index 0x44: Serial Number */
//  0x1A,                              /* bLength */
//  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
//  'D',0,
//  'E',0,
//  'M',0,
//  'O',0,
//  ' ',0,
//  '0',0,
//  '1',0,
//  '.',0,
//  '0',0,
//  '0',0,
//  ' ',0,
//  ' ',0,
///* Index 0x5E: Interface 0, Alternate Setting 0 */
//  0x08,                              /* bLength */
//  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
//  'H',0,
//  '2',0,
//  'D',0,
//};

/******************* (C) COPYRIGHT 2011 STMicroelectronics *****END OF FILE****/

