/********************************************************************************
                           ###     ####       ###
                            #      #   #     #   #
                            #      ####      #   #
                            #      #   #     #  ##
                           ###     #   #      ####
********************************************************************************/
#include "stm32f4xx_it.h"
#include "boardcfg.h"
#include "main.h"
#include "usb_core.h"
#include "usbd_core.h"


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define CURSOR_STEP     7

extern uint8_t Buffer[6];
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
//extern __IO uint8_t DemoEnterCondition;
uint8_t Counter  = 0x00;
extern int8_t X_Offset;
extern int8_t Y_Offset;
extern vu8 U2RxBuff[],U2Rx,SameU2Rx;
/* Private function prototypes -----------------------------------------------*/
extern USB_OTG_CORE_HANDLE           USB_OTG_dev;
//static uint8_t *USBD_HID_GetPos (void);
extern uint32_t USBD_OTG_ISR_Handler (USB_OTG_CORE_HANDLE *pdev);
extern u8 Vsync;
extern uint32_t ADC_ConvertedValueX;

void SysTick_Handler(void)
{
  TimingDelay_Decrement();
}

void EXTI0_IRQHandler(void)
{
  if(EXTI_GetITStatus(EXTI_Line0) != RESET)
  {

    /* Clear the EXTI line 0 pending bit */
    EXTI_ClearITPendingBit(EXTI_Line0);
  }
}
void EXTI9_5_IRQHandler(void)
{
  if(EXTI_GetITStatus(EXTI_Line7) != RESET)
  { //Vsync
    //LED_Gr_Switch;
    switch (Vsync)
        {
          case 0:
            FIFO_WRST_L(); // pb8
            FIFO_WE_L(); // pb11
            //delay_us(5);
            Vsync = 1;
            FIFO_WE_H(); // pb11
            FIFO_WRST_H(); // pb8
            break;
          case 1:
            FIFO_WE_L(); // pb11
            Vsync = 2;
            break;
        }
    /* Clear the EXTI line 0 pending bit */
    EXTI_ClearITPendingBit(EXTI_Line7);
  }
}

void USART2_IRQHandler(void) //UART1
{
	if(USART_GetFlagStatus(USART2,USART_IT_RXNE)==SET) {
		U2RxBuff[U2Rx] = USART_ReceiveData(USART2);
		SameU2Rx = 0;
		if (U2Rx < 59) { U2Rx++; }
	}
}


/******************************************************************************/
/*                                 unbenutzt                                  */
/******************************************************************************/
void NMI_Handler(void)
{}
void HardFault_Handler(void)
{ while (1) {} }
void MemManage_Handler(void)
{ while (1) {} }
void BusFault_Handler(void)
{ while (1) {} }
void UsageFault_Handler(void)
{ while (1) {} }
void SVC_Handler(void)
{}
void DebugMon_Handler(void)
{}
void PendSV_Handler(void)
{}
/******************* (C) COPYRIGHT 2011 STMicroelectronics *****END OF FILE****/
