#include "boardcfg.h"
#include "lcd.h"
#include "LCD18.h"
#include "font.h"
#include "hw_config.h"
#include "main.h"
#include "Camera.h"
#include "usbd_hid_core.h"

//I2c Test
#include "stm32f4xx_gpio.h"
#include "stm32f4xx_i2c.h"

#include "nokia_5110.h"

extern USB_OTG_CORE_HANDLE  USB_OTG_dev;
extern u8 OutReport[HID_OUT_PACKET],InReport[HID_IN_PACKET];
extern vu16 ADCConvertedValue;

vu32 TimingDelay;
u32 ADC_ConvertedValueX = 0;
vu8 U2RxBuff[60], U2Rx, SameU2Rx, LastU2Rx, TxCounter, X_Offset,  Y_Offset, Z_Offset  = 0x00;
u8 Buffer[6];
//u8 InBuffer[64], OutBuffer[63];
char buf[22],text[22] = "";
u16 Data,PenPress;
vu8 Vsync=0;

vs16 x,y;
u8 b_Modus,red,green,blue;
u16 H,W,red_Cnt,green_Cnt,blue_Cnt;
bool Init = false;

//GUI Test ber USB
char USB_Txt1[30],USB_BtnTxt1[20];

int main(void) {
	System_Init();

	b_Modus = 2;

	if (true) { //Nokia 5110 disp
        N5110_init();

		N5110_write_english_string(0,0,"Nokia 5110 LCD");
        N5110_write_english_string(0,1,"---=======---");
		N5110_write_english_string(0,2,"---=======---");
		N5110_write_english_string(0,3," Pixel: 84x48 ");
		N5110_write_english_string(0,4,"  mit font6x8 ");
		N5110_write_english_string(5,5,"X=5,Y=5");
	}
    if (true) { //LCD1.8 test
        Lcd18_Init();
        LCD18_Clear(LCD_Black);

        LCD18_DrawText(5,5,"font_4x6",LCD_Green,LCD_Black,font_4x6);
        LCD18_DrawText(5,5+6,"font_5x8",LCD_Green,LCD_Black,font_5x8);
        LCD18_DrawText(5,5+6+8,"font_5x12",LCD_Green,LCD_Black,font_5x12);
        LCD18_DrawText(5,5+6+8+12,"font_6x10",LCD_Green,LCD_Black,font_6x10);
        LCD18_DrawText(5,5+6+8+12+10,"font_8x12",LCD_Green,LCD_Black,font_8x12);
        LCD18_DrawText(5,5+6+8+12+10+12,"font_8x16",LCD_Blue,LCD_Black,font_8x16);
        LCD18_DrawText(5,5+6+8+12+10+12+16,"font_12x16",LCD_Green,LCD_Black,font_12x16);
        LCD18_DrawText(5,5+6+8+12+10+12+16+16,"22x36",LCD_Green,LCD_Black,font_22x36);

        itoa(blue, buf, 10); strcat(text,buf);
        LCD18_DrawText(5,5+6+8+12+10+12+16+16+36,text,LCD_White,LCD_Green,font_22x36);
    }
	if (false) { //hardware I2C test
		/* Start the config sequence */
		I2C_GenerateSTART(I2C1, ENABLE);
		LED_Or_On;
		while (!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_MODE_SELECT)) { ; }
		LED_Bl_On;
  		I2C_Send7bitAddress(I2C1, 32<<1, I2C_Direction_Transmitter);
  		while (!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_TRANSMITTER_MODE_SELECTED)) { ; }
  		I2C_SendData(I2C1, 18);
  		while (!I2C_CheckEvent(I2C1, I2C_EVENT_MASTER_BYTE_TRANSMITTING)) { ; }
		I2C_SendData(I2C1, 170);
		while(!I2C_GetFlagStatus(I2C1, I2C_FLAG_BTF)) { ; }
  		I2C_GenerateSTOP(I2C1, ENABLE);
  		LED_R_On;
		LED_Gr_On;
	} //hardware I2C test

	while(1){
		#ifdef TP_PenDown
		if (TP_PenDown) {
			SPI_SelectDevice(1); //LCD Touch
			TP_GetAdXY(&x,&y);
		} else {
			x=0;y=0;
		}
		//schaltflchen abfragen
		if (x>0&&y>0){
			PenPress++;
		} else {
			PenPress=0;
		}
		if(PenPress==5||PenPress==0){
			LCD_DrawButtons(x,y);
		}
		#else
		SPI_SelectDevice(1); //LCD Touch
		TP_GetAdXY(&x,&y);
		LCD_DrawButtons(x,y);
		#endif

		switch (b_Modus) {
			case 1: Mode_PaintDemo(); break;
			case 2: Mode_CamDemo(); break;
			case 3: Mode_Motion(); break;
		}

		if (Button_Down) {
 			//LED_R_Off;
            //while(Button_Down){;} //w8 4 button release

 			StopMode();
			b_Modus=1; Init=false;
			while(Button_Down){;} //w8 4 button release
		} else {
			//LED_R_On;
		}


	}
}

void Mode_PaintDemo() { //##########################################################
	if (!Init) {
		Init = true;
		LCD_ClearBars(false);
		LCD_ClearButtons(false);
		//rects
		LCD_DrawFilledRect(81,1,178,238,0x0000);
		LCD_DrawFilledRect(0,180,60,320,0x8410);
		LCD_DrawFilledRect(0,0,180,80,0x8410);
		LCD_DrawRect(80,0,180,240,0xFFFF);
		LCD_DrawRect(3,81,20,72,0xFFFF);
		LCD_DrawFilledRect(4,82,18,70,0x0000);
		//text
		LCD_DrawText(87,182,"Joe-C STMF4 Discovery Paint  ",0xF800,0x8410,font_8x16);
		LCD_DrawText(11,16,"X: 88888",0x001F,0x8410,font_8x16);
		LCD_DrawText(11,32,"Y: 88888",0x001F,0x8410,font_8x16);
		LCD_DrawText(3,65,"Encoder:",0xFFFF,0x8410,font_8x16);
		LCD_DrawText(17,83,"65535",0xFFFF,0x0000,font_8x16);
		//Buttons
		LCD_SetButtons(1,9,200,31,58," Paint",BtnNormal,font_8x16,0x0000,0x8410);
		LCD_SetButtons(2,72,200,31,57," Clear",BtnNormal,font_8x16,0x0000,0x8410);
		LCD_SetButtons(3,161,200,31,53," Cam",BtnNormal,font_8x16,0x0000,0x8410);
		LCD_SetButtons(4,243,200,31,69," Motion",BtnNormal,font_8x16,0x0000,0x8410);
		LCD_DrawButtons(0,0);
//		SPI_SelectDevice(1); //LCD Touch

        LCD_DrawText(85,15,"font_4x6",LCD_Green,LCD_Black,font_4x6);
        LCD_DrawText(85,21,"font_5x8",LCD_Green,LCD_Black,font_5x8);
        LCD_DrawText(85,29,"font_5x12",LCD_Green,LCD_Black,font_5x12);
        LCD_DrawText(85,41,"font_6x10",LCD_Green,LCD_Black,font_6x10);
        LCD_DrawText(85,51,"font_8x12",LCD_Green,LCD_Black,font_8x12);
        LCD_DrawText(85,63,"font_8x16",LCD_Blue,LCD_Black,font_8x16);
        LCD_DrawText(85,79,"font_12x16",LCD_Green,LCD_Black,font_12x16);
        LCD_DrawText(85,95,"22x36",LCD_Green,LCD_Black,font_22x36);
        LCD_DrawText(85,131,"PASS",LCD_White,LCD_Green,font_22x36);
	}

	if (x==0&&y==0) {
		strcpy(text,"X: up");
		LCD_DrawTextBlock(11,16,text,0x001F,0x8410,8," ",font_8x16);
		strcpy(text,"Y: up   ");
		LCD_DrawTextBlock(11,32,text,0x001F,0x8410,8," ",font_8x16);
	} else {
		strcpy(text,"X: ");
		itoa(x, buf, 10); strcat(text,buf);
		LCD_DrawTextBlock(11,16,text,0x001F,0x8410,8," ",font_8x16);
		strcpy(text,"Y: ");
		itoa(y, buf, 10); strcat(text,buf);
		LCD_DrawTextBlock(11,32,text,0x001F,0x8410,8," ",font_8x16);
	}

	strcpy(text,""); //
	//Data = readADC1(1); ADCConvertedValue//ADC1->DR
	itoa(TIM8->CNT-32767, buf, 10); strcat(text,buf);
	LCD_DrawTextBlock(17,83,text,0xFFFF,0x0000,6," ",font_8x16);

	//Zeichnen (wenn innerhalb des Zeichenfeldes)
	if (x>80&&y<180) {
		if (Button_Down) {
			LCD_DrawPoint( x, y, LCD_White);
		} else {
			LCD_DrawPoint( x, y, LCD_White);
			LCD_DrawPoint( x+1, y, LCD_White);
			LCD_DrawPoint( x, y+1, LCD_White);
			LCD_DrawPoint( x+1, y+1, LCD_White);
        }
	}
	if (b_Modus==1) {
		InReport[1] = ADCConvertedValue>>8; InReport[2] = ADCConvertedValue;
	} //if
}
void Mode_CamDemo() { //##########################################################
	if (!Init) {
		Init = true;
		I2C_Send(33,18,128); delay_us(2000);
		LCD_ClearBars(false);
		LCD_ClearButtons(false);
		//Rechtecke:
        LCD_DrawFilledRect(81,1,178,238,0x0000);
        LCD_DrawFilledRect(0,180,60,320,0x8410);
        LCD_DrawFilledRect(0,0,180,80,0x8410);
        LCD_DrawRect(80,0,180,240,0xFFFF);
        LCD_DrawRect(3,21,52,72,0xFFFF);
        LCD_DrawFilledRect(4,22,50,70,0x0000);
        //Texte:
        if (OV7670_init()==1) {
            LCD_DrawText(87,182,"Joe-C STMF4 Discovery Camera    ",0x07E0,0x8410,font_8x16);
        } else {
            LCD_DrawText(87,182,"Camera Init FAIL                ",LCD_Red,0x8410,font_8x16);
        }
        LCD_DrawText(3,5,"Pixel RGB",0xFFFF,0x8410,font_8x16);
        LCD_DrawText(17,24,"65535",0xF800,0x0000,font_8x16);
        LCD_DrawText(17,40,"65535",0x07E0,0x0000,font_8x16);
        LCD_DrawText(17,56,"65535",0x001F,0x0000,font_8x16);
        //Buttons:
        LCD_SetButtons(1,9,200,31,58," Paint",BtnNormal,font_8x16,0x0000,0x8410);
        LCD_SetButtons(2,72,200,31,57," Clear",BtnNormal,font_8x16,0x0000,0x8410);
        LCD_SetButtons(3,161,200,31,53," Cam",BtnNormal,font_8x16,0x0000,0x8410);
        LCD_SetButtons(4,243,200,31,69," Motion",BtnNormal,font_8x16,0x0000,0x8410);
        LCD_SetButtons(5,3,80,30,71,"Col R",BtnAnzeige,font_8x16,0x0000,0x8410);
        LCD_SetButtons(6,3,115,30,71,"Chan G",BtnAnzeige,font_8x16,0x0000,0x8410);
//        LCD_SetButtonstate(5,BtnSetOff);
//        LCD_SetButtonstate(6,BtnSetOff);
        //Progressbars:
		LCD_DrawButtons(0,0);
//		LCD_SetProgBar(0,90,50,20,200,255,LCD_Red,1,128);//nr,X,Y,H,W,Max,Color,Typ,Value
	}
    if (Vsync != 2){ return; }
    Vsync++;

    LCD_SetWindows(1,1,178,238);
    LCD_SetCursor(81,1);
    LCD_WriteRAM_Prepare();
    LED_Bl_On;
    red_Cnt=0; green_Cnt=0; blue_Cnt=0;
    //reset
    FIFO_RRST_L(); // pb10 Read reset
    FIFO_RD_L(); FIFO_RD_H(); // pb11 Read clock
    FIFO_RRST_H(); // pb10 Read reset
    FIFO_RD_L(); FIFO_RD_H(); // pb11 Read clock

    FIFO_CS_L(); // pb9 Output enable
    for(H=0;H<240;H++) {
        for(W=0;W<320;W++) {
            FIFO_RD_L(); // pb11 Read clock
            //Data = (GPIOC->IDR>>8) & 0x00ff;
            Data = (GPIOC->IDR) & 0xff00;
            FIFO_RD_H(); // pb11 Read clock
            //High byte
            FIFO_RD_L(); // pb11 Read clock
            //Data |= (GPIOC->IDR) & 0xff00;
            Data |= (GPIOC->IDR>>8) & 0x00ff;
            FIFO_RD_H(); // pb11 Read clock

            //nur auf das Fenster beschraenken
            if(W>237||H>177) { continue; }

            //RGB 5-6-5 aufspalten
            red = 0x001F & (Data>>11); //0-31
            green = 0x003F & (Data>>5); //0-63
            blue = 0x001F & Data; //0-31

            if (red>25&&green<30&&blue<20) {
                red_Cnt++;
            } else {
                if (LCD_GetButtonstate(5)==BtnIsOn) {
                    Data = 0;
                }
            }
            if (green>30&&blue<20&&red<25) {
                green_Cnt++;
            }
            if (blue>25&&green<30&&red<25) {
                blue_Cnt++;
            }

            if (LCD_GetButtonstate(6)==BtnIsOn) {
                red=0; blue=0;
                //RGB 5-6-5 zusammenfhren
                Data = (red<<11)|(green<<5)|blue;
            }

            LCD_WriteRAM(Data);
        }
    }
    FIFO_CS_H(); // pb9 Output enable
    Vsync = 0;
    LED_Bl_Off;

    LCD_SetWindows(0,0,240,320);
    strcpy(text,"");
	itoa(red_Cnt, buf, 10); strcat(text,buf);
    LCD_DrawTextBlock(17,24,text,LCD_Red,0x0000,6," ",font_8x16);
    strcpy(text,"");
	itoa(green_Cnt, buf, 10); strcat(text,buf);
    LCD_DrawTextBlock(17,40,text,LCD_Green,0x0000,6," ",font_8x16);
    strcpy(text,"");
	itoa(blue_Cnt, buf, 10); strcat(text,buf);
    LCD_DrawTextBlock(17,56,text,LCD_Blue,0x0000,6," ",font_8x16);
}
void Mode_Motion() { //##########################################################
	SPI_SelectDevice(2); //Motion
	if (!Init) {
        Init = true;
		Motion_init();
		LCD_ClearBars(false);
		LCD_ClearButtons(false);
		//rects
		LCD_DrawFilledRect(81,1,178,238,0x0000);
		LCD_DrawFilledRect(0,180,60,320,0x8410);
		LCD_DrawFilledRect(0,0,180,80,0x8410);
		LCD_DrawRect(80,0,180,240,0xFFFF);
		LCD_DrawRect(3,19,20,72,0xFFFF);
		LCD_DrawFilledRect(4,20,18,70,0x0000);
		LCD_DrawRect(3,58,20,72,0xFFFF);
		LCD_DrawFilledRect(4,59,18,70,0x0000);
		LCD_DrawRect(3,98,20,72,0xFFFF);
		LCD_DrawFilledRect(4,99,18,70,0x0000);
		//text
		LCD_DrawText(87,182,"Joe-C STMF4 Discovery Motion",0x001F,0x8410,font_8x16);
		LCD_DrawText(3,3,"Z Achse:",0xF800,0x8410,font_8x16);
		LCD_DrawText(17,22,"88888",0xF800,0x0000,font_8x16);
		LCD_DrawText(3,42,"X Achse:",0x001F,0x8410,font_8x16);
		LCD_DrawText(17,60,"88888",0x001F,0x0000,font_8x16);
		LCD_DrawText(3,82,"Y Achse:",0x001F,0x8410,font_8x16);
		LCD_DrawText(17,100,"88888",0x001F,0x0000,font_8x16);
		//button
		LCD_SetButtons(1,9,200,31,58," Paint",BtnNormal,font_8x16,0x0000,0x8410);
		LCD_SetButtons(2,72,200,31,57," Clear",BtnNormal,font_8x16,0x0000,0x8410);
		LCD_SetButtons(3,161,200,31,53," Cam",BtnNormal,font_8x16,0x0000,0x8410);
		LCD_SetButtons(4,243,200,31,69," Motion",BtnNormal,font_8x16,0x0000,0x8410);
		//bar
		LCD_SetProgBar(1,116,59,18,180,255,0x001F,HORI,58);
		LCD_SetProgBar(2,116,100,18,180,255,0x001F,HORI,58);
		LCD_SetProgBar(3,89,10,162,21,255,0xF800,VERT,58);

		LCD_DrawButtons(0,0);
		LCD_DrawBars();
	}
//spi max 10 mhz

	LIS302DL_Read(Buffer, LIS302DL_OUT_X_ADDR, 6);
	X_Offset = Buffer[0]-190;
	Y_Offset = Buffer[2]-190;
	Z_Offset = Buffer[4]+100;
	strcpy(text,"");//Z_Offset
	itoa(Z_Offset, buf, 10); strcat(text,buf);
	LCD_DrawTextBlock(17,22,text,0xF800,0x0000,6," ",font_8x16);
	strcpy(text,"");//x
	itoa(X_Offset, buf, 10); strcat(text,buf);
	LCD_DrawTextBlock(17,60,text,0x001F,0x0000,6," ",font_8x16);
	strcpy(text,"");//y
	itoa(Y_Offset, buf, 10); strcat(text,buf);
	LCD_DrawTextBlock(17,100,text,0x001F,0x0000,6," ",font_8x16);

	LCD_SetBarVal(3,Z_Offset);
	LCD_SetBarVal(1,Y_Offset);
	LCD_SetBarVal(2,X_Offset);
	LCD_DrawBars();
	if (b_Modus==3) {
		InReport[1] = Buffer[0]; InReport[2] = 0;
		InReport[3] = Buffer[2]; InReport[4] = 0;
		InReport[5] = Buffer[4]; InReport[6] = 0;
	} //if
}
//################################################################################
void LCD_BTN_down(u8 index) {
	switch (index) {
		case 0:  break;//Init=false;
		case 1: Init=false; b_Modus = 1; break;
		case 2: InReport[14]=1; //Clearbefehl
				LCD_DrawFilledRect(81,1,178,238,LCD_Black);
		 		LCD_DrawText(82, 182, " Zeichenfeld gelscht...    ",LCD_Red,0x8410,font_8x16);

		 		//Opgal R25 Test
		 		u8 txdata[] = {169,5,106,0,104}; //Shutter

		 		u8 step=0;
		 		u8 len = sizeof(txdata);
		 		while (len--) {
                    USART_SendData(USART2, txdata[step++]);
                    while(USART_GetFlagStatus(USART2, USART_FLAG_TXE) == RESET) {}
                }
				break;
		case 3: Init=false; b_Modus = 2; break;
		case 4: Init=false; b_Modus = 3; break;
		case 5: break;
		case 6: break;
	}
}
void LCD_BTN_up(u8 index) {}
// USB  ############################################################################################
//##################################################################################################
void GetInReport (void) { //c Ausgang USB->PC
	if (b_Modus==0) { return; } //if
	if (U2Rx > 0) {
		if (SameU2Rx > 3) {
			//es wurde was empfangen und nach der 3. abfrage war die menge gleich
			b_Modus=0; delay_us(100);
			InReport[0] = 9;//uart1 rx
			InReport[1] = U2Rx++;
			while (U2Rx!=0)	{
			    U2Rx--;
				InReport[2+U2Rx] = U2RxBuff[U2Rx];
			}
			USBD_HID_SendReport(&USB_OTG_dev, InReport, HID_IN_PACKET);
			delay_us(1000); b_Modus=3;
//			InReport[0] = b_Modus;
			LED_Bl_On;
			SameU2Rx = 0; return;
		}
		if (LastU2Rx == U2Rx) {
			SameU2Rx++;
		} else { SameU2Rx=0; }
		LastU2Rx = U2Rx;
	}
	//nix vom UART2 empfangen
	switch (b_Modus) {
		case 1:
		case 2:
		case 3:
		case 4:
		    InReport[0] = b_Modus;//analogabfrage
			if (Button_Down) {
				InReport[20] = 2;
			} else {
				InReport[20] = 3;
			}
			InReport[10] = x>>8; InReport[11] = x;
			InReport[12] = y>>8; InReport[13] = y;
			USBD_HID_SendReport (&USB_OTG_dev, InReport, HID_IN_PACKET);
			delay_us(100);
			//Clearbefehl lschen
			if (InReport[14]==1) {  InReport[14]=0; }
			break;
		default:
		    InReport[0] = b_Modus;
		    USBD_HID_SendReport (&USB_OTG_dev, InReport, HID_IN_PACKET);
			break;
	}
}
void SetOutReport (void) { //c Eingang USB<-PC
	u16 X,Y,H,W,Col1,Col2,Val;
	u8 i;

	Init=false;
	b_Modus = OutReport[0];
//	USBD_HID_SendReport (&USB_OTG_dev, OutReport, HID_OUT_PACKET);
	switch (b_Modus) {
		case 1:
			break;
		case 2:
			if (OutReport[1]==0) {
				LED_Bl_On;
			} else {
				LED_Bl_Off;
			}
			break;
		case 3: break; //Modus_PaintDemo
		case 4: break; //Modus_CamDemo
		case 5: break; //Modus_GUIDemo
		case 10: //UART2 Tx
			TxCounter = 2; b_Modus = 3; OutReport[0] = 0;
			while (OutReport[1]!=0) {
				USART_SendData(USART2, OutReport[TxCounter]);
				OutReport[TxCounter] = 0;
				while(USART_GetFlagStatus(USART2, USART_FLAG_TXE) == RESET) {}
				TxCounter++; OutReport[1]--;
			}
			USBD_HID_SendReport (&USB_OTG_dev, OutReport, HID_OUT_PACKET); break;
        case 19: //Cam control
            wrOV7670Reg(OutReport[1],OutReport[2]);
            b_Modus = 2; //Modus_Cam
            Init=true;
            break;
		case 20: //Clear Screen
			b_Modus = 4; //Modus_GUIDemo
			LCD_Clear(LCD_Black);
			break;
		case 21: //set txt
			b_Modus = 5; //Modus_GUIDemo
			X=OutReport[1]<<8|OutReport[2];
			Y=OutReport[3]<<8|OutReport[4];
			Col1=OutReport[5]<<8|OutReport[6];
			Col2=OutReport[7]<<8|OutReport[8];
            for(i=0;i<OutReport[10];i++) {
                USB_Txt1[i]=OutReport[11+i];
            }
            USB_Txt1[OutReport[10]]=0;//end of string
            LCD_DrawText(X, Y,&USB_Txt1[0] ,Col1,Col2,OutReport[9]);
			break;
		case 22: //set btn
			b_Modus = 5; //Modus_GUIDemo
			X=OutReport[1]<<8|OutReport[2];
			Y=OutReport[3]<<8|OutReport[4];
			H=OutReport[5]<<8|OutReport[6];
			W=OutReport[7]<<8|OutReport[8];
			Col1=OutReport[11]<<8|OutReport[12];//ForeCol
			Col2=OutReport[13]<<8|OutReport[14];//BackCol
            for(i=0;i<OutReport[15];i++) {
                USB_BtnTxt1[i]=OutReport[16+i];
            }
            USB_BtnTxt1[OutReport[15]]=0; //end of string
            LCD_SetButtons(0,X,Y,H,W,&USB_BtnTxt1[0],OutReport[9],OutReport[10],Col1,Col2);//nr,X,Y,H,W,txt,font,front,back
			LCD_DrawRect(X-1,Y-1,H+2,W+2,LCD_Black);//X,Y,H,W,C
			LCD_DrawButtons(0,0); //initialisieren
			break;
        case 23: //set bar
			b_Modus = 5; //Modus_GUIDemo
			X=OutReport[1]<<8|OutReport[2];
			Y=OutReport[3]<<8|OutReport[4];
			H=OutReport[5]<<8|OutReport[6];
			W=OutReport[7]<<8|OutReport[8];
			Col1=OutReport[9]<<8|OutReport[10];//max
			Col2=OutReport[11]<<8|OutReport[12];//farbe
			Val=OutReport[14]<<8|OutReport[15];//val
			if (OutReport[13]==1) { //richtung
			    LCD_SetProgBar(0,X,Y,H,W,Col1,Col2,VERT,Val);
			} else {
			    LCD_SetProgBar(0,X,Y,H,W,Col1,Col2,HORI,Val);
			}
			LCD_DrawRect(X-1,Y-1,H+2,W+2,LCD_Black);//X,Y,H,W,C
			LCD_DrawBars(); //initialisieren
			break;
        case 24: //set rechtecke
			b_Modus = 5; //Modus_GUIDemo
			X=OutReport[1]<<8|OutReport[2];
			Y=OutReport[3]<<8|OutReport[4];
			H=OutReport[5]<<8|OutReport[6];
			W=OutReport[7]<<8|OutReport[8];
			Col1=OutReport[9]<<8|OutReport[10];//farbe
			if (OutReport[11]==1) { //gefllt
			    LCD_DrawFilledRect(X,Y,H,W,Col1);
			    //LCD_DrawEllipse(X,Y,H,W,Col1);
			} else {
			    LCD_DrawRect(X,Y,H,W,Col1);
			}
			break;
        case 25: //set line
			b_Modus = 5; //Modus_GUIDemo
			X=OutReport[1]<<8|OutReport[2];
			Y=OutReport[3]<<8|OutReport[4];
			H=OutReport[5]<<8|OutReport[6];//len
			Col1=OutReport[8]<<8|OutReport[9];//farbe
			if (OutReport[7]==1) {
                LCD_DrawLine(X,Y,H,VERT,Col1);
			} else {
			    LCD_DrawLine(X,Y,H,HORI,Col1);
			}
			break;
		default:
			USBD_HID_SendReport (&USB_OTG_dev, OutReport, HID_OUT_PACKET);
			break;
	}
//   LED_Bl_On;
}

void Delay_sys(vu32 nTime) {
  TimingDelay = nTime;
  while(TimingDelay != 0);
}
void TimingDelay_Decrement(void) {
  if (TimingDelay != 0x00) { TimingDelay--; }
}
void Fail_Handler(void) {
  while(1) {
	GPIOD->ODR ^= GPIO_Pin_14;//toggle red
    Delay_sys(5);
  }
}

#ifdef  USE_FULL_ASSERT
void assert_failed(u8* file, u32 line)
{ while (1) {} }
#endif

/******************* (C) COPYRIGHT 2011 STMicroelectronics *****END OF FILE****/
