#include "boardcfg.h"
#include "lcd.h"
#include "hw_config.h"
#include "usbd_hid_core.h"
#include "usbd_usr.h"
#include "usbd_desc.h"
#include "system_stm32f4xx.h"

__ALIGN_BEGIN USB_OTG_CORE_HANDLE  USB_OTG_dev __ALIGN_END;

vu16 ADCConvertedValue;
u16 ADCValues[6];
u8 ADCVal_Count = 0;

static vu32 TimingDelay = 0;
u16 Delay;
u8 Last_Device = 255;

void STM32_GPIO_Setup() {
	//GPIOI Offline
	//GPIOH Offline
	//GPIOG Offline
	//GPIOF Offline
	//GPIOE Setup:
	RCC->AHB1ENR |= 1<<4; 	//Clock einschalten
	GPIOE->MODER = 0x55555510;   //PP PP PP PP PP PP PP PP  | PP PP PP PP IF PP IF IF  Pin 15-8|7-0
	GPIOE->OTYPER = 0x0000;   //TypeRegister (PP oder OD)
	GPIOE->OSPEEDR = 0xFFFFE800;   //Speed Control
	GPIOE->PUPDR = 0x00000000;   //-- -- -- -- -- -- -- --  | -- -- -- -- -- -- -- --
	//GPIOD Setup:
	RCC->AHB1ENR |= 1<<3; 	//Clock einschalten
	GPIOD->MODER = 0x55552955;   //PP PP PP PP PP PP PP PP  | IF AP AP PP PP PP PP PP  Pin 15-8|7-0
	GPIOD->OTYPER = 0x0000;   //TypeRegister (PP oder OD)
	GPIOD->OSPEEDR = 0xFFFF2BFF;   //Speed Control
	GPIOD->PUPDR = 0x00002400;   //-- -- -- -- -- -- -- --  | -- Dn Up -- -- -- -- --
	//GPIOC Setup:
	RCC->AHB1ENR |= 1<<2; 	//Clock einschalten
	GPIOC->MODER = 0x0000A5FF;   //IF IF IF IF IF IF IF IF  | AP AP PP PP IA IA IA IA  Pin 15-8|7-0
	GPIOC->OTYPER = 0x0000;   //TypeRegister (PP oder OD)
	GPIOC->OSPEEDR = 0x0000F000;   //Speed Control
	GPIOC->PUPDR = 0x00005000;   //-- -- -- -- -- -- -- --  | Up Up -- -- -- -- -- --
	//GPIOB Setup:
	RCC->AHB1ENR |= 1<<1; 	//Clock einschalten
	GPIOB->MODER = 0x5558208F;   //PP PP PP PP PP PP AD IF  | IF AD IF IF AP IF IA IA  Pin 15-8|7-0
	GPIOB->OTYPER = 0x0240;   //TypeRegister (PP oder OD)
	GPIOB->OSPEEDR = 0xFFF820C0;   //Speed Control
	GPIOB->PUPDR = 0x00000000;   //-- -- -- -- -- -- -- --  | -- -- -- -- -- -- -- --
	//GPIOA Setup:
	RCC->AHB1ENR |= 1; 	//Clock einschalten
	GPIOA->MODER = 0xAAAAABFC;   //AP AP AP AP AP AD AP AP  | AP AP AP IA IA IA IA IF  Pin 15-8|7-0
	GPIOA->OTYPER = 0x0400;   //TypeRegister (PP oder OD)
	GPIOA->OSPEEDR = 0x0FFFFC00;   //Speed Control
	GPIOA->PUPDR = 0x00000000;   //-- -- -- -- -- -- -- --  | -- -- -- -- -- -- -- --
}  //STM32_GPIO_Setup()

void SPI_Config(u8 Mode, u8 Datasize, u8 Baudrate) {
//	GPIO_InitTypeDef GPIO_InitStructure;
	SPI_InitTypeDef  SPI_InitStructure;

	GPIO_PinAFConfig(GPIOA, 5, GPIO_AF_SPI1);
	GPIO_PinAFConfig(GPIOA, 6, GPIO_AF_SPI1);
	GPIO_PinAFConfig(GPIOA, 7, GPIO_AF_SPI1);
	GPIO_SD_Port->BSRRL = GPIO_Pin_SD_MISO;

	/* SPI configuration -------------------------------------------------------*/
	SPI_I2S_DeInit(SPI1);
	SPI_InitStructure.SPI_Direction = SPI_Direction_2Lines_FullDuplex;
	SPI_InitStructure.SPI_NSS = SPI_NSS_Soft;
	SPI_InitStructure.SPI_FirstBit = SPI_FirstBit_MSB;
	SPI_InitStructure.SPI_CRCPolynomial = 7;
	SPI_InitStructure.SPI_Mode = SPI_Mode_Master;
	switch (Mode) {
		case 0:
			SPI_InitStructure.SPI_CPOL = SPI_CPOL_Low;
			SPI_InitStructure.SPI_CPHA = SPI_CPHA_1Edge;
			break;
		case 1:
			SPI_InitStructure.SPI_CPOL = SPI_CPOL_Low;
			SPI_InitStructure.SPI_CPHA = SPI_CPHA_2Edge;
			break;
		case 2:
			SPI_InitStructure.SPI_CPOL = SPI_CPOL_High;
			SPI_InitStructure.SPI_CPHA = SPI_CPHA_1Edge;
			break;
		case 3:
			SPI_InitStructure.SPI_CPOL = SPI_CPOL_High;
			SPI_InitStructure.SPI_CPHA = SPI_CPHA_2Edge;
			break;
	}
	switch (Datasize) {
		case 8: SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b; break;
		case 16: SPI_InitStructure.SPI_DataSize = SPI_DataSize_16b; break;
	}
	switch (Baudrate) {//168000kHz/256=656.25 KHz
		case 2: SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_2; break; //84 MHz
		case 4: SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_4; break; //42 MHz
		case 8: SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_8; break; //21 MHz
		case 16: SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_16; break; //10.5 MHz
		case 32: SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_32; break; //5.25 MHz
		case 64: SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_64; break; //2.625 MHz
		case 128: SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_128; break; //1.312 MHz
		case 255: SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_256; break; //656.25 KHz
	}
	SPI_Init(SPI1, &SPI_InitStructure);
	SPI_Cmd(SPI1, ENABLE);
	SPI_SelectDevice(0);
}
//0=off 1=TP 2=Mot
void SPI_SelectDevice(u8 Device) {
	if (Last_Device==Device) { return; }
	TP_OFF; M_OFF; //L18_OFF;
	switch(Device) {
//		case 0: break;//
		case 1: SPI_Config(Mode_0,Databit16,BaudScale_256); TP_ON;  break;
		case 2: SPI_Config(Mode_0,Databit8,BaudScale_16); M_ON;  break;
		//case 3: SPI_Config(Mode_2,Databit8,BaudScale_256); L18_ON;  break;
	}
	Last_Device=Device;
}
u16 TP_SPI_RW(u16 c) {
	u16 MSB, LSB, data;

	SPI_I2S_SendData(SPI1, c);
	while (SPI_I2S_GetFlagStatus(SPI1, SPI_I2S_FLAG_RXNE) == RESET) { ; }
	MSB=SPI_I2S_ReceiveData(SPI1);

	SPI_I2S_SendData(SPI1, 0);
	while (SPI_I2S_GetFlagStatus(SPI1, SPI_I2S_FLAG_RXNE) == RESET) { ; }
	LSB=SPI_I2S_ReceiveData(SPI1);
    data=(((MSB<<4)&0x0FF0)|((LSB>>12)&0x000F))<<1;
	//TP_Deselect();
	return data;
}
void TP_GetAdXY(vs16 *x,vs16 *y) {
	u32 X,Y;
	X=TP_SPI_RW(0x9400); X+=TP_SPI_RW(0x9400); X+=TP_SPI_RW(0x9400); X+=TP_SPI_RW(0x9400);
	Y=TP_SPI_RW(0xD400); Y+=TP_SPI_RW(0xD400); Y+=TP_SPI_RW(0xD400); Y+=TP_SPI_RW(0xD400);
	Y=Y/4; X=X/4;
	#ifdef Switch_TP_Axis
	*y=((4094-X-260)/14.895);
	*x=((Y-240)/11.312);
	#else
	*x=((4094-X-530)/10.5);
	*y=((Y-370)/14.16);
	#endif
}
#define ADC_UseDMA
void ADC_Configuration(void) {
	ADC_InitTypeDef ADC_InitStructure;
	ADC_CommonInitTypeDef ADC_CommonInitStructure;

	#ifdef ADC_UseDMA
	DMA_InitTypeDef DMA_InitStructure;

	DMA_DeInit(DMA2_Stream0);
	DMA_InitStructure.DMA_Channel = DMA_Channel_0;
	DMA_InitStructure.DMA_PeripheralBaseAddr = (u32)&ADC1->DR;
	DMA_InitStructure.DMA_Memory0BaseAddr  = (u32)&ADCConvertedValue;
	DMA_InitStructure.DMA_DIR = DMA_DIR_PeripheralToMemory;
//	DMA_InitStructure.DMA_BufferSize = 1;
//	DMA_InitStructure.DMA_PeripheralInc = DMA_PeripheralInc_Disable;
//	DMA_InitStructure.DMA_MemoryInc = DMA_MemoryInc_Disable;
//	DMA_InitStructure.DMA_PeripheralDataSize = DMA_MemoryDataSize_HalfWord;
//	DMA_InitStructure.DMA_MemoryDataSize = DMA_MemoryDataSize_HalfWord;
	DMA_InitStructure.DMA_BufferSize = 2;
	DMA_InitStructure.DMA_PeripheralInc = DMA_PeripheralInc_Enable;
	DMA_InitStructure.DMA_MemoryInc = DMA_MemoryInc_Enable;
	DMA_InitStructure.DMA_PeripheralDataSize = DMA_MemoryDataSize_Byte;
	DMA_InitStructure.DMA_MemoryDataSize = DMA_MemoryDataSize_Byte;
	DMA_InitStructure.DMA_Mode = DMA_Mode_Circular;
	DMA_InitStructure.DMA_Priority = DMA_Priority_Medium;
	DMA_InitStructure.DMA_FIFOMode = DMA_FIFOMode_Disable;
	DMA_InitStructure.DMA_FIFOThreshold = DMA_FIFOThreshold_HalfFull;
	DMA_InitStructure.DMA_MemoryBurst = DMA_MemoryBurst_Single;
	DMA_InitStructure.DMA_PeripheralBurst = DMA_PeripheralBurst_Single;
	DMA_Init(DMA2_Stream0, &DMA_InitStructure);
	DMA_Cmd(DMA2_Stream0, ENABLE);
	#endif

	ADC_DeInit();
	/* ADC Common Init **********************************************************/
	ADC_CommonInitStructure.ADC_Mode = ADC_Mode_Independent;
	ADC_CommonInitStructure.ADC_Prescaler = ADC_Prescaler_Div4;
	ADC_CommonInitStructure.ADC_DMAAccessMode = ADC_DMAAccessMode_Disabled;	//??ADC_DMAAccessMode_3
	ADC_CommonInitStructure.ADC_TwoSamplingDelay = ADC_TwoSamplingDelay_5Cycles;
	ADC_CommonInit(&ADC_CommonInitStructure);

	/* ADC1 Configuration ------------------------------------------------------*/
	ADC_InitStructure.ADC_Resolution = ADC_Resolution_12b;
	ADC_InitStructure.ADC_ScanConvMode        = DISABLE;
	ADC_InitStructure.ADC_ContinuousConvMode  = ENABLE;//DISABLE;
	//ADC_InitStructure.ADC_ContinuousConvMode  = ENABLE;
	ADC_InitStructure.ADC_ExternalTrigConvEdge = ADC_ExternalTrigConvEdge_None;
	ADC_InitStructure.ADC_ExternalTrigConv = 0;
	ADC_InitStructure.ADC_DataAlign = ADC_DataAlign_Right;
	ADC_InitStructure.ADC_NbrOfConversion = 1;
	ADC_Init( ADC1, &ADC_InitStructure );

	ADC_RegularChannelConfig(ADC1, ADC_Channel_1, 1, ADC_SampleTime_28Cycles);
	#ifdef ADC_UseDMA
	ADC_DMACmd(ADC1, ENABLE);
	ADC_DMARequestAfterLastTransferCmd(ADC1, ENABLE);
	#endif
	ADC_Cmd(ADC1, ENABLE);
	ADC_SoftwareStartConv(ADC1);
}
u16 readADC1(u8 channel) {
    u16 timeout=1000;
	ADC_RegularChannelConfig(ADC1, channel, 1, ADC_SampleTime_3Cycles);
	ADC_SoftwareStartConv(ADC1);
	while(ADC_GetFlagStatus(ADC1, ADC_FLAG_EOC) == RESET) {
        timeout--;
        if (timeout==0) {break;}
    }
//	while(ADC_GetFlagStatus(ADC1, ADC_FLAG_EOC) != SET);
	return ADC_GetConversionValue(ADC1);
}
u16 grabADC(u8 channel) {
	if (ADC_GetFlagStatus(ADC1, ADC_FLAG_EOC)==SET) { //ACD fertig		ADCValues[ADCVal_Count]=ADC1->DR; //Messwert kopieren
		ADCVal_Count++; //auf naechsten umstellen
		switch (ADCVal_Count) { //naechsten konfigurieren
			case 0: ADC_RegularChannelConfig(ADC1, channel, 1, ADC_SampleTime_3Cycles); break;
			default: ADCVal_Count=0;
		}
		ADC_SoftwareStartConv(ADC1);
	} //if
	return ADCValues[channel];
}
void StopMode(void) {
	//Ausschalten
//	LED2_Off(); LED3_Off();
	LCD_Enable(0);
	USBD_DeInit(&USB_OTG_dev);
    PWR_EnterSTOPMode(PWR_Regulator_LowPower,PWR_STOPEntry_WFI);

	//Code wird nach External GPIO Interrupt ausgefuehrt
	//EXTI0 auf Pin A0 (button Key 1) ist als einziger aktiv
	RCC_HSEConfig(RCC_HSE_ON);
	RCC_PLLCmd(ENABLE);
	while(RCC_GetFlagStatus(RCC_FLAG_PLLRDY) == RESET) { }
	RCC_SYSCLKConfig(RCC_SYSCLKSource_PLLCLK);
	while(RCC_GetSYSCLKSource() != 0x08) { }
	//einschalten
	USBD_Init(&USB_OTG_dev, USB_OTG_FS_CORE_ID, &USR_desc, &USBD_HID_cb, &USR_cb);
	LCD_Enable(1);
}
void SpecialPeriphery(void) {
    TIM_TimeBaseInitTypeDef TIM_TimeBaseStructure;
    //Encoder
    GPIO_PinAFConfig(GPIOC, GPIO_PinSource6, GPIO_AF_TIM8);
    GPIO_PinAFConfig(GPIOC, GPIO_PinSource7, GPIO_AF_TIM8);
    TIM_TimeBaseStructInit(&TIM_TimeBaseStructure);
    TIM_TimeBaseStructure.TIM_Period = 0xffff;
    TIM_TimeBaseInit(TIM8, &TIM_TimeBaseStructure);
    TIM_EncoderInterfaceConfig(TIM8, TIM_EncoderMode_TI12, TIM_ICPolarity_Rising, TIM_ICPolarity_Rising);
    TIM8->CNT = 32767;
    TIM_Cmd(TIM8, ENABLE);
}
void EXTI_Config(void) {
    EXTI_InitTypeDef   EXTI_InitStructure;
	NVIC_InitTypeDef   NVIC_InitStructure;
	/* Connect EXTI Line0 to PA0 pin */
	SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOA, EXTI_PinSource0);
	SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOD, EXTI_PinSource7);

	/* Configure EXTI Line0 */
	EXTI_InitStructure.EXTI_Line = EXTI_Line0|EXTI_Line7;
	EXTI_InitStructure.EXTI_Mode = EXTI_Mode_Interrupt;
	EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Rising;
	EXTI_InitStructure.EXTI_LineCmd = ENABLE;
	EXTI_Init(&EXTI_InitStructure);

	/* Enable and set EXTI Line0 Interrupt to the lowest priority */
	NVIC_InitStructure.NVIC_IRQChannel = EXTI0_IRQn;
	NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0x01;
	NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0x01;
	NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
	NVIC_Init(&NVIC_InitStructure);
	NVIC_InitStructure.NVIC_IRQChannel = EXTI9_5_IRQn;
	NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0x01;
	NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0x01;
	NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
	NVIC_Init(&NVIC_InitStructure);
}
void I2C_Hard_Config(void) {
	I2C_InitTypeDef I2C_InitStructure;
	/* Connect pins to I2C peripheral */
	GPIO_PinAFConfig(GPIOB, GPIO_PinSource6, GPIO_AF_I2C1);
	GPIO_PinAFConfig(GPIOB, GPIO_PinSource9, GPIO_AF_I2C1);
	/* CODEC_I2C peripheral configuration */
	I2C_DeInit(I2C1);
	I2C_InitStructure.I2C_Mode = I2C_Mode_I2C;
	I2C_InitStructure.I2C_DutyCycle = I2C_DutyCycle_2;
	I2C_InitStructure.I2C_OwnAddress1 = 0x01;
	I2C_InitStructure.I2C_Ack = I2C_Ack_Enable;
	I2C_InitStructure.I2C_AcknowledgedAddress = I2C_AcknowledgedAddress_7bit;
	I2C_InitStructure.I2C_ClockSpeed = 400000; //400khz
	/* Enable the I2C peripheral */
	I2C_Cmd(I2C1, ENABLE);
	I2C_Init(I2C1, &I2C_InitStructure);
}
void Uart_Config(void) {
	USART_InitTypeDef USART_InitStructure;
	GPIO_InitTypeDef GPIO_InitStructure;

	GPIO_PinAFConfig(GPIOD, GPIO_PinSource5, GPIO_AF_USART2);
	GPIO_PinAFConfig(GPIOD, GPIO_PinSource6, GPIO_AF_USART2);

  /* Configure USART Tx as alternate function  */
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_UP;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;

  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_5;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOD, &GPIO_InitStructure);

  /* Configure USART Rx as alternate function  */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_6;
  GPIO_Init(GPIOD, &GPIO_InitStructure);

	USART_InitStructure.USART_BaudRate = 57600;//115200;
	USART_InitStructure.USART_WordLength = USART_WordLength_8b;
	USART_InitStructure.USART_StopBits = USART_StopBits_1;
	USART_InitStructure.USART_Parity = USART_Parity_No;
	USART_InitStructure.USART_HardwareFlowControl = USART_HardwareFlowControl_None;
	USART_InitStructure.USART_Mode = USART_Mode_Rx | USART_Mode_Tx;

	USART_Init(USART2, &USART_InitStructure);
	USART_ITConfig(USART2,USART_IT_RXNE,ENABLE);
	USART_Cmd(USART2, ENABLE);

	//http://www.mikrocontroller.net/topic/283309
}

void NVIC_Config(void) {
	NVIC_InitTypeDef NVIC_InitStructure;

	NVIC_InitStructure.NVIC_IRQChannel = USART2_IRQn;
	NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
	NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
	NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
	NVIC_Init(&NVIC_InitStructure);
}

void System_Init(void) {
	RCC_ClocksTypeDef RCC_Clocks;
	SystemInit();
	//clocks sind schon ueber startup_stm32f4xx.s initialisiert
	RCC_GetClocksFreq(&RCC_Clocks);
	SysTick_Config(RCC_Clocks.HCLK_Frequency / 100);

	RCC_AHB1PeriphClockCmd(BOARD_AHB1_RCCs, ENABLE);
	RCC_APB1PeriphClockCmd(BOARD_APB1_RCCs, ENABLE);
	RCC_APB2PeriphClockCmd(BOARD_APB2_RCCs, ENABLE);
	STM32_GPIO_Setup();
	USBD_Init(&USB_OTG_dev, USB_OTG_FS_CORE_ID, &USR_desc, &USBD_HID_cb, &USR_cb);

	PWR_WakeUpPinCmd(ENABLE);
	EXTI_Config();
	ADC_Configuration();
	SPI_Config(Mode_0,Databit16,BaudScale_256);
	I2C_SoftGPIO_Config();
	SpecialPeriphery();
	//I2C_Hard_Config();
	Uart_Config();
	NVIC_Config();
	LCD_Initializtion();
}

void Decrement_TimingDelay(void) { if (TimingDelay != 0x00) { TimingDelay--; } }
void delay_us(u16 i) { while( i--) { ; } }
void delay_ms(u16 time) { while(time--) { delay_us(10000); } }
char *itoa(int n, char *s, int b) { //n=nummer,*s=buffer,b=basis (dec=10,hex=16)
	static char digits[] = "0123456789ABCDEFghijklmnopqrstuvwxyz";
	int i=0, sign;

	if ((sign = n) < 0)
		n = -n;

	do {
		s[i++] = digits[n % b];
	} while ((n /= b) > 0);

	if (sign < 0)
		s[i++] = '-';
	s[i] = '\0';

	return strrev(s);
}
char *strrev(char *str) {
	char *p1, *p2;

	if (!str || !*str)
		return str;

	for (p1 = str, p2 = str + strlen(str) - 1; p2 > p1; ++p1, --p2) {
		*p1 ^= *p2;
		*p2 ^= *p1;
		*p1 ^= *p2;
	}

	return str;
}
//I2C Funktionen #############################################################################
u8 I2C_Send(u8 adresse, u8 reg, u8 data) {
	I2C_SendStart();
	if(0==I2C_WriteByte(adresse<<1)) { I2C_SendStop(); return(0); }
  	if(0==I2C_WriteByte(reg)) { I2C_SendStop(); return(0); }
  	if(0==I2C_WriteByte(data)) { I2C_SendStop(); return(0); }
  	I2C_SendStop();
  	return(1);
}
u8 I2C_Read(u8 adresse, u8 reg, u8 *data) {
	I2C_SendStart();
	if(0==I2C_WriteByte(adresse<<1)) { I2C_SendStop(); return(0); }
	if(0==I2C_WriteByte(reg)) { I2C_SendStop(); return(0); }
	I2C_SendStart();
	if(0==I2C_WriteByte(adresse<<1|1)) { I2C_SendStop(); return(0); } //adresse + read Bit
  	*data=I2C_ReadByte();
	I2C_SendnoAck();
  	I2C_SendStop();
  	return(1);
}
u8 I2C_Read2(u8 adresse, u8 reg, u8 *data) {
	I2C_SendStart();
	if(0==I2C_WriteByte(adresse<<1)) { I2C_SendStop(); return(0); }
	if(0==I2C_WriteByte(reg)) { I2C_SendStop(); return(0); }
	I2C_SendStop();
	delay_us(100);
	I2C_SendStart(); //adresse++;
	if(0==I2C_WriteByte(adresse<<1|1)) { I2C_SendStop(); return(0); } //adresse + read Bit
  	*data=I2C_ReadByte();
	I2C_SendnoAck();
  	I2C_SendStop();
  	return(1);
}
//I2C Kernel
void I2C_SendStart() {
	I2C_DATA_H(); I2C_Delay_Short();
	I2C_SCL_H(); I2C_Delay_Long();
	I2C_DATA_L(); I2C_Delay_Short();
	I2C_SCL_L();
}
void I2C_SendStop() {
	I2C_SetDataPort_OUT();
	I2C_SCL_L(); I2C_Delay_Short();
    I2C_DATA_L(); I2C_Delay_Short();
	I2C_SCL_H(); I2C_Delay_Long();
	I2C_DATA_H();
}
void I2C_SendnoAck() {
	I2C_DATA_H(); I2C_Delay_Short();
	I2C_SCL_H(); I2C_Delay_Short();
	I2C_SCL_L(); I2C_Delay_Long();
	I2C_DATA_L();
}
u8 I2C_WriteByte(u8 m_data) {
	u8 j,tem=1;
	I2C_Delay_Short();
	for(j=0;j<8;j++) {
		if((m_data<<j)&0x80) {
			I2C_DATA_H();
		} else {
			I2C_DATA_L();
		}
		I2C_Delay_Short();
		I2C_SCL_H();
		I2C_Delay_Long();
		I2C_SCL_L();
	}
	I2C_Delay_Long();
	I2C_SetDataPort_IN();
	I2C_SCL_H();
	I2C_Delay_Short();
	if(I2C_DATA_STATE) {tem=0;} else {tem=1;}
	I2C_SCL_L();
//	while(!I2C_SCL_STATE) {;} //Clockstretching: w8 4 Slave
	I2C_SetDataPort_OUT();

	return (tem);
}
u8 I2C_ReadByte(void) {
	u8 read=0,j; Delay=0;
	I2C_SetDataPort_IN();
	I2C_Delay_Long();
	for(j=8;j>0;j--) {
		I2C_SCL_H();
		I2C_Delay_Long();
		read=read<<1;
		if(I2C_DATA_STATE) { read++; }
		I2C_SCL_L();
		I2C_Delay_Long();
	}
//	I2C_SCL_H();
//	I2C_Delay_Long();
//	I2C_SCL_L();
	I2C_SetDataPort_OUT();
	return(read);
}

void I2C_SetDataPort_OUT(void) {
#ifdef IC2_DATA_MACRO_OUT
	IC2_DATA_MACRO_OUT;
#else
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_InitStructure.GPIO_Pin = I2C_PIN_DATA;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
	GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
	GPIO_Init(I2C_PORT_DATA, &GPIO_InitStructure);
#endif
//LED_Or_On;//
}
void I2C_SetDataPort_IN(void) {
#ifdef IC2_DATA_MACRO_IN
	IC2_DATA_MACRO_IN;
#else
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_InitStructure.GPIO_Pin = I2C_PIN_DATA;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN;
	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
	GPIO_Init(I2C_PORT_DATA, &GPIO_InitStructure);
#endif
//LED_Or_Off;//
}
void I2C_SoftGPIO_Config(void) {
	GPIO_InitTypeDef GPIO_InitStructure;
	I2C_SCL_H();
	I2C_DATA_H();

	GPIO_InitStructure.GPIO_Pin = I2C_PIN_DATA;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
	GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_UP;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
	GPIO_Init(I2C_PORT_DATA, &GPIO_InitStructure);
	GPIO_InitStructure.GPIO_Pin = I2C_PIN_SCL;
	GPIO_Init(I2C_PORT_SCL, &GPIO_InitStructure);
}
/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/




























