#include "LCD18.h"
#include "font.h"
#include "boardcfg.h"
#include "hw_config.h"
//Geometrische darstellungen ####################################################

//Text ###########################################################################
void LCD18_DrawText(u16 x, u16 y, char *text, u16 charColor, u16 bkColor, u8 font) {
	u8 i=0;
	while(*text) {
        switch (font) {
            case font_4x6: LCD18_PutChar((x+4*i), y, *text++, charColor, bkColor, font); break;
            case font_5x8: LCD18_PutChar((x+5*i), y, *text++, charColor, bkColor, font); break;
            case font_5x12: LCD18_PutChar((x+5*i), y, *text++, charColor, bkColor, font); break;
            case font_6x10: LCD18_PutChar((x+6*i), y, *text++, charColor, bkColor, font); break;
            case font_8x12: LCD18_PutChar((x+8*i), y, *text++, charColor, bkColor, font); break;
            case font_8x16: LCD18_PutChar((x+8*i), y, *text++, charColor, bkColor, font); break;
            case font_12x16: LCD18_PutChar((x+12*i), y, *text++, charColor, bkColor, font); break;
            case font_22x36: LCD18_PutChar((x+22*i), y, *text++, charColor, bkColor, font); break;
            default : LCD18_PutChar((x+8*i), y, *text++, charColor, bkColor, font); break;
        }
		i++;
	}
}
void LCD18_PutChar(u16 x,u16 y,u8 c,u16 charColor,u16 bkColor, u8 font) {
	u16 i;
	u8 tmp_char,a,b,d=7,l=0;
	switch (font) {
        case font_4x6: a=4; b=6; d=3; break;
        case font_5x8: a=5; b=8; d=4; break;
        case font_5x12: a=5; b=12; d=4; break;
        case font_6x10: a=6; b=10; d=5; break;
        case font_8x12: a=8; b=12; break;
        case font_8x16: a=8; b=16; break;
        case font_12x16: a=12; b=32; break;
        case font_22x36: a=22; b=108; break;
        default: a=8; b=16; break; //font_8x16
	}

    for (i=0;i<b;i++) {
        switch (font) {
            case font_4x6: tmp_char=ascii_4x6[c][i]; break;
            case font_5x8: tmp_char=ascii_5x8[c][i]; break;
            case font_5x12: tmp_char=ascii_5x12[c][i]; break;
            case font_6x10: tmp_char=ascii_6x10[c][i]; break;
            case font_8x12: tmp_char=ascii_8x12[c][i]; break;
            case font_8x16: tmp_char=ascii_8x16[c][i]; break;
            case font_12x16: tmp_char=ascii_12x16[c][i+1]; break;
            case font_22x36: tmp_char=ascii_22x36[c][i+2]; break;
        }
        LCD18_WR_REG(0x2a); //X start/stop
        LCD18_WR_DATA(x); //start
        LCD18_WR_DATA(x+a+1); //stop

        LCD18_WR_REG(0x2b); //Y start/stop
        LCD18_WR_DATA(y+l); //start
        LCD18_WR_DATA(y+b+l); //stop

        LCD18_WR_REG(0x2C); //RAMWR (Memory Write)

        switch (font) {
            case font_12x16:
                sub18_WR_Dataline(tmp_char,4,d,4,charColor,bkColor);
                tmp_char=ascii_12x16[c][i];
                sub18_WR_Dataline(tmp_char,8,d,0,charColor,bkColor);
                i++; break;
            case font_22x36:
                sub18_WR_Dataline(tmp_char,8,d,0,charColor,bkColor);
                tmp_char=ascii_22x36[c][i+1];
                sub18_WR_Dataline(tmp_char,8,d,0,charColor,bkColor);
                tmp_char=ascii_22x36[c][i];
                sub18_WR_Dataline(tmp_char,8,d,0,charColor,bkColor);
                i+=2; break;
            default : sub18_WR_Dataline(tmp_char,a,d,0,charColor,bkColor); break;
        }
        l++;
    }
}
void sub18_WR_Dataline(u8 data, u8 a,u8 d,u8 e,u16 colC,u16 colB) {
    u8 i;
    for (i=0;i<a;i++) {
        if (data >> (d-e-i)&1) {
            LCD18_WR_DATA(colC);// character color
        } else {
            LCD18_WR_DATA(colB);// background color
        }
    }
}
//########################################################################################
//								LCD Objekte
//########################################################################################
//########################################################################################
//								LCD Treiber
//########################################################################################
void LCD18_Writ_Bus(char da) {
    if ((da&128)==128) { LCD18_DATA_H(); } else { LCD18_DATA_L(); }
    LCD18_SCL_L(); LCD18_SCL_H();
    if ((da&64)==64) { LCD18_DATA_H(); } else { LCD18_DATA_L(); }
    LCD18_SCL_L(); LCD18_SCL_H();
    if ((da&32)==32) { LCD18_DATA_H(); } else { LCD18_DATA_L(); }
    LCD18_SCL_L(); LCD18_SCL_H();
    if ((da&16)==16) { LCD18_DATA_H(); } else { LCD18_DATA_L(); }
    LCD18_SCL_L(); LCD18_SCL_H();
    if ((da&8)==8) { LCD18_DATA_H(); } else { LCD18_DATA_L(); }
    LCD18_SCL_L(); LCD18_SCL_H();
    if ((da&4)==4) { LCD18_DATA_H(); } else { LCD18_DATA_L(); }
    LCD18_SCL_L(); LCD18_SCL_H();
    if ((da&2)==2) { LCD18_DATA_H(); } else { LCD18_DATA_L(); }
    LCD18_SCL_L(); LCD18_SCL_H();
    if ((da&1)==1) { LCD18_DATA_H(); } else { LCD18_DATA_L(); }
    LCD18_SCL_L(); LCD18_SCL_H();
    LCD18_DATA_H();
}
void LCD18_WR_DATA8(char da) {
    LCD18_A0_H();
    LCD18_Writ_Bus(da);
}
void LCD18_WR_DATA(int da) {
    LCD18_A0_H();
	LCD18_Writ_Bus(da>>8);
	LCD18_Writ_Bus(da);
}
void LCD18_WR_REG(char da) {
    LCD18_A0_L();
	LCD18_Writ_Bus(da);
}
void LCD18_WR_REG_DATA(int reg,int da) {
    LCD18_WR_REG(reg);
	LCD18_WR_DATA(da);
}
void LCD18_SetWindows(unsigned int x1,unsigned int y1,unsigned int x2,unsigned int y2) {
   LCD18_WR_REG(0x2a); //X start/stop
   LCD18_WR_DATA8(x1>>8);
   LCD18_WR_DATA8(x1);
   LCD18_WR_DATA8(x2>>8);
   LCD18_WR_DATA8(x2);

   LCD18_WR_REG(0x2b); //Y start/stop
   LCD18_WR_DATA8(y1>>8);
   LCD18_WR_DATA8(y1);
   LCD18_WR_DATA8(y2>>8);
   LCD18_WR_DATA8(y2);

   LCD18_WR_REG(0x2C);
}
void Lcd18_Init(void) {
    LCD18_CS_H(); LCD18_SCL_H(); LCD18_DATA_H();
    LCD18_RST_H();
    delay_ms(5); LCD18_RST_L(); delay_ms(5);
	LCD18_RST_H();
	delay_ms(5);
	LCD18_CS_L();

	LCD18_WR_REG(0x11); //Sleep out
	delay_ms(120); //Delay 120ms

	//------------------------------------ST7735S Frame Rate-----------------------------------------//
	LCD18_WR_REG(0xB1);
	LCD18_WR_DATA8(0x05);
	LCD18_WR_DATA8(0x3C);
	LCD18_WR_DATA8(0x3C);
	LCD18_WR_REG(0xB2);
	LCD18_WR_DATA8(0x05);
	LCD18_WR_DATA8(0x3C);
	LCD18_WR_DATA8(0x3C);
	LCD18_WR_REG(0xB3);
	LCD18_WR_DATA8(0x05);
	LCD18_WR_DATA8(0x3C);
	LCD18_WR_DATA8(0x3C);
	LCD18_WR_DATA8(0x05);
	LCD18_WR_DATA8(0x3C);
	LCD18_WR_DATA8(0x3C);
	//------------------------------------End ST7735S Frame Rate-----------------------------------------//
	LCD18_WR_REG(0xB4); //Dot inversion
	LCD18_WR_DATA8(0x03);
	LCD18_WR_REG(0xC0);
	LCD18_WR_DATA8(0x28);
	LCD18_WR_DATA8(0x08);
	LCD18_WR_DATA8(0x04);
	LCD18_WR_REG(0xC1);
	LCD18_WR_DATA8(0XC0);
	LCD18_WR_REG(0xC2);
	LCD18_WR_DATA8(0x0D);
	LCD18_WR_DATA8(0x00);
	LCD18_WR_REG(0xC3);
	LCD18_WR_DATA8(0x8D);
	LCD18_WR_DATA8(0x2A);
	LCD18_WR_REG(0xC4);
	LCD18_WR_DATA8(0x8D);
	LCD18_WR_DATA8(0xEE);
	//---------------------------------End ST7735S Power Sequence-------------------------------------//
	LCD18_WR_REG(0xC5); //VCOM
	LCD18_WR_DATA8(0x1A);
	LCD18_WR_REG(0x36); //MX, MY, RGB mode
	LCD18_WR_DATA8(0xC0);
	//------------------------------------ST7735S Gamma Sequence-----------------------------------------//
	LCD18_WR_REG(0xE0);
	LCD18_WR_DATA8(0x04);
	LCD18_WR_DATA8(0x22);
	LCD18_WR_DATA8(0x07);
	LCD18_WR_DATA8(0x0A);
	LCD18_WR_DATA8(0x2E);
	LCD18_WR_DATA8(0x30);
	LCD18_WR_DATA8(0x25);
	LCD18_WR_DATA8(0x2A);
	LCD18_WR_DATA8(0x28);
	LCD18_WR_DATA8(0x26);
	LCD18_WR_DATA8(0x2E);
	LCD18_WR_DATA8(0x3A);
	LCD18_WR_DATA8(0x00);
	LCD18_WR_DATA8(0x01);
	LCD18_WR_DATA8(0x03);
	LCD18_WR_DATA8(0x13);
	LCD18_WR_REG(0xE1);
	LCD18_WR_DATA8(0x04);
	LCD18_WR_DATA8(0x16);
	LCD18_WR_DATA8(0x06);
	LCD18_WR_DATA8(0x0D);
	LCD18_WR_DATA8(0x2D);
	LCD18_WR_DATA8(0x26);
	LCD18_WR_DATA8(0x23);
	LCD18_WR_DATA8(0x27);
	LCD18_WR_DATA8(0x27);
	LCD18_WR_DATA8(0x25);
	LCD18_WR_DATA8(0x2D);
	LCD18_WR_DATA8(0x3B);
	LCD18_WR_DATA8(0x00);
	LCD18_WR_DATA8(0x01);
	LCD18_WR_DATA8(0x04);
	LCD18_WR_DATA8(0x13);
	//------------------------------------End ST7735S Gamma Sequence-----------------------------------------//
	LCD18_WR_REG(0x3A); //65k mode
	LCD18_WR_DATA8(0x05);
	LCD18_WR_REG(0x29); //Display on
}
void LCD18_Clear(u16 Color) {
	u16 i,j;
	LCD18_SetWindows(0,0,LCD_W-1,LCD_H-1);

    for(i=0;i<LCD_W;i++) {
        for (j=0;j<LCD_H;j++) {
            LCD18_WR_DATA(Color);
	    }
	}
}


void LCD18_DrawPoint(u16 x,u16 y, u16 color)
{
	LCD18_SetWindows(x,y,x,y);
	LCD18_WR_DATA(color);
}
void LCD18_DrawPoint_big(u16 x,u16 y, u16 color)
{
	LCD18_Fill(x-1,y-1,x+1,y+1,color);
}
void LCD18_Fill(u16 xsta,u16 ysta,u16 xend,u16 yend,u16 color)
{
	u16 i,j;
	LCD18_SetWindows(xsta,ysta,xend,yend);
	for(i=ysta;i<=yend;i++)
	{
		for(j=xsta;j<=xend;j++)LCD18_WR_DATA(color);
	}
}
void LCD18_DrawLine2(u16 x1, u16 y1, u16 x2, u16 y2,u16 color) {
	u16 t;
	int xerr=0,yerr=0,delta_x,delta_y,distance;
	int incx,incy,uRow,uCol;

	delta_x=x2-x1;
	delta_y=y2-y1;
	uRow=x1;
	uCol=y1;
	if(delta_x>0)incx=1;
	else if(delta_x==0)incx=0;
	else {incx=-1;delta_x=-delta_x;}
	if(delta_y>0)incy=1;
	else if(delta_y==0)incy=0;
	else{incy=-1;delta_y=-delta_y;}
	if( delta_x>delta_y)distance=delta_x;
	else distance=delta_y;
	for(t=0;t<=distance+1;t++ )	{
		LCD18_DrawPoint(uRow,uCol,color);
		xerr+=delta_x ;
		yerr+=delta_y ;
		if(xerr>distance) {
			xerr-=distance;
			uRow+=incx;
		}
		if(yerr>distance) {
			yerr-=distance;
			uCol+=incy;
		}
	}
}
void LCD18_DrawRectangle(u16 x1, u16 y1, u16 x2, u16 y2,u16 color) {
	LCD18_DrawLine2(x1,y1,x2,y1,color);
	LCD18_DrawLine2(x1,y1,x1,y2,color);
	LCD18_DrawLine2(x1,y2,x2,y2,color);
	LCD18_DrawLine2(x2,y1,x2,y2,color);
}
void Draw_Circle(u16 x0,u16 y0,u8 r,u16 color) {
	int a,b;
	int di;
	a=0;b=r;
	di=3-(r<<1);
	while(a<=b)	{
		LCD18_DrawPoint(x0-b,y0-a,color);             //3
		LCD18_DrawPoint(x0+b,y0-a,color);             //0
		LCD18_DrawPoint(x0-a,y0+b,color);             //1
		LCD18_DrawPoint(x0-b,y0-a,color);             //7
		LCD18_DrawPoint(x0-a,y0-b,color);             //2
		LCD18_DrawPoint(x0+b,y0+a,color);             //4
		LCD18_DrawPoint(x0+a,y0-b,color);             //5
		LCD18_DrawPoint(x0+a,y0+b,color);             //6
		LCD18_DrawPoint(x0-b,y0+a,color);
		a++;
		if(di<0) {
            di +=4*a+6;
		} else {
			di+=10+4*(a-b);
			b--;
		}
		LCD18_DrawPoint(x0+a,y0+b,color);
	}
}


u32 mypow(u8 m,u8 n) {
	u32 result=1;
	while(n--)result*=m;
	return result;
}
//(0~4294967295);
void LCD18_ShowNum(u16 x,u16 y,u32 num,u8 len) {
	u8 t,temp;
	u8 enshow=0;
	num=(u16)num;
	for(t=0;t<len;t++)
	{
		temp=(num/mypow(10,len-t-1))%10;
		if(enshow==0&&t<(len-1))
		{
			if(temp==0)
			{
//				LCD18_ShowChar(x+8*t,y,' ',0);
				continue;
			}else enshow=1;

		}
//	 	LCD18_ShowChar(x+8*t,y,temp+48,0);
	}
}
//(0~99);
void LCD_Show2Num(u16 x,u16 y,u16 num,u8 len) {
//	u8 t,temp;
//	for(t=0;t<len;t++)
//	{
//		temp=(num/mypow(10,len-t-1))%10;
////	 	LCD18_ShowChar(x+8*t,y,temp+'0',0);
//	}
}
void LCD18_ShowString(u16 x,u16 y,const u8 *p) {
    while(*p!='\0')
    {
        if(x>LCD_W-16){x=0;y+=16;}
        if(y>LCD_H-16){y=x=0;}
//        LCD18_ShowChar(x,y,*p,0);
        x+=8;
        p++;
    }
}












