//CHIP ov7670
#include "boardcfg.h"
#include "hw_config.h"

unsigned char wrOV7670Reg(unsigned char regID, unsigned char regDat);
unsigned char rdOV7670Reg(unsigned char regID, unsigned char *regDat);

void CamReg_init(void) {
/* wrOV7670Reg();
Automatic Exposure Control (AEC)
Automatic Gain Control (AGC)
Automatic White Balance (AWB)
*/

  wrOV7670Reg(0x00, 0);//AGC  Gain control gain setting
  //wrOV7670Reg(0x03, 10);//Vertical Frame Control
  wrOV7670Reg(0x11, 64);//64 Internal Clock Disabled
  wrOV7670Reg(0x12, 20);//20 qVGA & RGB
  wrOV7670Reg(0x40, 208);//192=RGB, 208=RGB 565,Output range: [00] to [FF]
  //wrOV7670Reg(0x32, 182);//HREF Control #####
  wrOV7670Reg(0x17, 21); wrOV7670Reg(0x18, 3);//Horizontal Frame start/stop (le/ri)
  //wrOV7670Reg(0x19, 1); wrOV7670Reg(0x1a, 121);//Vertical Frame start/stop (up/down)
  /* Mystery scaling numbers */
  //wrOV7670Reg(0x70, 0x3a); wrOV7670Reg(0x71, 0x35); wrOV7670Reg(0x72, 0x11);
//wrOV7670Reg(0xa2, 0x02); wrOV7670Reg(0x15, 0x0);
//wrOV7670Reg(0x0f, 130);//LSB of Insert Dummy Lines in Vertical Direction (1 bit equals 1 line)
//wrOV7670Reg(0x2e, 10);//MSB of Insert Dummy Lines in Vertical Direction
  /* Gamma curve values */
  wrOV7670Reg(0x7a, 0x20); wrOV7670Reg(0x7b, 0x10); wrOV7670Reg(0x7c, 0x1e);
  wrOV7670Reg(0x7d, 0x35); wrOV7670Reg(0x7e, 0x5a); wrOV7670Reg(0x7f, 0x69);
  wrOV7670Reg(0x80, 0x76); wrOV7670Reg(0x81, 0x80); wrOV7670Reg(0x82, 0x88);
  wrOV7670Reg(0x83, 0x8f); wrOV7670Reg(0x84, 0x96); wrOV7670Reg(0x85, 0xa3);
  wrOV7670Reg(0x86, 0xaf); wrOV7670Reg(0x87, 0xc4); wrOV7670Reg(0x88, 0xd7);
  wrOV7670Reg(0x89, 0xe8);
  /* Mystery reserved */
  wrOV7670Reg(0x29, 255); wrOV7670Reg(0xb0, 132);
  /* AWB Control */
  //wrOV7670Reg(0x6c, 0x0a); wrOV7670Reg(0x6d, 0x55);
  //wrOV7670Reg(0x6e, 0x11); wrOV7670Reg(0x6f, 0x9f);

  wrOV7670Reg(0x14, 0x20); //0x38, limit the max gain
  wrOV7670Reg(0x13, 165);//135 Common Control 8    ####################
  wrOV7670Reg(0x0d, 48);//Common Control 4 Average option
  wrOV7670Reg(0x42, 192);//Common Control 17 (200 = colorbar)
  wrOV7670Reg(0xa5, 0x05);//50Hz Banding Step Limit
  wrOV7670Reg(0xab, 0x07);//60Hz Banding Step Limit
  wrOV7670Reg(0xaa, 128);//AEC algorithm selection
  wrOV7670Reg(0x21, 150); wrOV7670Reg(0x22, 150); wrOV7670Reg(0x23, 150);//ADCCTR1-3
  wrOV7670Reg(0x37, 10);//ADC Control (lower = brighter)

  wrOV7670Reg(0x73, 240);
  wrOV7670Reg(0x3e, 0);//Common Control 14
  wrOV7670Reg(0x6b, 0);//PLL
  //Matrix Coefficient
  wrOV7670Reg(0x4f, 0x80); wrOV7670Reg(0x50, 0x80); wrOV7670Reg(0x51, 0x00);
  wrOV7670Reg(0x52, 0x22); wrOV7670Reg(0x53, 0x5e); wrOV7670Reg(0x54, 0x80);
  //########################################################################
  wrOV7670Reg(0x1e, 0x37); //Orientation
	/*0x37 Left/Right
	//0x27 Left/Right Up/Down
	//0x17 Normal
	//0x07 Up/Down*/
  wrOV7670Reg(0x55, 20);//Brightness Control
  wrOV7670Reg(0x56, 50);//Contrast Control
  wrOV7670Reg(0x57, 0x80);//Contrast Center
  wrOV7670Reg(0x69, 95);//Fix Gain Control
  //{0x3b, 226},//Night mode
  //wrOV7670Reg(0x2e, 10);//MSB of Insert Dummy Lines in Vertical Direction (Averrage?)
//{0x3f, 10},//Edge Enhancement Adjustment (Noise)
//{0x3f, 0},//De-noise Strength 0-31
//testoutput
//{0x71, 128},//SCALING_YSC
//{0x70, 128},//SCALING_XSC
wrOV7670Reg(0x3a, 0);//Line Buffer Test Option
      /*00 = normal
        32 = invert
        16 = UV output
        1 = Auto output window*/
//{0x01, 0},//AWB Blue channel gain setting
//{0x02, 150},//AWB Red channel gain setting
//{ 0x3d, 0x80 }, /* No gamma, magic rsvd bit */
//{ 0x41, 0x3d }, /* Edge enhancement, denoise */
//{ 0x76, 0xe1 }, /* Pix correction, magic rsvd */
//{0x13, 231},//Common Control 8
//{0x1b, 0},//Pixel Delay Select
//{0x17, 0x16},{0x18, 0x04},//Horizontal Frame start/stop
//{0x19, 0x02},{0x1a, 0x7b},//Vertical Frame start/stop
//{0x09, 3},//Common Control 2
//{0x04, 0},//Common Control 1
//{0x07, 255},//Exposure Value - AEC MSB 5 bits
//{0x10, 255},//Exposure Value
//{0x08, 255},//V/R Average Level
//{0x24, 0x75},//AGC/AEC - Stable Operating Region
//{0x25, 0x63},//AGC/AEC - Stable Operating Region
//{0x26, 0xA5},//AGC/AEC Fast Mode Operating Region
//{0x9f, 0x78},//Histogram-based AEC/AGC Control 1
//{0xa0, 0x68},//Histogram-based AEC/AGC Control 2
//{0xa6, 0xdf},//Histogram-based AEC/AGC Control 3
//{0xa7, 0xdf},//Histogram-based AEC/AGC Control 4
//{0xa8, 0xf0},//Histogram-based AEC/AGC Control 5
//{0xa9, 0x90},//Histogram-based AEC/AGC Control 6
//{0x0f, 0x4b},//Common Control 6
//{0x2d, 10},//LSB of Insert Dummy Lines in Vertical Direction
//{0x33, 128},//Array Current Control
//{0x38, 255},//ADC and Analog Common Mode Control
//{0x39, 0},//ADC Offset Control
//{0x3c, 255},//Common Control 12
}
void CamReg_QVGA_565(void) {
  wrOV7670Reg(0x12, 21);//QVGA Processed RAW (reset)
  wrOV7670Reg(0x17, 21); wrOV7670Reg(0x18, 3);//Horizontal Frame start/stop (le/ri)
  wrOV7670Reg(0x19, 1); wrOV7670Reg(0x1a, 121);//Vertical Frame start/stop (up/down)
  wrOV7670Reg(0x12, 20);//QVGA 565
}
void CamReg_VGA_RAW(void) {
  wrOV7670Reg(0x12, 1);//VGA RAW
}

unsigned char wrOV7670Reg(unsigned char regID, unsigned char regDat) {
    return I2C_Send(33,regID,regDat);
}
unsigned char rdOV7670Reg(unsigned char regID, unsigned char *regDat) {
    u8 transmit;
    I2C_Read2(33, 1, &transmit);
    return transmit;
}


/* OV7670_init() */
unsigned char OV7670_init(void) {
	//SCCB_GPIO_Config();//io init..


	if(0==I2C_Send(33,18,128)) {//Reset SCCB
          return 0;
	}
	delay_ms(50);
	CamReg_init();
	return 1; //ok
}

