/**
 *  File        : target.ld wizard generated file
 *  Created     : 2013-09-22
 *  Purpose     : Linker script
 *  Device      : STM32F407VG
 *  Distribution: The file is distributed "as is" without any warranty of any kind.
 */

/* Entry Point */
ENTRY(Reset_Handler)

/* required amount of heap  */
_Heap_Size = 0;

/* required amount of stack */
_Stack_Size = 10032;

/* Specify the memory areas */
MEMORY
{
  FLASH (r) : ORIGIN = 0x08000000, LENGTH = 0x00100000
  CCMSRAM (rw) : ORIGIN = 0x10000000, LENGTH = 0x00010000
  SRAM1 (rw) : ORIGIN = 0x20000000, LENGTH = 0x0001C000
  SRAM2 (rw) : ORIGIN = 0x2001C000, LENGTH = 0x00004000
  BKPSRAM (rw) : ORIGIN = 0x40024000, LENGTH = 0x00001000
}

/* Define output sections */
SECTIONS
{
  /* The startup code */
  .isr_vector :
  {
    . = ALIGN(4);
    KEEP(*(.isr_vector)) /* Startup code */
    . = ALIGN(4);
  } > FLASH

  /* The program code and other data */
  .text :
  {
    . = ALIGN(4);
    *(.text)           /* .text sections (code) */
    *(.text*)          /* .text* sections (code) */
    *(.rodata)         /* .rodata sections (constants, strings, etc.) */
    *(.rodata*)        /* .rodata* sections (constants, strings, etc.) */
    *(.glue_7)         /* glue arm to thumb code */
    *(.glue_7t)        /* glue thumb to arm code */
	*(.eh_frame)

    KEEP (*(.init))
    KEEP (*(.fini))

    . = ALIGN(4);
    _etext = .;        /* define a global symbols at end of code */
  } > FLASH


   .ARM.extab   : { *(.ARM.extab* .gnu.linkonce.armextab.*) } >FLASH
    .ARM : {
    __exidx_start = .;
      *(.ARM.exidx*)
      __exidx_end = .;
    } > FLASH

  .preinit_array     :
  {
    PROVIDE_HIDDEN (__preinit_array_start = .);
    KEEP (*(.preinit_array*))
    PROVIDE_HIDDEN (__preinit_array_end = .);
  } > FLASH
  .init_array :
  {
    PROVIDE_HIDDEN (__init_array_start = .);
    KEEP (*(SORT(.init_array.*)))
    KEEP (*(.init_array*))
    PROVIDE_HIDDEN (__init_array_end = .);
  } > FLASH
  .fini_array :
  {
    PROVIDE_HIDDEN (__fini_array_start = .);
    KEEP (*(.fini_array*))
    KEEP (*(SORT(.fini_array.*)))
    PROVIDE_HIDDEN (__fini_array_end = .);
  } > FLASH

  /* used by the startup to initialize data */
  _sidata = .;

  /* Initialized data sections, load LMA copy after code */
  .data : AT ( _sidata )
  {
    . = ALIGN(4);
    _sdata = .;        /* create a global symbol at data start */
    *(.data)           /* .data sections */
    *(.data*)          /* .data* sections */

    . = ALIGN(4);
    _edata = .;        /* define a global symbol at data end */
  } > SRAM1

  /* Uninitialized data section */
  . = ALIGN(4);
  .bss :
  {
    /* This is used by the startup in order to initialize the .bss secion */
    _sbss = .;         /* define a global symbol at bss start */
    __bss_start__ = _sbss;
    *(.bss)
    *(.bss*)
    *(COMMON)

    . = ALIGN(4);
    _ebss = .;         /* define a global symbol at bss end */
    __bss_end__ = _ebss;
  } > SRAM1

  /* user_heap section, used to check that there is memory left */
  ._user_heap :
  {
    PROVIDE ( end = . );
    PROVIDE ( _end = . );
    . = . + _Heap_Size;
    . = ALIGN(4);
    _eheap = .;
  } > SRAM1

  /* user_stack section, used to check that there is memory left */
  ._user_stack :
  {
    . = . + _Stack_Size;
    . = ALIGN(4);
    _estack = .;
  } > SRAM1

  /* Remove information from the standard libraries */
  /DISCARD/ :
  {
    libm.a ( * )
    libc.a ( * )
    libgcc.a ( * )
  }

  .ARM.attributes 0 : { *(.ARM.attributes) }
}
