#define SCLK_set   GPIOB->BSRRL = GPIO_Pin_14;      //serial clock input
#define SCLK_clr   GPIOB->BSRRH = GPIO_Pin_14;
#define SDIN_set  GPIOB->BSRRL = GPIO_Pin_13;     //serial data input
#define SDIN_clr  GPIOB->BSRRH = GPIO_Pin_13;
#define LCD_DC_set   GPIOB->BSRRL = GPIO_Pin_12;    //data/commande
#define LCD_DC_clr   GPIOB->BSRRH = GPIO_Pin_12;
#define LCD_CE_set  GPIOB->BSRRL = GPIO_Pin_11;      //chip enable
#define LCD_CE_clr  GPIOB->BSRRH = GPIO_Pin_11;
#define LCD_RST_set  GPIOB->BSRRL = GPIO_Pin_10;     //external reset input
#define LCD_RST_clr  GPIOB->BSRRH = GPIO_Pin_10;

const unsigned char font6x8[][6] = {
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },   // sp
{ 0x00, 0x00, 0x00, 0x2f, 0x00, 0x00 },   // !
{ 0x00, 0x00, 0x07, 0x00, 0x07, 0x00 },   // "
{ 0x00, 0x14, 0x7f, 0x14, 0x7f, 0x14 },   // #
{ 0x00, 0x24, 0x2a, 0x7f, 0x2a, 0x12 },   // $
{ 0x00, 0x62, 0x64, 0x08, 0x13, 0x23 },   // %
{ 0x00, 0x36, 0x49, 0x55, 0x22, 0x50 },   // &
{ 0x00, 0x00, 0x05, 0x03, 0x00, 0x00 },   // '
{ 0x00, 0x00, 0x1c, 0x22, 0x41, 0x00 },   // (
{ 0x00, 0x00, 0x41, 0x22, 0x1c, 0x00 },   // )
{ 0x00, 0x14, 0x08, 0x3E, 0x08, 0x14 },   // *
{ 0x00, 0x08, 0x08, 0x3E, 0x08, 0x08 },   // +
{ 0x00, 0x00, 0x00, 0xA0, 0x60, 0x00 },   // ,
{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08 },   // -
{ 0x00, 0x00, 0x60, 0x60, 0x00, 0x00 },   // .
{ 0x00, 0x20, 0x10, 0x08, 0x04, 0x02 },   // /
{ 0x00, 0x3E, 0x51, 0x49, 0x45, 0x3E },   // 0
{ 0x00, 0x00, 0x42, 0x7F, 0x40, 0x00 },   // 1
{ 0x00, 0x42, 0x61, 0x51, 0x49, 0x46 },   // 2
{ 0x00, 0x21, 0x41, 0x45, 0x4B, 0x31 },   // 3
{ 0x00, 0x18, 0x14, 0x12, 0x7F, 0x10 },   // 4
{ 0x00, 0x27, 0x45, 0x45, 0x45, 0x39 },   // 5
{ 0x00, 0x3C, 0x4A, 0x49, 0x49, 0x30 },   // 6
{ 0x00, 0x01, 0x71, 0x09, 0x05, 0x03 },   // 7
{ 0x00, 0x36, 0x49, 0x49, 0x49, 0x36 },   // 8
{ 0x00, 0x06, 0x49, 0x49, 0x29, 0x1E },   // 9
{ 0x00, 0x00, 0x36, 0x36, 0x00, 0x00 },   // :
{ 0x00, 0x00, 0x56, 0x36, 0x00, 0x00 },   // ;
{ 0x00, 0x08, 0x14, 0x22, 0x41, 0x00 },   // <
{ 0x00, 0x14, 0x14, 0x14, 0x14, 0x14 },   // =
{ 0x00, 0x00, 0x41, 0x22, 0x14, 0x08 },   // >
{ 0x00, 0x02, 0x01, 0x51, 0x09, 0x06 },   // ?
{ 0x00, 0x32, 0x49, 0x59, 0x51, 0x3E },   // @
{ 0x00, 0x7C, 0x12, 0x11, 0x12, 0x7C },   // A
{ 0x00, 0x7F, 0x49, 0x49, 0x49, 0x36 },   // B
{ 0x00, 0x3E, 0x41, 0x41, 0x41, 0x22 },   // C
{ 0x00, 0x7F, 0x41, 0x41, 0x22, 0x1C },   // D
{ 0x00, 0x7F, 0x49, 0x49, 0x49, 0x41 },   // E
{ 0x00, 0x7F, 0x09, 0x09, 0x09, 0x01 },   // F
{ 0x00, 0x3E, 0x41, 0x49, 0x49, 0x7A },   // G
{ 0x00, 0x7F, 0x08, 0x08, 0x08, 0x7F },   // H
{ 0x00, 0x00, 0x41, 0x7F, 0x41, 0x00 },   // I
{ 0x00, 0x20, 0x40, 0x41, 0x3F, 0x01 },   // J
{ 0x00, 0x7F, 0x08, 0x14, 0x22, 0x41 },   // K
{ 0x00, 0x7F, 0x40, 0x40, 0x40, 0x40 },   // L
{ 0x00, 0x7F, 0x02, 0x0C, 0x02, 0x7F },   // M
{ 0x00, 0x7F, 0x04, 0x08, 0x10, 0x7F },   // N
{ 0x00, 0x3E, 0x41, 0x41, 0x41, 0x3E },   // O
{ 0x00, 0x7F, 0x09, 0x09, 0x09, 0x06 },   // P
{ 0x00, 0x3E, 0x41, 0x51, 0x21, 0x5E },   // Q
{ 0x00, 0x7F, 0x09, 0x19, 0x29, 0x46 },   // R
{ 0x00, 0x46, 0x49, 0x49, 0x49, 0x31 },   // S
{ 0x00, 0x01, 0x01, 0x7F, 0x01, 0x01 },   // T
{ 0x00, 0x3F, 0x40, 0x40, 0x40, 0x3F },   // U
{ 0x00, 0x1F, 0x20, 0x40, 0x20, 0x1F },   // V
{ 0x00, 0x3F, 0x40, 0x38, 0x40, 0x3F },   // W
{ 0x00, 0x63, 0x14, 0x08, 0x14, 0x63 },   // X
{ 0x00, 0x07, 0x08, 0x70, 0x08, 0x07 },   // Y
{ 0x00, 0x61, 0x51, 0x49, 0x45, 0x43 },   // Z
{ 0x00, 0x00, 0x7F, 0x41, 0x41, 0x00 },   // [
{ 0x00, 0x55, 0x2A, 0x55, 0x2A, 0x55 },   // 55
{ 0x00, 0x00, 0x41, 0x41, 0x7F, 0x00 },   // ]
{ 0x00, 0x04, 0x02, 0x01, 0x02, 0x04 },   // ^
{ 0x00, 0x40, 0x40, 0x40, 0x40, 0x40 },   // _
{ 0x00, 0x00, 0x01, 0x02, 0x04, 0x00 },   // '
{ 0x00, 0x20, 0x54, 0x54, 0x54, 0x78 },   // a
{ 0x00, 0x7F, 0x48, 0x44, 0x44, 0x38 },   // b
{ 0x00, 0x38, 0x44, 0x44, 0x44, 0x20 },   // c
{ 0x00, 0x38, 0x44, 0x44, 0x48, 0x7F },   // d
{ 0x00, 0x38, 0x54, 0x54, 0x54, 0x18 },   // e
{ 0x00, 0x08, 0x7E, 0x09, 0x01, 0x02 },   // f
{ 0x00, 0x18, 0xA4, 0xA4, 0xA4, 0x7C },   // g
{ 0x00, 0x7F, 0x08, 0x04, 0x04, 0x78 },   // h
{ 0x00, 0x00, 0x44, 0x7D, 0x40, 0x00 },   // i
{ 0x00, 0x40, 0x80, 0x84, 0x7D, 0x00 },   // j
{ 0x00, 0x7F, 0x10, 0x28, 0x44, 0x00 },   // k
{ 0x00, 0x00, 0x41, 0x7F, 0x40, 0x00 },   // l
{ 0x00, 0x7C, 0x04, 0x18, 0x04, 0x78 },   // m
{ 0x00, 0x7C, 0x08, 0x04, 0x04, 0x78 },   // n
{ 0x00, 0x38, 0x44, 0x44, 0x44, 0x38 },   // o
{ 0x00, 0xFC, 0x24, 0x24, 0x24, 0x18 },   // p
{ 0x00, 0x18, 0x24, 0x24, 0x18, 0xFC },   // q
{ 0x00, 0x7C, 0x08, 0x04, 0x04, 0x08 },   // r
{ 0x00, 0x48, 0x54, 0x54, 0x54, 0x20 },   // s
{ 0x00, 0x04, 0x3F, 0x44, 0x40, 0x20 },   // t
{ 0x00, 0x3C, 0x40, 0x40, 0x20, 0x7C },   // u
{ 0x00, 0x1C, 0x20, 0x40, 0x20, 0x1C },   // v
{ 0x00, 0x3C, 0x40, 0x30, 0x40, 0x3C },   // w
{ 0x00, 0x44, 0x28, 0x10, 0x28, 0x44 },   // x
{ 0x00, 0x1C, 0xA0, 0xA0, 0xA0, 0x7C },   // y
{ 0x00, 0x44, 0x64, 0x54, 0x4C, 0x44 },   // z
{ 0x14, 0x14, 0x14, 0x14, 0x14, 0x14 }    // horiz lines
};

void N5110_init(void);
void N5110_clear(void);
void N5110_set_XY(unsigned char X, unsigned char Y);
void N5110_write_english_string(unsigned char X,unsigned char Y,char *s);
void N5110_write_char(unsigned char c);
void N5110_write_byte(unsigned char dat, unsigned char command);

void delay_1us(void) {
    delay_us(70);
}
void N5110_init(void) {
    LCD_RST_clr;
    delay_1us();
    LCD_RST_set;

    LCD_CE_clr;
    delay_1us();
    LCD_CE_set;
    delay_1us();

    N5110_write_byte(0x21, 0);	// set LCD mode
    N5110_write_byte(0xc8, 0);	// set bias voltage
    N5110_write_byte(0x06, 0);	// temperature correction
    N5110_write_byte(0x13, 0);	// 1:48
    N5110_write_byte(0x20, 0);	// use bias command
    N5110_clear();	           // clear the LCD
    N5110_write_byte(0x0c, 0);	// set LCD mode,display normally

    LCD_CE_clr;
}
void N5110_clear(void) {
    unsigned int i;
    N5110_write_byte(0x0c, 0);
    N5110_write_byte(0x80, 0);
    for (i=0; i<504; i++) {
       N5110_write_byte(0, 1);
    }
}
void N5110_set_XY(unsigned char X, unsigned char Y) {
    N5110_write_byte(0x40 | Y, 0);		// row
    N5110_write_byte(0x80 | X, 0);      // column
}
void N5110_write_english_string(unsigned char X,unsigned char Y,char *s) {
    N5110_set_XY(X,Y);
    while (*s) {
        N5110_write_char(*s);
        s++;
    }
}
void N5110_write_char(unsigned char c) {
    unsigned char line;
    c -= 32;
    for (line=0; line<6; line++) {
        N5110_write_byte(font6x8[c][line], 1);
    }
}
void N5110_write_byte(unsigned char dat, unsigned char command) {
    unsigned char i;
    LCD_CE_clr;

    if (command == 0) {
        LCD_DC_clr;
    } else {
        LCD_DC_set;
    }
    delay_1us();
    for(i=0;i<8;i++) {
        if(dat&0x80) {
            SDIN_set;
        } else {
            SDIN_clr;
        } delay_1us();
        SCLK_clr; delay_1us(); delay_1us();
        dat = dat << 1;
        SCLK_set; delay_1us();
    }
    LCD_CE_set; delay_1us();
}
//void LCD_draw_bmp_pixel(unsigned char X,unsigned char Y,unsigned char *map,
//                  unsigned char Pix_x,unsigned char Pix_y)
//  {
//    unsigned int i,n;
//    unsigned char row;
//
//    if (Pix_y%8==0) row=Pix_y/8;      //calculate how many line is needed
//      else
//        row=Pix_y/8+1;
//
//    for (n=0;n<row;n++)
//      {
//      	LCD_set_XY(X,Y);
//        for(i=0; i<Pix_x; i++)
//          {
//            N5110_write_byte(map[i+n*Pix_x], 1);
//          }
//        Y++;                         //chang line
//      }
//  }
