#ifndef __MINISTM32_LCD_H__
#define __MINISTM32_LCD_H__
#include "boardcfg.h"

#define HORI					0
#define VERT					1
#define BtnNormal				255
#define BtnAnzeige			    254
#define BtnIsOn                 3
#define BtnIsOff                4
#define BtnSetOn                5
#define BtnSetOff               6

/* LCD colors */
#define LCD_White			0xFFFF
#define LCD_GrayHigh		0xC618
#define LCD_Gray				0x8410
#define LCD_GrayLow		0x528A
#define LCD_Black			0x0000
#define LCD_Blue				0x001F
#define LCD_Orange			0xFA20
#define LCD_Red				0xF800
#define LCD_Magenta		0xF81F
#define LCD_Green			0x07E0
#define LCD_Cyan				0x07FF
#define LCD_Yellow			0xFFE0
//objekt colors
//#define Objekte_in_2D	//auskommentiert -> 3D darst
//#define OCol_AnzOn			LCD_Green
//#define OCol_AnzOff			LCD_Black
#define LCD_Max_ProgBars 	18
#define LCD_Max_Buttons 	25
#ifndef Objekte_in_2D
	#define OCol_High			LCD_GrayHigh
	#define OCol_Low			LCD_GrayLow
	#define OCol_Center		LCD_Gray //3D
#else
	#define OCol_Center		LCD_Black //2D
#endif

/* Draw Funktionen */
extern void LCD_BTN_down(u8 index);
extern void LCD_BTN_up(u8 index);

void LCD_SetProgBar(u8 i, u16 Xpos, u16 Ypos, u16 Height, u16 Width, u16 Max, u16 Color, u8 Typ, u16 Value);
void LCD_SetBarVal(u8 i, u16 Value);
void LCD_DrawBars(void);
void LCD_DrawButtons(u16 Xpos, u16 Ypos);
void LCD_SetButtons(u8 i, u16 Xpos, u16 Ypos, u16 Height, u16 Width, char *txt, u8 state, u8 font, u16 foreC, u16 backC);
void LCD_SetButtonstate(u8 i, u8 state);
u8 LCD_GetButtonstate(u8 i);
void LCD_ClearBars(bool doDraw);
void LCD_ClearButtons(bool doDraw);

void LCD_DrawLine2(u16 x0, u16 y0, u16 x1, u16 y1, u16 col);
void LCD_DrawEllipse(u16 x, u16 y, u16 h, u16 w, u16 col);
void LCD_DrawLine(u16 Xpos, u16 Ypos, u16 Length, u8 Direction, u16 Color);
void LCD_DrawRect(u16 Xpos, u16 Ypos, u16 Height, u16 Width, u16 Color);
void LCD_DrawPoint(u16 x,u16 y,u16 point);
void LCD_DrawFilledRect(u16 Xpos, u16 Ypos, u16 Height, u16 Width, u16 Color);
void LCD_DrawPicture(u16 StartX,u16 StartY,u16 EndX,u16 EndY,u16 *pic);
void LCD_DrawMonoPict(unsigned char *Pict);
void LCD_DrawText(u16 x, u16 y, char *text, u16 charColor, u16 bkColor, u8 font);
void LCD_DrawTextBlock(u16 x, u16 y, char *text, u16 charColor, u16 bkColor, u8 Fill_cnt, char *Fill_char, u8 font) ;
void LCD_PutChar(u16 x,u16 y,u8 c,u16 charColor,u16 bkColor, u8 font);
void sub_WR_Dataline(u8 data, u8 a,u8 d,u8 e,u16 colC,u16 colB);

/* Treiber Funktionen */
void LCD_Enable(u8 status);
void LCD_Initializtion(void);
void LCD_Clear(u16 bkColor);
void LCD_WriteRegister(u16 index,u16 dat);
void LCD_SetCursor(u16 x,u16 y);
void LCD_SetWindows(u16 StartX,u16 StartY,u16 EndX,u16 EndY);
void LCD_Delay(u32 nCount);
void LCD_Test(void);
void LCD_WriteRAM(u16 RGB_Code);
void LCD_WriteRAM_Prepare(void);
void LCD_WriteData(u16 dat);
void LCD_WriteIndex(u16 idx);
u16 LCD_BGR2RGB(u16 c);
u16 LCD_RGB2Pixel565(u8 r, u8 g, u8 b);
//char *itoa(int, char *, int);
//char *strrev(char *);

#endif	// __MINISTM32_LCD_H__

