#ifndef __LCD18_H
#define __LCD18_H
#include "boardcfg.h"

#define LCD_W       128
#define LCD_H       160

extern  u16 BACK_COLOR, POINT_COLOR;

void Lcd18_Init(void);
void LCD18_Clear(u16 Color);
void Address_set(unsigned int x1,unsigned int y1,unsigned int x2,unsigned int y2);
void LCD18_WR_DATA8(char da);
void LCD18_WR_DATA(int da);
void LCD18_WR_REG(char da);

void LCD18_DrawText(u16 x, u16 y, char *text, u16 charColor, u16 bkColor, u8 font);
void LCD18_PutChar(u16 x,u16 y,u8 c,u16 charColor,u16 bkColor, u8 font);
void sub18_WR_Dataline(u8 data, u8 a,u8 d,u8 e,u16 colC,u16 colB);

void LCD18_DrawPoint(u16 x,u16 y, u16 color);
void LCD18_DrawPoint_big(u16 x,u16 y, u16 color);
u16  LCD18_ReadPoint(u16 x,u16 y);
void Draw_Circle(u16 x0,u16 y0,u8 r, u16 color);
void LCD18_DrawLine(u16 x1, u16 y1, u16 x2, u16 y2, u16 color);
void LCD18_DrawRectangle(u16 x1, u16 y1, u16 x2, u16 y2, u16 color);
void LCD18_Fill(u16 xsta,u16 ysta,u16 xend,u16 yend,u16 color);
void LCD18_ShowChar(u16 x,u16 y,u8 num,u8 mode);
void LCD18_ShowNum(u16 x,u16 y,u32 num,u8 len);
void LCD18_Show2Num(u16 x,u16 y,u16 num,u8 len);
void LCD18_ShowString(u16 x,u16 y,const u8 *p);

void showhanzi(unsigned int x,unsigned int y,unsigned char index);


#define WHITE         	 0xFFFF
#define BLACK         	 0x0000
#define BLUE         	 0x001F
#define BRED             0XF81F
#define GRED 			 0XFFE0
#define GBLUE			 0X07FF
#define RED           	 0xF800
#define MAGENTA       	 0xF81F
#define GREEN         	 0x07E0
#define CYAN          	 0x7FFF
#define YELLOW        	 0xFFE0
#define BROWN 			 0XBC40
#define BRRED 			 0XFC07
#define GRAY  			 0X8430

#define DARKBLUE      	 0X01CF
#define LIGHTBLUE      	 0X7D7C
#define GRAYBLUE       	 0X5458

#define LIGHTGREEN     	 0X841F
#define LGRAY 			 0XC618

#define LGRAYBLUE        0XA651
#define LBBLUE           0X2B12



#endif





