#ifndef __BOARDCFG_H__
#define __BOARDCFG_H__
/* Includes ------------------------------------------------------------------*/
#include "stm32f4xx.h"
#include "stm32f4xx_gpio.h"
#include "stm32f4xx_spi.h"
#include "stm32f4xx_rcc.h"
#include "stm32f4xx_adc.h"
#include "stm32f4xx_dma.h"
#include "stm32f4xx_exti.h"
#include "stm32f4xx_tim.h"
#include "stm32f4xx_i2c.h"
#include "stm32f4xx_pwr.h"
#include "stm32f4xx_syscfg.h"
#include "misc.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

//typedef u8  BYTE;
//typedef unsigned short WORD;
//typedef unsigned long  DWORD;
//typedef enum {false = 0, true = !false} bool;
#define bool		u8
#define true		1
#define false		0

#define BOARD_AHB1_RCCs					RCC_AHB1Periph_DMA2//
#define BOARD_APB1_RCCs					RCC_APB1Periph_PWR|RCC_APB1Periph_I2C1|RCC_APB1Periph_USART2//
#define BOARD_APB2_RCCs					RCC_APB2Periph_SPI1|RCC_APB2Periph_ADC1|RCC_APB2Periph_TIM8|RCC_APB2Periph_SYSCFG//

/* LEDs und buttons #####################*/
#define LED_Or_On				GPIOD->BSRRL = GPIO_Pin_13 //LED3 Orange
#define LED_Or_Off				GPIOD->BSRRH = GPIO_Pin_13 //LED3 Orange
#define LED_Or_Switch			GPIOD->ODR ^= GPIO_Pin_13;//toggle Orange
#define LED_Gr_On				GPIOD->BSRRL = GPIO_Pin_12 //LED4 Green
#define LED_Gr_Off				GPIOD->BSRRH = GPIO_Pin_12 //LED4 Green
#define LED_Gr_Switch			GPIOD->ODR ^= GPIO_Pin_12;//toggle Green
#define LED_R_On					GPIOD->BSRRL = GPIO_Pin_14 //LED5 Red
#define LED_R_Off					GPIOD->BSRRH = GPIO_Pin_14 //LED5 Red
#define LED_R_Switch			GPIOD->ODR ^= GPIO_Pin_14;//toggle Red
#define LED_Bl_On				GPIOD->BSRRL = GPIO_Pin_15 //LED6 Blue
#define LED_Bl_Off				GPIOD->BSRRH = GPIO_Pin_15 //LED6 Blue
#define LED_Bl_Switch			GPIOD->ODR ^= GPIO_Pin_15;//toggle Blue
#define Button_Down				((GPIOA->IDR & GPIO_Pin_0) != 0)
#define Button_Up				((GPIOA->IDR & GPIO_Pin_0) != 1)

/* LCD #####################*/
#define Use_LCD_8Bit_Latch //Display im 16bit Mode ber Latch
//#define Use_LCD_8Bit_Direct //Display im 8bit Mode
//#define Use_LCD_16Bit //Display im 16bit Mode
#define LCD_LE_H()				GPIOE->BSRRL = GPIO_Pin_7; //fr 8bit
#define LCD_LE_L()				GPIOE->BSRRH = GPIO_Pin_7; //fr 8bit
#define LCD_CS_H()				//GPIOD->BSRRL = GPIO_Pin_8;
#define LCD_CS_L()				//GPIOD->BSRRH = GPIO_Pin_8;
#define LCD_Rst_H()				GPIOD->BSRRL = GPIO_Pin_8;
#define LCD_Rst_L()				GPIOD->BSRRH = GPIO_Pin_8;
#define LCD_RS_H()				GPIOD->BSRRL = GPIO_Pin_9;
#define LCD_RS_L()				GPIOD->BSRRH = GPIO_Pin_9;
#define LCD_WR_H()				GPIOD->BSRRL = GPIO_Pin_10;
#define LCD_WR_L()				GPIOD->BSRRH = GPIO_Pin_10;
#define LCD_RD_H()				//GPIOD->BSRRL = GPIO_Pin_12;
#define LCD_RD_L()				//GPIOD->BSRRH = GPIO_Pin_12;
#define LCD_LED_H()				GPIOD->BSRRL = GPIO_Pin_11;
#define LCD_LED_L()				GPIOD->BSRRH = GPIO_Pin_11;
#define LCD_IsLedOff		    ((GPIOD->IDR & GPIO_Pin_11) != GPIO_Pin_11) //
#define LCD_DataPort_0to7		GPIOE //bei 8bit wie LCD_DataPort_8to15
#define LCD_DataPort_8to15		GPIOE

#define LCD18_SCL_H()			GPIOC->BSRRL = GPIO_Pin_4;
#define LCD18_SCL_L()			GPIOC->BSRRH = GPIO_Pin_4;
#define LCD18_DATA_H()			GPIOC->BSRRL = GPIO_Pin_5;
#define LCD18_DATA_L()			GPIOC->BSRRH = GPIO_Pin_5;
#define LCD18_CS_H()			GPIOE->BSRRL = GPIO_Pin_4;
#define LCD18_CS_L()			GPIOE->BSRRH = GPIO_Pin_4;
#define LCD18_A0_H()			GPIOE->BSRRL = GPIO_Pin_5; // data / command switch
#define LCD18_A0_L()			GPIOE->BSRRH = GPIO_Pin_5;
#define LCD18_RST_H()			GPIOE->BSRRL = GPIO_Pin_6;
#define LCD18_RST_L()			GPIOE->BSRRH = GPIO_Pin_6;
/* LCD Zusatzfunktionen/Objekte */
//#define Switch_TP_Axis		//xy vertauscht
//#define LCD_DrawTest

/* Soft I2C Bus #####################*/
//#define I2C_PORT_SCL			GPIOC
//#define I2C_PIN_SCL				GPIO_Pin_4
//#define I2C_PORT_DATA			GPIOC
//#define I2C_PIN_DATA			GPIO_Pin_5
//fr kamera
#define I2C_PORT_SCL			GPIOB
#define I2C_PIN_SCL				GPIO_Pin_6
#define I2C_PORT_DATA			GPIOB
#define I2C_PIN_DATA			GPIO_Pin_9
//ca. 400 KHz
#define I2C_Delay_Long()		Delay=14; while(Delay--){;}
#define I2C_Delay_Short()		Delay=11; while(Delay--){;}
//ca. 1 MHz
//#define I2C_Delay_Long()		Delay=7; while(Delay--){;}
//#define I2C_Delay_Short()		Delay=1; while(Delay--){;}
/* I2C Optional */
//#define IC2_DATA_MACRO_IN		GPIOC->MODER = (GPIOC->MODER & 0xCFFFFFFF) | 0x00000000;   //Pin14 -> IF
//#define IC2_DATA_MACRO_OUT		GPIOC->MODER = (GPIOC->MODER & 0xCFFFFFFF) | 0x10000000;   //Pin14 -> PP
/* I2C Device 16bit IO expander (MCP23017) */
#define IO16_DirA		0
#define IO16_DirB		1
#define IO16_OutA		18
#define IO16_OutB		19

/* SPI #####################*/
#define GPIO_SD_Port		GPIOA
#define GPIO_Pin_SD_SCK		GPIO_Pin_5
#define GPIO_Pin_SD_MISO	GPIO_Pin_6
#define GPIO_Pin_SD_MOSI	GPIO_Pin_7
/* SPI Devices */
#define GPIO_TP_CS			GPIOA
#define GPIO_Pin_TP_CS		GPIO_Pin_4
#define TP_PenDown		((GPIOB->IDR & GPIO_Pin_2) != GPIO_Pin_2) //TP_INT
#define GPIO_MOT_CS			GPIOE
#define GPIO_Pin_MOT_CS		GPIO_Pin_3
#define GPIO_L18_CS			GPIOE
#define GPIO_Pin_L18_CS		GPIO_Pin_3

/* SPI Configs*/
#define Mode_0			0
#define Mode_1			1
#define Mode_2			2
#define Mode_3			3
#define Databit8		8
#define Databit16		16
#define BaudScale_2		2	//84 MHz
#define BaudScale_4		4	//42 MHz
#define BaudScale_8		8	//21 MHz
#define BaudScale_16	16	//10.5 MHz
#define BaudScale_32	32	//5.25 MHz
#define BaudScale_64	64	//2.625 MHz
#define BaudScale_128	128	//1.312 MHz
#define BaudScale_256	255	//656.25 KHz
/* Makros */
#define FIFO_WRST_H()  GPIOD->BSRRL =GPIO_Pin_0
#define FIFO_WRST_L()  GPIOD->BSRRH  =GPIO_Pin_0
#define FIFO_WE_H()    GPIOD->BSRRL =GPIO_Pin_1
#define FIFO_WE_L()    GPIOD->BSRRH  =GPIO_Pin_1
#define FIFO_RRST_H()  GPIOD->BSRRL =GPIO_Pin_2
#define FIFO_RRST_L()  GPIOD->BSRRH  =GPIO_Pin_2
#define FIFO_CS_H()    GPIOD->BSRRL =GPIO_Pin_3
#define FIFO_CS_L()    GPIOD->BSRRH  =GPIO_Pin_3
#define FIFO_RD_H()    GPIOD->BSRRL =GPIO_Pin_4
#define FIFO_RD_L()    GPIOD->BSRRH  =GPIO_Pin_4

#define M_ON				GPIO_ResetBits(GPIO_MOT_CS, GPIO_Pin_MOT_CS)
#define M_OFF				GPIO_SetBits(GPIO_MOT_CS, GPIO_Pin_MOT_CS)
#define TP_ON  				GPIO_ResetBits(GPIO_TP_CS,GPIO_Pin_TP_CS)
#define TP_OFF 				GPIO_SetBits(GPIO_TP_CS,GPIO_Pin_TP_CS)
#define L18_ON  				GPIO_ResetBits(GPIO_L18_CS,GPIO_Pin_L18_CS)
#define L18_OFF 				GPIO_SetBits(GPIO_L18_CS,GPIO_Pin_L18_CS)
#define I2C_DATA_STATE	 		I2C_PORT_DATA->IDR & I2C_PIN_DATA
#define I2C_SCL_STATE	 		I2C_PORT_SCL->IDR & I2C_PIN_SCL
#define I2C_SCL_H()     		I2C_PORT_SCL->BSRRL = I2C_PIN_SCL;
#define I2C_SCL_L()     		I2C_PORT_SCL->BSRRH =  I2C_PIN_SCL;
#define I2C_DATA_H()     		I2C_PORT_DATA->BSRRL = I2C_PIN_DATA;
#define I2C_DATA_L()    		I2C_PORT_DATA->BSRRH =  I2C_PIN_DATA;
/* weit bekannte Funktionen/variablen */
u8 I2C_Read(u8 adresse, u8 reg, u8 *data);
u8 I2C_Send(u8 adresse, u8 reg, u8 data);
u16 readADC1(u8 channel);
//u16 TP_SPI_RW(u16 c);
void TP_GetAdXY(vs16 *x,vs16 *y);
extern void GetInReport(void);
extern void SetOutReport(void);
extern void Delay_sys(vu32 nTime);
//extern vu16 ADCConvertedValue;

#endif
