﻿//Source By Shivam Kalra (http://beta.codeproject.com/KB/cs/Webcam_Tic_Tac_Toe.aspx)
//modyfied to dual Webcam (and more) by Joe-C (joe-c.de)
using System;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using AForge.Video;
using AForge.Video.DirectShow;
using AForge.Imaging.Filters;
using System.Drawing.Imaging;
using AForge;
using AForge.Imaging;
using System.Drawing.Drawing2D;

namespace dual_webcam
{
    public partial class Form1 : Form
    {
        private Point back = Point.Empty;
        private byte cam = 0;
        private bool working = false;
        private VideoCaptureDevice video1;
        private VideoCaptureDevice video2;
        private FilterInfoCollection videosources = null;
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
        	//Kameras Suchen
        	btn_search_Click(sender,e);
        	btn_start_Click(sender,e);
         	testtimer1.Enabled = false;
        }
        void ImageProcessing(ref Bitmap image)
        {	
        	working = true;
        	//hier wird abgefragt, welche Filter benutzt werden sollen
        	//sie werden in der reihenfolge durchlaufen, wie sie auf der Form zu finden sind
        	Bitmap img = image;
        	if (check_invert.Checked)
        	{	//ein normaler invertierer
        		Invert f_inv = new Invert();
        		img = f_inv.Apply(img);
        	}
        	if (check_ColorFiltering.Checked)
        	{	//filtert rgb pixel (weiß = r&g&b)
		    	ColorFiltering f_col = new ColorFiltering();
		        f_col.Red = new IntRange((int)num_col_r2.Value, (int)num_col_r.Value);
		        f_col.Green = new IntRange((int)num_col_g2.Value, (int)num_col_g.Value);
		        f_col.Blue = new IntRange((int)num_col_b2.Value, (int)num_col_b.Value);
		        img = f_col.Apply(img);
        	}
        	if (check_ChannelFiltering.Checked)
        	{	//filtert rgb von den pixeln (weiß und rot sind nach dem filtern
        		//von blau und grün >beide< rot)
		    	ChannelFiltering f_chan = new ChannelFiltering();
		        f_chan.Red = new IntRange((int)num_chan_r2.Value, (int)num_chan_r.Value);
		        f_chan.Green = new IntRange((int)num_chan_g2.Value, (int)num_chan_g.Value);
		        f_chan.Blue = new IntRange((int)num_chan_b2.Value, (int)num_chan_b.Value);
		        img = f_chan.Apply(img);
        	}
        	
        	if (check_Edges.Checked) 
        	{	//kantenfinder
        		Edges edge = new Edges( );
				img = edge.Apply(img);
        	}
        	if (check_median.Checked) 
        	{	//mittelt jeden pixel zu seinem nachbarn (einstellung entspricht pixelreichweite)
        		Median f_medi = new Median( );
        		f_medi.Size = (int)num_median.Value;
				img = f_medi.Apply(img);	
        	}
        	if (check_EuclideanColorFiltering.Checked) 
        	{	//wieder irgend ein farbfilter
        		EuclideanColorFiltering ec = new EuclideanColorFiltering( );
        		ec.CenterColor = Color.FromArgb( (int)num_ec_r.Value, (int)num_ec_g.Value, (int)num_ec_b.Value );
        		ec.Radius = (short)num_ec_radius.Value;
				img = ec.Apply(img);
        	}
        	if (check_blur.Checked) 
        	{	//weichzeichnen
        		Blur f_blur = new Blur();
        		img = f_blur.Apply(img);
        	}
        	if (check_sharpen.Checked) 
        	{	//schärfen
        		Sharpen f_Sharpen = new Sharpen();
        		img = f_Sharpen.Apply(img);
        	}
        	if (check_intersect.Checked) 
        	{	//nur die niedrigsten pixel werden ersetzt, hellere werden übersprungen 
        		Intersect f_inter = new Intersect((Bitmap)pictureBox2.Image);
        		img = f_inter.Apply(img);
        	}
        	if (check_merge.Checked) 
        	{	//gegenteil von intersect, nur hellere pixel werden übernommen
        		Merge f_merge = new Merge((Bitmap)pictureBox2.Image);
        		img = f_merge.Apply(img);
        	}
        	if (check_tow.Checked) 
        	{	//markiert gefundene ecken mit einem roten punkt
        		SusanCornersDetector scd = new SusanCornersDetector( );
				CornersMarker filter = new CornersMarker( scd, Color.Red );
        		img = filter.Apply(img);
        	}
        	if (check_Threshold.Checked) 
        	{	//unwandeln in weiß und schwarz (ohne graustufen)
        		Threshold filter = new Threshold( );
        		IFilter gray = new Grayscale(0.2125, 0.7154, 0.0721);
	        	filter.ThresholdValue = (int)num_Threshold.Value;
	        	img = gray.Apply(img);
	        	img = filter.Apply(img);
	        	pictureBox2.Image = img;
	        	//wenn der threshold filter aktiv ist, gibt es im bild nur noch schwarz und weiß
            	//trifft dieses bild auf den graustufenfilter, gibts ne fehlermeldung
            	working = false;
            	return;
        	}
        	if (check_morph.Checked) 
        	{	//funktioniert wie average (0,20 = 20% vom eingangsbild werden eingefügt)
	        	Morph f_morph = new Morph((Bitmap)pictureBox2.Image);
	        	f_morph.SourcePercent = (double)num_morph.Value;
	        	img = f_morph.Apply(img);
        	}
        	
        	//bild in graustufen umwandeln
        	IFilter grayscale = new Grayscale( 0.2125, 0.7154, 0.0721 );          
            Bitmap tmp = grayscale.Apply(img);
            
			//Objektcounter erstellen (objekte unter 2,5% werden ignoriert)
			BlobCounter bc = new BlobCounter();
			bc.FilterBlobs = true;
			bc.MinHeight = img.Height / 40;
			bc.MinWidth = img.Width / 40;
			bc.ObjectsOrder = ObjectsOrder.Area;
			//bild auf objekte untersuchen
			//gefundene in ein rechteck objektarray speichern
			BitmapData bitmapData = tmp.LockBits(new Rectangle(0, 0, img.Width-1, img.Height-1),
            ImageLockMode.ReadWrite, PixelFormat.Format8bppIndexed);
			bc.ProcessImage(bitmapData);
			tmp.UnlockBits(bitmapData);
            tmp.Dispose();
			Rectangle[] rects = bc.GetObjectsRectangles();
			Blob[] blobs = bc.GetObjectsInformation( );
			//dank "ObjectsOrder.Area" wird das objekt
			//mit den meißten pixeln im index 0 liegen
			if (rects.Length > 0) 
			{
				back = GetCenter(rects[0]);
	            if (check_filter.Checked)
	            {	//gefiltertes bild anzeigen
	            	if (check_imagedata.Checked) 
	        		{	//rechteck und werte darstellen
	            		Drawrect(ref img, back,rects[0],blobs[0]);
	            	}
	            	pictureBox2.Image = img;
	            	working = false;
	            	return;
	            }
	            if (check_imagedata.Checked) 
	    		{	//nur rechteck und werte auf dem normalbild anzeigen
	        		Drawrect(ref image, back,rects[0],blobs[0]);
	        		working = false;
	        		return;
	        	}
			}
			else 
			{
				pictureBox2.Image = img;
				working = false;
			}
        }
        Point GetCenter(Rectangle rect)
        {	//mittelpunkt eines rechtecks berechnen
            int x = rect.X + (rect.Width / 2);
            int y = rect.Y + (rect.Height / 2);
            Point p = new Point(x, y);
            return p;
        }
        unsafe void Drawrect(ref Bitmap image, Point p, Rectangle rect, Blob blob)
        {	//zum zeichnen auf der bildfläche
        	Graphics g = Graphics.FromImage(image);
            Pen p1 = new Pen(Color.Lime, 1);
            Point px = new Point(back.X-5, back.Y);
            Point px2 = new Point(back.X+5, back.Y);
            Point py = new Point(back.X, back.Y-5);
            Point py2 = new Point(back.X, back.Y+5);
            Font f = new Font("Arial", 8);
            Brush br = Brushes.Lime;
        	//oben: komponenten erstellen... unten: komponenten darstellen
        	g.DrawRectangle(p1,rect);
	        g.DrawLine(p1,px,px2);
	        g.DrawLine(p1,py,py2);
	        g.DrawString("Objektpixel: "+blob.Area,f,br,10, image.Height -40);
        	g.DrawString("Größe: X="+rect.Width+" Y="+rect.Height,f,br,10, image.Height -30);
       		g.DrawString("Position: X="+rect.X+" Y="+rect.Y,f,br,10, image.Height -20);
        }
        private void video_NewFrame(object sender, NewFrameEventArgs eventArgs)
        {	//quelle 1 (links)
        	pictureBox1.Image = (Bitmap)eventArgs.Frame.Clone();
        }
		private void video_NewFrame2(object sender, NewFrameEventArgs eventArgs)
        {	//quelle 2 (rechts mit videoprocessing)
            Bitmap img = (Bitmap)eventArgs.Frame.Clone();
            if (check_copyto1.Checked) 
            {	//eingangsbild von quelle 2 auch bei 1 anzeigen
            	pictureBox1.Image = (Bitmap)eventArgs.Frame.Clone();
            	if (!(video1 == null))
            	{
	            	if (video1.IsRunning)
	                {	//sollte die videoquelle noch laufen... stoppen
	                    video1.SignalToStop();
	                    video1 = null;
	                    video_cb1.ForeColor = Color.FromArgb(0,255,255,0);
	                }
            	}
            }
        	if (check_ImageProcessing.Checked)
        	{ 	//ResizeBilinear filter2 = new ResizeBilinear(img.Width * 2, img.Height * 2);
	            //img = filter2.Apply(img); //auflösung halbiert
         		//wenn der vorherige durchlauf noch nicht fertig ist, überspringen
	        	if (working == false) {
	        		ImageProcessing(ref img);
	        	}
	            if (!check_filter.Checked)
	            {
	            	pictureBox2.Image = img;
	            }
        	}
        	else
        	{
        		
        		pictureBox2.Image = img;
        	}
        }
        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            btn_stop_Click(sender,e);
        }
        void btn_start_Click(object sender, EventArgs e)
        {
        	working = false;
        	if ((video_cb1.SelectedIndex > 0) & (video1 == null))
            {	//videoquelle starten
                video1 = new VideoCaptureDevice(videosources[video_cb1.SelectedIndex-1].MonikerString);
            	video1.NewFrame += new NewFrameEventHandler(video_NewFrame);
                video1.DesiredFrameRate = (int)num_fps1.Value;
                video1.DesiredFrameSize = new Size((int)num_source1_w.Value, (int)num_source1_h.Value);
                video1.Start();
                if (video1.IsRunning == true) 
                {
                	video_cb1.ForeColor = Color.FromArgb(0,0,180,0);
                }
            }
        	if ((video_cb2.SelectedIndex > 0) & (video2 == null))
            {
            	video2 = new VideoCaptureDevice(videosources[video_cb2.SelectedIndex-1].MonikerString);
                video2.NewFrame += new NewFrameEventHandler(video_NewFrame2);
                video2.DesiredFrameRate = (int)num_fps2.Value;
                video2.DesiredFrameSize = new Size((int)num_source2_w.Value, (int)num_source2_h.Value);
                video2.Start();
                if (video2.IsRunning == true) 
                {
                	video_cb2.ForeColor = Color.FromArgb(0,0,180,0);
                }
            }
            if ((video1 == null)&(video2 == null))
            {
            	MessageBox.Show("Menge der Kameras: "+videosources.Count,"Keine Kamera aktiv");
            }
        }
        void btn_stop_Click(object sender, EventArgs e)
        {
        	if (!(video1 == null))
                if (video1.IsRunning)
                {
                    video1.SignalToStop();
                    video1 = null;
                }
            if (!(video2 == null))
                if (video2.IsRunning)
                {
                    video2.SignalToStop();
                    video2 = null;
                }
            video_cb1.ForeColor = Color.FromArgb(0,255,0,0);
            video_cb2.ForeColor = Color.FromArgb(0,255,0,0);
            working = false;
        }
        void btn_search_Click(object sender, EventArgs e)
        {	//video_combobox leer machen
        	video_cb1.Items.Clear();
        	video_cb2.Items.Clear();
        	cam = 0;
        	btn_stop_Click(sender,e);
        	//video_combobox mit neuem Inhalt füllen
        	videosources = new FilterInfoCollection(FilterCategory.VideoInputDevice);
            if (videosources.Count != 0)
            {
            	video_cb1.Items.Add("Keine Kamera");
                video_cb2.Items.Add("Keine Kamera");
                foreach (FilterInfo videosource in videosources)
                {
                	cam++;
                    video_cb1.Items.Add("("+cam+") "+videosource.Name);
                    video_cb2.Items.Add("("+cam+") "+videosource.Name);        
                }
                video_cb1.ForeColor = Color.FromArgb(0,180,180,0);
                video_cb2.ForeColor = Color.FromArgb(0,180,180,0);
                if (videosources.Count == 1) 
                {
                	video_cb1.SelectedIndex = 0;
                	video_cb2.SelectedIndex = 1;
                }
                else
                {
                	video_cb1.SelectedIndex = 1;
            		video_cb2.SelectedIndex = 2;
            		
                }
            }
            else
            {
                video_cb1.Items.Add("Keine Kamera gefunden");
                video_cb2.Items.Add("Keine Kamera gefunden");
                video_cb1.ForeColor = Color.FromArgb(0,255,0,0);
                video_cb2.ForeColor = Color.FromArgb(0,255,0,0);
                video_cb1.SelectedIndex = 0;
                video_cb2.SelectedIndex = 0;
            }
            //nur Infobox anzeigen, wenn manuell nach Geräten gesucht wurde
            //beim starten des Programms keine Infobox
            if (sender is Button)
            {
            	MessageBox.Show("Anzahl der Kameras : "+videosources.Count,"Suchergebnisse",
            	                MessageBoxButtons.OK,MessageBoxIcon.Exclamation);
            }
            	
        }       
        void Button1Click(object sender, EventArgs e)
        {	//test mit einem testbild, falls keine kamera verfügbar ist
        	//event. aktive kamera vorher abschalten
        	btn_stop_Click(sender,e);
        	if (testtimer1.Enabled) {
        		testtimer1.Enabled = false;
        		button1.Text = "Testbild OFF";
        	}
        	else{
        		testtimer1.Enabled = true;
        		button1.Text = "Testbild ON";
        	}
        }       
        void Testtimer1Tick(object sender, EventArgs e)
        {  	// \bin\Debug\test.jpg
  			Bitmap img = new Bitmap("test.jpg"); 
        	pictureBox1.Image = img;
        	if (check_ImageProcessing.Checked)
        	{
	        	ResizeBilinear filter2 = new ResizeBilinear(img.Width * 2, img.Height * 2);
	            img = filter2.Apply(img);
	            ImageProcessing(ref img);
	            
        	}
        	if (!check_filter.Checked)
            {
            	pictureBox2.Image = img;
            }
        }
        void Setting_cam1Click(object sender, EventArgs e)
        {	//treiberfenster anzeigen
        	if (!(video1 == null)) {
        		video1.DisplayPropertyPage(IntPtr.Zero);
        	}
        }
        void Setting_cam2Click(object sender, EventArgs e)
        {	//treiberfenster anzeigen
        	if (!(video1 == null)) {
        		video2.DisplayPropertyPage(IntPtr.Zero);
        	}
        }
        void Btn_save_source2Click(object sender, EventArgs e)
        {	//das rechte, aktuell angezeigte bild (mit videoprocessing) abspeichern
        	Bitmap image = (Bitmap)pictureBox2.Image;
        	image.Save("image.jpg",ImageFormat.Jpeg);
        }
     }
}
