﻿using MiniStm32JoeC_CoreLibrary;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.IO.Ports;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace SerialTool_STM32Mini
{
    public partial class SerialForm : Form
    {
        MiniStm32BoardJoeC _board = new MiniStm32BoardJoeC(ConnectionType.Serial_RS232_UART);
        Color colTimeStamp = Color.Silver;
        Color colTxSend = Color.Red;
        Color colRxGet = Color.Blue;
        enum direction {
            undefined,
            Rx_Get,
            Tx_Send
        }
        direction _lastDirection = direction.undefined;
        StringBuilder _sbReceived = new StringBuilder();
        double _voltCountStep = 0;
        bool _wait4Response = false;
        string _startupPort = "";
        bool _skipSerialPortEvents = false;
        delegate void Dele_void();

        #region Form_SerialCore
        public SerialForm()
        {
            InitializeComponent();
            Thread.CurrentThread.CurrentCulture = System.Globalization.CultureInfo.CreateSpecificCulture("en-GB");
            //Encoding anpassen
            SP.Encoding = System.Text.Encoding.Default;
            _board.Event_Transmission_Text += _board_Event_Transmission_Text;

            uC_PinMap1.Init(_board);
            uC_ADC1.Init(_board);
            uC_SPI1.Init(_board);
            uC_RgbLed1.Init(_board);
            uC_I2C1.Init(_board);
            uC_Script1.Init(_board);
            uC_I2C_Slaves1.Init(_board);
            uC_StepperMotion1.Init(_board);
        }
        void SerialForm_FormClosing(object sender, FormClosingEventArgs e) {
            try {
                if (SP.IsOpen) {
                    SP.Close();
                }
            }
            catch (Exception) { ; }
        }
        private string _board_Event_Transmission_Text(string arg) {
            try {
                string resp = TransmissionUart(arg);
                return resp;
            }
            catch (Exception ex) {
                LogRs232_AppedTextOnly("Transmission_Text:" + ex.Message, Color.Fuchsia);
            }
            return "";
        }

        void SerialForm_Shown(object sender, EventArgs e)
        {
            CB_RS232_baud.SelectedIndex = 4;//115200
            string appCfg_Baud = FromAppConfig("SerialBaud","");
            if (!string.IsNullOrEmpty(appCfg_Baud)) {
                txt_rs232_baud.Text = appCfg_Baud;
            }
            _startupPort = FromAppConfig("SerialPort", "");
            uC_PinMap1.SetReferenceOffsets(FromAppConfig("OffsetVoltageReferenceCounts", 0), FromAppConfig("OffsetTemperatureCounts", 0));
            btn_rs232_refresh_Click(null, null);
            uC_FlashLoaderStm321.Init(SP, true, true);
        }
        string FromAppConfig(string nameOf_AppConfig_Entry, string defaultValue) {
            try {
                string entry = System.Configuration.ConfigurationManager.AppSettings[nameOf_AppConfig_Entry];
                return entry;
            }
            catch (Exception err) {
                LogRs232_AppedText($"FromAppConfig('{nameOf_AppConfig_Entry}')->{err.Message}", Color.Fuchsia);
            }
            return defaultValue;
        }
        int FromAppConfig(string nameOf_AppConfig_Entry, int defaultValue) {
            string entry = FromAppConfig(nameOf_AppConfig_Entry, "");
            int output = 0;
            if (int.TryParse(entry,out output)) {
                return output;
            }
            LogRs232_AppedText($"FromAppConfig('{nameOf_AppConfig_Entry}')->Can't convert '{entry}' to integer.", Color.Fuchsia);
            return defaultValue;
        }

        //serial port events
        void timer_PollSerial_Tick(object sender, EventArgs e) {
            //poll: less CPU load and more stable than direct event...
            if (_skipSerialPortEvents) { return; }
            if (!SP.IsOpen || SP.BytesToRead == 0) {
                return;
            }
            string text = SP.ReadExisting();
            _sbReceived.Append(text);
            if (CHK_RS232_SkipShowTraffic.Checked) {
                //external traffic
                return;
            }
            LogRs232_AppedTime(direction.Rx_Get);
            LogRs232_AppedText(text, colRxGet);
        }
        //private void SP_DataReceived(object sender, SerialDataReceivedEventArgs e)
        //{
        //    if (_skipSerialPortEvents) { return; }
        //    if(InvokeRequired) {
        //        try {
        //            Invoke(new SerialDataReceivedEventHandler(SP_DataReceived), new object[] { sender, e });
        //        } catch(Exception ex) {
        //            MessageBox.Show(ex.ToString(), "SP_DataReceived");
        //        }
        //        return;
        //    }
        //    LogRs232_AppedTime(direction.Rx_Get);
        //    string text = SP.ReadExisting();
        //    _sbReceived.Append(text);
        //    LogRs232_AppedText(text, colRxGet);
        //}
        private void SP_ErrorReceived(object sender, SerialErrorReceivedEventArgs e)
        {
            if (_skipSerialPortEvents) { return; }
            if (InvokeRequired) {
                try {
                    Invoke(new SerialErrorReceivedEventHandler(SP_ErrorReceived), new object[] { sender, e });
                } catch(Exception ex) {
                    MessageBox.Show(ex.ToString(), "SP_ErrorReceived");
                }
                return;
            }
            LogRs232_AppedTime(direction.Rx_Get);
            LogRs232_AppedText("SP_ErrorReceived: "+e.ToString(), Color.Fuchsia);
        }
        private void SP_PinChanged(object sender, SerialPinChangedEventArgs e)
        {
            if (_skipSerialPortEvents) { return; }
            if (InvokeRequired) {
                try {
                    Invoke(new SerialPinChangedEventHandler(SP_PinChanged), new object[] { sender, e });
                } catch(Exception ex) {
                    MessageBox.Show(ex.ToString(), "SP_PinChanged");
                }
                return;
            }
            LogRs232_AppedTime(direction.Rx_Get);
            LogRs232_AppedText("SP_PinChanged: " + e.ToString(), Color.DarkMagenta);
        }
        //Steuerleitung
        void Pin_Changed()
        {
            //Steuerleitungslabels aktualisieren
            if(SP.CDHolding) {
                label_CD.BackColor = Color.Lime;
            } else {
                label_CD.BackColor = Color.Gainsboro;
            }
            if(SP.CtsHolding) {
                label_CTS.BackColor = Color.Lime;
            } else {
                label_CTS.BackColor = Color.Gainsboro;
            }
            if(SP.DsrHolding) {
                label_DSR.BackColor = Color.Lime;
            } else {
                label_DSR.BackColor = Color.Gainsboro;
            }
        }
        
        string TransmissionUart(string tx, double timeoutSeconds = 3) {
            if (!SP.IsOpen) { LogRs232_AppedTextOnly($"Port not open...", Color.Gray); return "Port not open!"; }
            _wait4Response = true;
            string TX = "";
            if(CHK_RS232_UseStartByte.Checked) { TX = "" + (char)num_RS232_Startbyte.Value; }
            TX = TX + tx;
            if(CHK_RS232_UseEndByte.Checked) { TX = TX + (char)num_RS232_Endbyte.Value; }

            _sbReceived.Clear();
            if (!CHK_RS232_SkipShowTraffic.Checked) {
                LogRs232_AppedTime(direction.Tx_Send);
                LogRs232_AppedText(TX, colTxSend);
            }
            SP.Write(TX);

            long timeoutTics = DateTime.Now.AddSeconds(timeoutSeconds).Ticks;
            while(_wait4Response) {
                Application.DoEvents();
                if(_sbReceived.ToString().Contains('\r')) {
                    break;
                }
                if(DateTime.Now.Ticks > timeoutTics) {
                    return "Timeout!";
                }
                System.Threading.Thread.Sleep(10);
            }
            return _sbReceived.ToString();
        }
        #endregion
        #region Tab_SerialTerminal
        void btn_rs232_refresh_Click(object sender, EventArgs e)
        {
            if(SP.IsOpen) { MessageBox.Show("Port is open, can't scan..."); return; }
            CB_RS232_Port.Items.Clear();
            //Comm Ports finden
            int Baud = 0; int.TryParse(txt_rs232_baud.Text, out Baud);
            if(Baud == 0) {
                MessageBox.Show("Baudrate (" + txt_rs232_baud.Text + ") konnte nicht erkannt werden.");
                return;
            } else {
                SP.BaudRate = Baud;
            }
            int selectIndex = 0;
            int startSearch = FromAppConfig("SerialSearchSart", 1);
            int stopSearch = FromAppConfig("SerialSearchStop", 99);
            LogRs232_AppedTextOnly($"Search Com ports from '{startSearch}' to '{stopSearch}'", Color.Gray);
            for(int i = startSearch; i < stopSearch; i++) {
                SP.PortName = "COM" + i.ToString();
                try {
                    SP.Open();
                    if(SP.IsOpen) {
                        CB_RS232_Port.Items.Add(SP.PortName);
                        if (SP.PortName == _startupPort) {
                            selectIndex = CB_RS232_Port.Items.Count - 1;
                            string stayopen = FromAppConfig("SerialPortAutoOpenIfFound", "0");
                            if (stayopen == "1") {
                                CB_RS232_Port.SelectedIndex = selectIndex;
                                LogRs232_AppedText("Found specified Port, skip search...", Color.Green);
                                BTN_RS232_Open.ForeColor = Color.LimeGreen;
                                BTN_RS232_Open.Text = "Close";
                                return;
                            }
                        }
                        SP.Close();
                    }
                } catch(Exception) {

                }
            }
            if(CB_RS232_Port.Items.Count == 0) {
                CB_RS232_Port.Items.Add("Keine Ports gefunden.");
            }
            CB_RS232_Port.SelectedIndex = selectIndex;
        }

        void LogRs232_AppedTime(direction dir) {
            if(dir == _lastDirection) {
                return;
            }
            _lastDirection = dir;
            TXTR_Text.SelectionColor = colTimeStamp;
            TXTR_Byte.SelectionColor = colTimeStamp;
            switch(dir) {
                case direction.undefined:
                    TXTR_Text.SelectedText += $"\r\n{String.Format("{0:dd.MM.yyyy HH:mm:ss}",DateTime.Now)}\t";
                    TXTR_Byte.SelectedText += $"\r\n{String.Format("{0:HH:mm:ss}", DateTime.Now)}\t";
                    break;
                default:
                    TXTR_Text.SelectedText += $"\r\n{dir} {String.Format("{0:dd.MM.yyyy HH:mm:ss}", DateTime.Now)}\t";
                    TXTR_Byte.SelectedText += $"\r\n{dir} {String.Format("{0:HH:mm:ss}", DateTime.Now)}\t";
                    break;
            }
        }
        void LogRs232_AppedText(string text, Color color) {
            StringBuilder SB_B = new StringBuilder(60);
            StringBuilder SB_S = new StringBuilder(30);
            try {
                string Input = text;
                //textinhalt in Zeichenarray umsetzen
                char[] Chars = Input.ToCharArray();
                byte[] buffer = UnicodeEncoding.Default.GetBytes(Chars);
                if(CHK_RS232_Sonderzeichen.Checked) {//Sonderzeichen Filtern
                    foreach(byte B in buffer) {
                        switch(B) {
                            case 0:
                                SB_B.Append("0 "); SB_S.Append("<NULL>"); break;
                            case 9:
                                SB_B.Append("9 "); SB_S.Append("<TAB>"); break;
                            case 10:
                                SB_B.Append("10 "); SB_S.Append("<LF>"); break;
                            case 13:
                                SB_B.Append("13 "); SB_S.Append("<CR>"); break;
                            //case 32:
                            //    SB_B.Append("32 "); SB_S.Append("<SP>"); break;
                            case 127:
                                SB_B.Append("127 "); SB_S.Append("<DEL>"); break;
                            default:
                                SB_B.Append(B.ToString() + " "); SB_S.Append((char)B); break;
                        }
                    }
                } else { //Sonderzeichen nicht Filtern
                    if(CHK_RS232_Hexadecimal.Checked) {
                        foreach(byte B in buffer) {
                            if(B > 0) {
                                SB_B.Append(B.ToString("X02") + " ");
                                SB_S.Append((char)B);
                            } else {
                                SB_B.Append("00 ");
                                SB_S.Append('0');
                            }
                        }
                    } else {
                        foreach(byte B in buffer) {
                            if(B > 0) {
                                SB_B.Append(B.ToString() + " ");
                                SB_S.Append((char)B);
                            } else {
                                SB_B.Append("0 ");
                                SB_S.Append('0');
                            }
                        }
                    }
                }

            } catch(Exception err) {
                MessageBox.Show(err.Message, "Fehler beim Umwandeln in Bytes");
                //sending_bool = false;
                return;
            }
            TXTR_Text.SelectionColor = color;
            TXTR_Text.AppendText(SB_S.ToString());
            TXTR_Text.ScrollToCaret();
            TXTR_Byte.SelectionColor = color;
            TXTR_Byte.AppendText(SB_B.ToString());
            TXTR_Byte.ScrollToCaret();
        }
        void LogRs232_AppedTextOnly(string text, Color color) {
            StringBuilder SB_S = new StringBuilder(30);
            try {
                string Input = text;
                //textinhalt in Zeichenarray umsetzen
                char[] Chars = Input.ToCharArray();
                byte[] buffer = UnicodeEncoding.Default.GetBytes(Chars);
                if (CHK_RS232_Sonderzeichen.Checked) {//Sonderzeichen Filtern
                    foreach (byte B in buffer) {
                        switch (B) {
                            case 0: SB_S.Append("<NULL>"); break;
                            case 9: SB_S.Append("<TAB>"); break;
                            case 10: SB_S.Append("<LF>"); break;
                            case 13: SB_S.Append("<CR>"); break;
                            //case 32:
                            //    SB_B.Append("32 "); SB_S.Append("<SP>"); break;
                            case 127: SB_S.Append("<DEL>"); break;
                            default: SB_S.Append((char)B); break;
                        }
                    }
                }
                else { //Sonderzeichen nicht Filtern
                    if (CHK_RS232_Hexadecimal.Checked) {
                        foreach (byte B in buffer) {
                            if (B > 0) {
                                SB_S.Append((char)B);
                            }
                            else {
                                SB_S.Append('0');
                            }
                        }
                    }
                    else {
                        foreach (byte B in buffer) {
                            if (B > 0) {
                                SB_S.Append((char)B);
                            }
                            else {
                                SB_S.Append('0');
                            }
                        }
                    }
                }

            }
            catch (Exception err) {
                MessageBox.Show(err.Message, "Fehler beim Umwandeln in Bytes");
                //sending_bool = false;
                return;
            }
            TXTR_Text.SelectionColor = color;
            TXTR_Text.SelectedText += SB_S.ToString();
            TXTR_Text.ScrollToCaret();
        }

        void CB_RS232_baud_SelectedIndexChanged(object sender, EventArgs e)
        {
            txt_rs232_baud.Text = CB_RS232_baud.SelectedItem.ToString();
        }
        void btn_rs232_RTS_Click(object sender, EventArgs e)
        {
            //Steuerleitung vom Port
            if(btn_rs232_RTS.BackColor == Color.Lime) {
                SP.RtsEnable = false;
                btn_rs232_RTS.BackColor = Color.Gainsboro;
            } else {
                SP.RtsEnable = true;
                btn_rs232_RTS.BackColor = Color.Lime;
            }
        }
        void btn_rs232_DTR_Click(object sender, EventArgs e)
        {
            //Steuerleitung vom Port
            if(btn_rs232_DTR.BackColor == Color.Lime) {
                SP.DtrEnable = false;
                btn_rs232_DTR.BackColor = Color.Gainsboro;
            } else {
                SP.DtrEnable = true;
                btn_rs232_DTR.BackColor = Color.Lime;
            }
        }
        void BTN_RS232_Open_Click(object sender, EventArgs e)
        {
            if(!CB_RS232_Port.SelectedItem.ToString().StartsWith("COM")) {
                btn_rs232_refresh_Click(null, null);
                if(!CB_RS232_Port.SelectedItem.ToString().StartsWith("COM")) { return; }
            }
            if(BTN_RS232_Open.ForeColor != Color.LimeGreen) {
                try {
                    //SP.BaudRate = int.Parse(CB_RS232_baud.SelectedItem.ToString());
                    SP.BaudRate = int.Parse(txt_rs232_baud.Text);
                    SP.PortName = CB_RS232_Port.SelectedItem.ToString();

                    SP.Open();
                    if(SP.IsOpen) {
                        BTN_RS232_Open.ForeColor = Color.LimeGreen;
                        BTN_RS232_Open.Text = "Close";
                    } else {
                        BTN_RS232_Open.ForeColor = Color.Red;
                    }
                    Pin_Changed();
                } catch(Exception err) {
                    BTN_RS232_Open.ForeColor = Color.Red;
                    MessageBox.Show(err.Message, "Fehler beim öffnen des Ports");
                }
            } else {
                //farbe = grün... port ist offen, daher schließen
                BTN_RS232_Open.Text = "Open";
                BTN_RS232_Open.ForeColor = Color.Black;

                try {
                    SP.Close();
                } catch(Exception) {
                    btn_rs232_refresh_Click(null, null);
                }

            }
        }

        void TXT_Send_S_KeyDown(object sender, KeyEventArgs e) {
            
            if(e.KeyData != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound
            if(!SP.IsOpen) { LogRs232_AppedTextOnly($"Port not open...", Color.Gray); return; }

            //sending_bool = true;
            string TX = "";
            _sbReceived.Clear();
            if(CHK_RS232_UseStartByte.Checked) { TX = "" + (char)num_RS232_Startbyte.Value; }
            TX = TX + TXT_Send_S.Text;
            if(CHK_RS232_UseEndByte.Checked) { TX = TX + (char)num_RS232_Endbyte.Value; }
            SP.Write(TX);

            LogRs232_AppedTime(direction.Tx_Send);
            LogRs232_AppedText(TX, colTxSend);
        }
        void TXT_Send_S2_KeyDown(object sender, KeyEventArgs e) {

            if (e.KeyData != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound
            if (!SP.IsOpen) { LogRs232_AppedTextOnly($"Port not open...", Color.Gray); return; }

            //sending_bool = true;
            string TX = "";
            _sbReceived.Clear();
            if (CHK_RS232_UseStartByte.Checked) { TX = "" + (char)num_RS232_Startbyte.Value; }
            TX = TX + TXT_Send_S2.Text;
            if (CHK_RS232_UseEndByte.Checked) { TX = TX + (char)num_RS232_Endbyte.Value; }
            SP.Write(TX);

            LogRs232_AppedTime(direction.Tx_Send);
            LogRs232_AppedText(TX, colTxSend);
        }

        void TXT_Send_S3_KeyDown(object sender, KeyEventArgs e) {

            if (e.KeyData != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound
            if (!SP.IsOpen) { LogRs232_AppedTextOnly($"Port not open...", Color.Gray); return; }

            //sending_bool = true;
            string TX = "";
            _sbReceived.Clear();
            if (CHK_RS232_UseStartByte.Checked) { TX = "" + (char)num_RS232_Startbyte.Value; }
            TX = TX + TXT_Send_S3.Text;
            if (CHK_RS232_UseEndByte.Checked) { TX = TX + (char)num_RS232_Endbyte.Value; }
            SP.Write(TX);

            LogRs232_AppedTime(direction.Tx_Send);
            LogRs232_AppedText(TX, colTxSend);
        }

        void txt_generic_send_KeyDown(object sender, KeyEventArgs e) {
            if (!SP.IsOpen) { LogRs232_AppedTextOnly($"Port not open...", Color.Gray); return; }
            if (e.KeyData != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound

            //sending_bool = true;
            string TX = "#" + txt_generic_Type.Text;
            _sbReceived.Clear();
            if (CHK_RS232_UseStartByte.Checked) { TX = "" + (char)num_RS232_Startbyte.Value; }
            string[] splits = txt_generic_send.Text.Split(',');
            TX = $"{TX}{splits.Length+1}|{num_generic_commandNr.Value},{txt_generic_send.Text}";
            if (CHK_RS232_UseEndByte.Checked) { TX = TX + (char)num_RS232_Endbyte.Value; }
            SP.Write(TX);

            LogRs232_AppedTime(direction.Tx_Send);
            LogRs232_AppedText(TX, colTxSend);
        }
        void btn_rs232_changeBaud_Click(object sender, EventArgs e) {
            try {
                string baudStr = CB_RS232_baudChange.SelectedItem.ToString();
                Int32 baud = Int32.Parse(baudStr);
                byte b0 = (byte)((baud >> 24) & 0xff);
                byte b1 = (byte)((baud >> 16) & 0xff);
                byte b2 = (byte)((baud >> 8) & 0xff);
                byte b3 = (byte)(baud & 0xff);
                TransmissionUart($"#S6|21,1,{b0},{b1},{b2},{b3},");
                SP.Close();
                BTN_RS232_Open.ForeColor = Color.Black;
                CB_RS232_baud.SelectedIndex = CB_RS232_baudChange.SelectedIndex;
                Application.DoEvents();
                BTN_RS232_Open_Click(null, null);
                TransmissionUart($"#X10|1,");
            } catch (Exception ex) {
                LogRs232_AppedText(ex.Message, Color.Red);
            }
        }

        void BTN_RS232_Clear_Click(object sender, EventArgs e)
        {
            TXTR_Text.Clear();
            TXTR_Byte.Clear();
        }
        void BTN_RS232_Save_Click(object sender, EventArgs e)
        {
            saveFileDialog1.FileName = "rs232_Text.rtf";
            if(saveFileDialog1.ShowDialog() == DialogResult.OK) {
                TXTR_Text.SaveFile(saveFileDialog1.FileName);
            }
            saveFileDialog1.FileName = "rs232_Byte.rtf";
            if(saveFileDialog1.ShowDialog() == DialogResult.OK) {
                TXTR_Byte.SaveFile(saveFileDialog1.FileName);
            }
        }
        #endregion
        #region Tab_Direct
        //Pin Remap
        void btn_GetBoardInformations_Click(object sender, EventArgs e) {
            try {
                uC_PinMap1.RefreshBoardInfo(chk_ReadGpio.Checked);
            }
            catch (Exception ex) {
                LogRs232_AppedTextOnly("btn_GetBoardInformations_Click:" + ex.Message, Color.Fuchsia);
                uC_PinMap1.AddToLog("Ex: " + ex.Message);
            }
        }
        //ADC
        void btn_Adc_ReadAll_Click(object sender, EventArgs e) {
            try {
                uC_ADC1.AdcReadDynamic();
            }
            catch (Exception ex) {
                LogRs232_AppedTextOnly("btn_Adc_ReadAll_Click:" + ex.Message, Color.Fuchsia);
                uC_PinMap1.AddToLog("Ex: " + ex.Message);
            }
        }
        #endregion
        void tabControlMain_SelectedIndexChanged(object sender, EventArgs e) {
            _skipSerialPortEvents = (tabControlMain.SelectedTab == TP_FlashLoader);
            SP.ReceivedBytesThreshold = (_skipSerialPortEvents) ? 1000 : 1;
            SP.Parity = (_skipSerialPortEvents) ? Parity.Even : Parity.None;
        }

        
    }
}
