﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading;
using System.Windows.Forms;

namespace MiniStm32JoeC_CoreLibrary.Views_Ext {
    public partial class UC_StepperMotion : UserControl {
        MiniStm32BoardJoeC _board;
        public UC_StepperMotion() {
            InitializeComponent();
            cb_Mov_Home.SelectedIndex = 0;
        }
        public void Init(MiniStm32BoardJoeC miniStm32) {
            _board = miniStm32;
            chk_EN_Motor0.Checked = false;
            chk_EN_Motor1.Checked = false;
            chk_EN_Motor2.Checked = false;
        }
        bool _closing = false;
        public void Close() {
            _closing = true;
        }
        void WaitforBusy(int timeoutInSeconds) {
            DateTime dtTimeout = DateTime.Now.AddSeconds(timeoutInSeconds);
            while (_board.IsBusy) {
                if (DateTime.Now.Ticks > dtTimeout.Ticks) {
                    throw new Exception($"WaitforBusy timeout after '{timeoutInSeconds}'");
                }
                Application.DoEvents();
                Thread.Sleep(10);
            }
        }
        #region directMoves
        void btn_Mov_Left_Click(object sender, EventArgs e) {
            Motion_Move(sender as Button, 1, 1);
        }
        void btn_Mov_Right_Click(object sender, EventArgs e) {
            Motion_Move(sender as Button, 1, 0);
        }
        void btn_Mov_Up_Click(object sender, EventArgs e) {
            Motion_Move(sender as Button, 2, 1);
        }
        void btn_Mov_Dn_Click(object sender, EventArgs e) {
            Motion_Move(sender as Button, 2, 0);
        }
        void btn_Mov_Far_Click(object sender, EventArgs e) {
            Motion_Move(sender as Button, 3, 1);
        }
        void btn_Mov_Near_Click(object sender, EventArgs e) {
            Motion_Move(sender as Button, 3, 0);
        }
        void Motion_Move(Button btn, byte motor, int dir) {
            btn.BackColor = Color.LimeGreen; btn.Refresh();
            try {
                WaitforBusy(3);
                _board.IsBusy = false;
                _board.SetMotionMoveStepsAsync(motor, dir, (int)num_mov_steps.Value, (int)num_mov_speed.Value);
                WaitForMove();
            } catch (Exception ex) {
                MessageBox.Show(ex.Message);
            }
            _board.IsBusy = false;
            btn.BackColor = Color.Gainsboro; btn.Refresh();
        }
        void btn_Mov_Stop_Click(object sender, EventArgs e) {
            _board.SetMotionStop();
        }
        #endregion
        #region Settings_and_pos
        bool isMoving = false;
        void WaitForMove() {
            _board.IsBusy = true;
            for (int i = 0; i < 500; i++) {
                if (_board.Connection == ConnectionType.Serial_RS232_UART) {
                    Thread.Sleep(200);
                }
                ShowMotionPositons();
                if (isMoving == false) {
                    break;
                }
                Application.DoEvents();
            }
            _board.IsBusy = false;
        }

        void ShowMotionPositons() {
            MotionInfo mi = _board.GetMotionInfo();
            txt_Mov_State.Text = $"[{mi.MotionStateByte},{mi.MotionConfigByte}] {mi.MotionState}"; txt_Mov_State.Refresh();
            label_Mov_0.ForeColor = ((mi.MotionConfigByte & 0x2) == 0x2) ? Color.Green : Color.Orange;
            label_Mov_1.ForeColor = ((mi.MotionConfigByte & 0x4) == 0x4) ? Color.Green : Color.Orange;
            label_Mov_2.ForeColor = ((mi.MotionConfigByte & 0x8) == 0x8) ? Color.Green : Color.Orange;
            switch (mi.MotionState) {
                //case MotionInfo.MotionStateType.Undefined: break;
                //case MotionInfo.MotionStateType.IDLE: break;
                case MotionInfo.MotionStateType.MOVING_UP:
                case MotionInfo.MotionStateType.MOVING_DOWN:
                case MotionInfo.MotionStateType.HOMING_SEARCH:
                case MotionInfo.MotionStateType.HOMING_TO_POS:
                    isMoving = true;
                    break;
                //case MotionInfo.MotionStateType.HOMING_FAILED: break;
                //case MotionInfo.MotionStateType.unknown: break;
                default:
                    isMoving = false;
                    break;
            }
            txt_Mov_PosS.Text = mi.StepsToMove.ToString(); txt_Mov_PosS.Refresh();
            txt_Mov_Pos0.Text = mi.Position_LR.ToString(); txt_Mov_Pos0.Refresh();
            txt_Mov_Pos1.Text = mi.Position_UD.ToString(); txt_Mov_Pos1.Refresh();
            txt_Mov_Pos2.Text = mi.Position_Foc.ToString(); txt_Mov_Pos2.Refresh();

        }
        void chk_GetPos_Timer_CheckedChanged(object sender, EventArgs e) {
            timer_MovRead.Enabled = chk_GetPos_Timer.Checked;
        }
        void num_GetPosTimer_ValueChanged(object sender, EventArgs e) {
            timer_MovRead.Interval = (int)num_GetPosTimer.Value;
        }
        void timer_MovRead_Tick(object sender, EventArgs e) {
            try {
                if (_board.IsBusy) {
                    return;
                }
                ShowMotionPositons();
            } catch (Exception ex) {
                txt_Mov_Pos0.Text = "Ex:" + ex.Message;
            }
        }

        void chk_EN_Motor0_CheckedChanged(object sender, EventArgs e) {
            btn_Mov_Left.Enabled = chk_EN_Motor0.Checked;
            btn_Mov_Right.Enabled = chk_EN_Motor0.Checked;
            btn_Mov_Left.BackColor = (chk_EN_Motor0.Checked) ? Color.Gainsboro : Color.White;
            btn_Mov_Right.BackColor = (chk_EN_Motor0.Checked) ? Color.Gainsboro : Color.White;
            label_Mov_0.BackColor = (chk_EN_Motor0.Checked) ? Color.Gainsboro : Color.White;
        }
        void chk_EN_Motor1_CheckedChanged(object sender, EventArgs e) {
            btn_Mov_Up.Enabled = chk_EN_Motor1.Checked;
            btn_Mov_Dn.Enabled = chk_EN_Motor1.Checked;
            btn_Mov_Up.BackColor = (chk_EN_Motor1.Checked) ? Color.Gainsboro : Color.White;
            btn_Mov_Dn.BackColor = (chk_EN_Motor1.Checked) ? Color.Gainsboro : Color.White;
            label_Mov_1.BackColor = (chk_EN_Motor1.Checked) ? Color.Gainsboro : Color.White;
        }
        void chk_EN_Motor2_CheckedChanged(object sender, EventArgs e) {
            btn_Mov_Far.Enabled = chk_EN_Motor2.Checked;
            btn_Mov_Near.Enabled = chk_EN_Motor2.Checked;
            btn_Mov_Far.BackColor = (chk_EN_Motor2.Checked) ? Color.Gainsboro : Color.White;
            btn_Mov_Near.BackColor = (chk_EN_Motor2.Checked) ? Color.Gainsboro : Color.White;
            label_Mov_2.BackColor = (chk_EN_Motor2.Checked) ? Color.Gainsboro : Color.White;
        }
        #endregion
        #region Homing
        void btn_Mov_Home_Click(object sender, EventArgs e) {
            try {
                btn_Mov_Home.BackColor = Color.LimeGreen; btn_Mov_Home.Refresh();
                _board.SetMotionHomingAsync(cb_Mov_Home.SelectedIndex + 1, (int)num_home_steps.Value, (int)num_home_speed.Value);
                WaitForMove();
            } catch (Exception ex) {
                MessageBox.Show(ex.Message);
            }
            btn_Mov_Home.BackColor = Color.Gainsboro; btn_Mov_Home.Refresh();
        }
        void btn_Mov_HomeAll_Click(object sender, EventArgs e) {
            try {
                btn_Mov_HomeAll.BackColor = Color.LimeGreen; btn_Mov_HomeAll.Refresh();
                if (chk_EN_Motor0.Checked) {
                    _board.SetMotionHomingAsync(1, (int)num_home_steps.Value, (int)num_home_speed.Value);
                    WaitForMove();
                }
                if (chk_EN_Motor1.Checked) {
                    _board.SetMotionHomingAsync(2, (int)num_home_steps.Value, (int)num_home_speed.Value);
                    WaitForMove();
                }
                if (chk_EN_Motor2.Checked) {
                    _board.SetMotionHomingAsync(3, (int)num_home_steps.Value, (int)num_home_speed.Value);
                    WaitForMove();
                }
            } catch (Exception ex) {
                MessageBox.Show(ex.Message);
            }
            btn_Mov_HomeAll.BackColor = Color.Gainsboro; btn_Mov_HomeAll.Refresh();
        }
        #endregion



        void btn_Mov_GetPosClick(object sender, EventArgs e) {
            try {
                ShowMotionPositons();
            } catch (Exception ex) {
                txt_Mov_State.Text = "Ex:" + ex.Message;
            }
        }


        void btn_Mov_Get_Click(object sender, EventArgs e) {
            Button btn = sender as Button;
            try {
                btn.BackColor = Color.LimeGreen; btn.Refresh();
                char index = btn.Name[btn.Name.Length - 1];
                MotionInfo mi = _board.GetMotionInfo();
                string input = $"{mi.Position_LR},{mi.Position_UD},{mi.Position_Foc},";
                switch (index) {
                    case '1': txt_Mov_ToPos1.Text = input; break;
                    case '2': txt_Mov_ToPos2.Text = input; break;
                    case '3': txt_Mov_ToPos3.Text = input; break;
                    case '4': txt_Mov_ToPos4.Text = input; break;
                    default:
                        throw new Exception($"Index unknown: '{index}'");
                }
            } catch (Exception ex) {
                MessageBox.Show(ex.Message);
            }
            btn.BackColor = Color.Gainsboro; btn.Refresh();
        }
        void btn_Mov_ToPos_Click(object sender, EventArgs e) {
            Button btn = sender as Button;
            try {
                btn.BackColor = Color.LimeGreen; btn.Refresh();
                char index = btn.Name[btn.Name.Length - 1];
                string input = "";
                switch (index) {
                    case '1': input = txt_Mov_ToPos1.Text; break;
                    case '2': input = txt_Mov_ToPos2.Text; break;
                    case '3': input = txt_Mov_ToPos3.Text; break;
                    case '4': input = txt_Mov_ToPos4.Text; break;
                    default:
                        throw new Exception($"Index unknown: '{index}'");
                }
                string[] splits = input.Split(',');
                int pos1 = int.Parse(splits[0]);
                int pos2 = int.Parse(splits[1]);
                int pos3 = int.Parse(splits[2]);
                _board.SetMotionMoveToPosAsync(0, (int)num_mov_speed.Value, pos1, pos2, pos3);
                WaitForMove();
            } catch (Exception ex) {
                MessageBox.Show(ex.Message);
            }
            btn.BackColor = Color.Gainsboro; btn.Refresh();
        }

    }
}
