﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace MiniStm32JoeC_CoreLibrary.Views_Ext {
    public partial class UC_I2C_Slaves : UserControl {
        MiniStm32BoardJoeC _board;
        public UC_I2C_Slaves() {
            InitializeComponent();
            cb_INA219_ConfType.SelectedIndex = 0;
        }
        public void Init(MiniStm32BoardJoeC miniStm32) {
            _board = miniStm32;
        }
        bool _closing = false;
        public void Close() {
            _closing = true;
        }
        void WaitforBusy(int timeoutInSeconds) {
            DateTime dtTimeout = DateTime.Now.AddSeconds(timeoutInSeconds);
            while (_board.IsBusy) {
                if (DateTime.Now.Ticks > dtTimeout.Ticks) {
                    throw new Exception($"WaitforBusy timeout after '{timeoutInSeconds}'");
                }
                Application.DoEvents();
                System.Threading.Thread.Sleep(10);
            }
        }

        void btn_LM75_read_Click(object sender, EventArgs e) {
            try {
                byte add = (byte)num_add_LM75A.Value;
                byte[] rx = _board.I2CWriteReadDirect(add, 2, new byte[] { 0, 0 });
                label_I2CBytes.Text = $"{rx[3]},{rx[4]}";
                int rawTemp = 0; float TempMultiplier = 0;
                if (rad_useLM75.Checked) {
                    rawTemp = rx[3] << 1 | rx[4] >> 7; //LM75 0.5°C
                    TempMultiplier = 0.5f;
                }
                if (rad_useLM75A.Checked) {
                    rawTemp = rx[3] << 3 | rx[4] >> 5; //LM75A 0.125°C
                    TempMultiplier = 0.125f;
                }
                label_I2CRawTemp.Text = rawTemp.ToString();
                if ((rawTemp & 1024) == 1024) {
                    label_I2CCalcTemp.Text = (0 - (rawTemp * TempMultiplier)).ToString();
                } else {
                    label_I2CCalcTemp.Text = (rawTemp * TempMultiplier).ToString();
                }
            } catch (Exception ex) {
                MessageBox.Show(ex.Message, "Temperature Sensor (LM75A)");
            }
        }
        #region INA219_CurrentShuntSensor
        int ina219_calibrationValue = 10240;
        float ina219_currentDivider_mA = 25;
        float ina219_powerMultiplier_mW = 0.8f;
        void btn_INA219_readUI_Click(object sender, EventArgs e) {
            try {
                txt_INA219_log.Text = "";
                byte add = (byte)num_add_INA219.Value;
                byte[] rx = _board.I2CWriteReadDirect(add, 2, new byte[] { 2 }); //INA219_REG_BUSVOLTAGE
                int rxBusVolt = rx[3] << 8 | rx[4];
                rx = _board.I2CWriteReadDirect(add, 2, new byte[] { 3 }); //INA219_REG_POWER
                int rxPower = rx[3] << 8 | rx[4];
                rx = _board.I2CWriteReadDirect(add, 2, new byte[] { 4 }); //INA219_REG_CURRENT
                int rxCurrent = rx[3] << 8 | rx[4];

                txt_INA219_log.Text += $"Reg: {rxBusVolt},{rxPower},{rxCurrent}\r\n";

                float volt = (float)((rxBusVolt >> 3) * 0.004);
                float curr = (float)(rxCurrent / ina219_currentDivider_mA);
                float pow = (volt * (curr * 1000f));
                txt_INA219_log.Text += $"VOLT: {volt} V\r\n";
                txt_INA219_log.Text += $"CURR: {curr} mA\r\n";
                txt_INA219_log.Text += $"PWR Reg: {rxPower} mW\r\n";
                txt_INA219_log.Text += $"PWR (U*I): {(pow * 0.001)} mW\r\n";

            } catch (Exception ex) {
                MessageBox.Show(ex.Message, "Current Sensor (INA219)");
            }
        }
        void btn_INA219_read_Click(object sender, EventArgs e) {
            try {
                txt_INA219_log.Text = "";
                byte add = (byte)num_add_INA219.Value;
                byte[] rx = _board.I2CWriteReadDirect(add, 2, new byte[] { 0 }); //INA219_REG_CONFIG
                txt_INA219_log.Text += $"rx 0: {rx[3].ToString("X02")},{rx[4].ToString("X02")} ";
                rx = _board.I2CWriteReadDirect(add, 2, new byte[] { 1 }); //INA219_REG_SHUNTVOLTAGE
                txt_INA219_log.Text += $"rx 1: {rx[3].ToString("X02")},{rx[4].ToString("X02")}\r\n";//SHUNTVOLTAGE
                int rxShuntVolt = rx[3] << 8 | rx[4];
                rx = _board.I2CWriteReadDirect(add, 2, new byte[] { 2 }); //INA219_REG_BUSVOLTAGE
                txt_INA219_log.Text += $"rx 2: {rx[3].ToString("X02")},{rx[4].ToString("X02")} ";//BUSVOLTAGE
                int rxBusVolt = rx[3] << 8 | rx[4];
                rx = _board.I2CWriteReadDirect(add, 2, new byte[] { 3 }); //INA219_REG_POWER
                txt_INA219_log.Text += $"rx 3: {rx[3].ToString("X02")},{rx[4].ToString("X02")}\r\n";
                int rxPower = rx[3] << 8 | rx[4];
                rx = _board.I2CWriteReadDirect(add, 2, new byte[] { 4 }); //INA219_REG_CURRENT
                txt_INA219_log.Text += $"rx 4: {rx[3].ToString("X02")},{rx[4].ToString("X02")} ";
                int rxCurrent = rx[3] << 8 | rx[4];
                rx = _board.I2CWriteReadDirect(add, 2, new byte[] { 5 }); //INA219_REG_CALIBRATION
                txt_INA219_log.Text += $"rx 5: {rx[3].ToString("X02")},{rx[4].ToString("X02")}\r\n";

                txt_INA219_log.Text += $"ShuntVolt: {rxShuntVolt} ({(rxShuntVolt * 0.01f)} V)\r\n";
                txt_INA219_log.Text += $"BusVolt: {rxBusVolt} ({((rxBusVolt >> 3) * 4)})\r\n";
                txt_INA219_log.Text += $"CURRENT: {rxCurrent} ({(rxCurrent / ina219_currentDivider_mA)} mA)\r\n";
                txt_INA219_log.Text += $"Power: {rxPower}\r\n";

            } catch (Exception ex) {
                MessageBox.Show(ex.Message, "Current Sensor (INA219)");
            }
        }

        void btn_INA219_WriteCfg_Click(object sender, EventArgs e) {
            try {
                txt_INA219_log.Text = "Write Config";
                byte add = (byte)num_add_INA219.Value;
                int config = 0;
                switch (cb_INA219_ConfType.SelectedIndex) {
                    case 0:  //32V_2A
                        config = 0x2000 | 0x1800 | 0x0180 | 0x0018 | 0x07;//399F
                        ina219_calibrationValue = 4096; //1000
                        ina219_currentDivider_mA = 10; // Current LSB = 100uA per bit (1000/100 = 10)
                        ina219_powerMultiplier_mW = 2; // Power LSB = 1mW per bit (2/1)
                        break;
                    case 1:  //32V_1A
                        config = 0x2000 | 0x1800 | 0x0180 | 0x0018 | 0x07; //399F
                        ina219_calibrationValue = 10240;//2800
                        ina219_currentDivider_mA = 25;    // Current LSB = 40uA per bit (1000/40 = 25)
                        ina219_powerMultiplier_mW = 0.8f; // Power LSB = 800uW per bit
                        break;
                    case 2:  //16V_0.4A
                        config = 0x0180 | 0x0018 | 0x07; //019F
                        ina219_calibrationValue = 8192;
                        ina219_currentDivider_mA = 20;    // Current LSB = 50uA per bit (1000/50 = 20)
                        ina219_powerMultiplier_mW = 1.0f; // Power LSB = 1mW per bit
                        break;
                    default:
                        txt_INA219_log.Text += $"cb_INA219_ConfType.SelectedIndex: {cb_INA219_ConfType.SelectedIndex} was not defined\r\n";
                        return;
                }
                byte[] tx = new byte[3];
                tx[0] = 0; //reset
                tx[1] = 0x80;
                tx[2] = 0x00;
                _board.I2CWriteDirect(add, tx);
                System.Threading.Thread.Sleep(1);
                tx[0] = 0; //config
                tx[1] = (byte)((config >> 8) & 0xFF);
                tx[2] = (byte)(config & 0xFF);
                _board.I2CWriteDirect(add, tx);
                tx[0] = 5; //calib
                tx[1] = (byte)((ina219_calibrationValue >> 8) & 0xFF);
                tx[2] = (byte)(ina219_calibrationValue & 0xFF);
                _board.I2CWriteDirect(add, tx);
                byte[] rx = _board.I2CWriteReadDirect(add, 2, new byte[] { 0 });//config
                txt_INA219_log.Text += $"\r\nConfig: {rx[3].ToString("X02")},{rx[4].ToString("X02")}";
                rx = _board.I2CWriteReadDirect(add, 2, new byte[] { 5 });//calib
                txt_INA219_log.Text += $"\r\nCalib: {rx[3].ToString("X02")},{rx[4].ToString("X02")}";
            } catch (Exception ex) {
                MessageBox.Show(ex.Message, "Current Sensor (INA219)");
            }
        }

        #endregion
        #region MCP4725_1Ch_12Bit_DAC
        void track_MCP4725_input_Scroll(object sender, EventArgs e) {
            try {
                label_MCP4725_value.Text = track_MCP4725_input.Value.ToString();
                float volt = (float)track_MCP4725_input.Value / 4096.0f * (float)num_MCP4725_Reference.Value;
                label_MCP4725_Volt.Text = Math.Round(volt, 3).ToString() + "V";
            } catch (Exception ex) {
                MessageBox.Show(ex.Message, "1Ch DAC (MCP4725)");
            }
        }

        void btn_MCP4725_write_Click(object sender, EventArgs e) {
            try {
                byte add = (byte)num_add_MCP4725.Value;
                byte[] tx = new byte[2];
                tx[0] = (byte)((track_MCP4725_input.Value >> 8) & 0xF);
                tx[1] = (byte)(track_MCP4725_input.Value & 0xFF);
                _board.I2CWriteDirect(add, tx);
            } catch (Exception ex) {
                MessageBox.Show(ex.Message, "1Ch DAC (MCP4725)");
            }
        }
        #endregion
        #region BME280_Atmos-Sensor
        void btn_BME280_active_Click(object sender, EventArgs e) {
            try {
                byte add = (byte)num_add_BME280.Value;
                _board.I2CWriteDirect(add, new byte[6] { 0xF2, 0x05, 0xF4, 0xB7, 0xF5, 0x04 });
                //_board.I2CWrite(add, new byte[2] { 0xF2, 0x05 });
                //_board.I2CWrite(add, new byte[2] { 0xF4, 0xB7 });
            } catch (Exception ex) {
                MessageBox.Show(ex.Message, "Atmos-Sensor (BME280)");
            }
        }
        void btn_BME280_Sleep_Click(object sender, EventArgs e) {
            try {
                bme280_needCal = true;
                byte add = (byte)num_add_BME280.Value;
                //_board.I2CWrite(add, new byte[2] { 0xF4, 0x0 }); //low power: f4 0
                txt_BME280_log.Text = "Reset...\r\n";
                _board.I2CWriteDirect(add, new byte[2] { 0xE0, 0xB6 }); //reset write: e0 b6
                Read_BME280_Cal(add);
            } catch (Exception ex) {
                MessageBox.Show(ex.Message, "Atmos-Sensor (BME280)");
            }
        }

        bool bme280_needCal = true;
        struct bme280_calib_data {
            public ushort dig_t1;/*! Calibration coefficient for the temperature sensor */
            public short dig_t2;/*! Calibration coefficient for the temperature sensor */
            public short dig_t3;/*! Calibration coefficient for the temperature sensor */
            public ushort dig_p1;/*! Calibration coefficient for the pressure sensor */
            public short dig_p2;/*! Calibration coefficient for the pressure sensor */
            public short dig_p3;/*! Calibration coefficient for the pressure sensor */
            public short dig_p4;/*! Calibration coefficient for the pressure sensor */
            public short dig_p5;/*! Calibration coefficient for the pressure sensor */
            public short dig_p6;/*! Calibration coefficient for the pressure sensor */
            public short dig_p7;/*! Calibration coefficient for the pressure sensor */
            public short dig_p8;/*! Calibration coefficient for the pressure sensor */
            public short dig_p9;/*! Calibration coefficient for the pressure sensor */
            public byte dig_h1;/*! Calibration coefficient for the humidity sensor */
            public short dig_h2;/*! Calibration coefficient for the humidity sensor */
            public byte dig_h3;/*! Calibration coefficient for the humidity sensor */
            public short dig_h4;/*! Calibration coefficient for the humidity sensor */
            public short dig_h5;/*! Calibration coefficient for the humidity sensor */
            public sbyte dig_h6;/*! Calibration coefficient for the humidity sensor */
            public Int32 t_fine;/*! Variable to store the intermediate temperature coefficient */
        };
        bme280_calib_data BME280Cal;
        void Read_BME280_Cal(byte add) {
            txt_BME280_log.Text += $"Read Calibration...\r\n";
            byte[] rxCal00_25 = _board.I2CWriteReadDirect(add, 26, new byte[] { 0x88 });
            byte[] rxCal26_41 = _board.I2CWriteReadDirect(add, 16, new byte[] { 0xE1 });
            int i = 3;

            BME280Cal.dig_t1 = (ushort)((rxCal00_25[i + 1] << 8) | rxCal00_25[i]); i += 2; //0x88 / 0x89 
            BME280Cal.dig_t2 = (short)((rxCal00_25[i + 1] << 8) | rxCal00_25[i]); i += 2; //0x8A / 0x8B
            BME280Cal.dig_t3 = (short)((rxCal00_25[i + 1] << 8) | rxCal00_25[i]); i += 2; //0x8C / 0x8D
            BME280Cal.dig_p1 = (ushort)((rxCal00_25[i + 1] << 8) | rxCal00_25[i]); i += 2; //0x8E / 0x8F
            BME280Cal.dig_p2 = (short)((rxCal00_25[i + 1] << 8) | rxCal00_25[i]); i += 2; //10 0x90 / 0x91
            BME280Cal.dig_p3 = (short)((rxCal00_25[i + 1] << 8) | rxCal00_25[i]); i += 2; //0x92 / 0x93
            BME280Cal.dig_p4 = (short)((rxCal00_25[i + 1] << 8) | rxCal00_25[i]); i += 2; //0x94 / 0x95
            BME280Cal.dig_p5 = (short)((rxCal00_25[i + 1] << 8) | rxCal00_25[i]); i += 2; //0x96 / 0x97
            BME280Cal.dig_p6 = (short)((rxCal00_25[i + 1] << 8) | rxCal00_25[i]); i += 2; //0x98 / 0x99
            BME280Cal.dig_p7 = (short)((rxCal00_25[i + 1] << 8) | rxCal00_25[i]); i += 2; //20 0x9A / 0x9B
            BME280Cal.dig_p8 = (short)((rxCal00_25[i + 1] << 8) | rxCal00_25[i]); i += 2; //0x9C / 0x9D
            BME280Cal.dig_p9 = (short)((rxCal00_25[i + 1] << 8) | rxCal00_25[i]); i += 2; //0x9E / 0x9F
            i++;//0xA0
            BME280Cal.dig_h1 = rxCal00_25[i++];//25 0xA1
            i = 3;
            BME280Cal.dig_h2 = (short)((rxCal26_41[i + 1] << 8) | rxCal26_41[i]); i += 2; //0xE1 / 0xE2
            BME280Cal.dig_h3 = rxCal26_41[i++];//3 //0xE3
            BME280Cal.dig_h4 = (short)((rxCal26_41[i] << 4) | (rxCal26_41[i + 1] & 0xF)); i += 2; //0xE4 / 0xE5[3:0] 
            BME280Cal.dig_h5 = (short)(((rxCal26_41[i - 1] >> 4) & 0xF) | (rxCal26_41[i] << 4)); i += 1; //0xE5[7:4] / 0xE6 
            BME280Cal.dig_h6 = (sbyte)rxCal26_41[i++];//8 0xE7

            txt_BME280_log.Text += $"dig_t1-3: {BME280Cal.dig_t1},{BME280Cal.dig_t2},{BME280Cal.dig_t3}\r\n";
            txt_BME280_log.Text += $"dig_p1-3: {BME280Cal.dig_p1},{BME280Cal.dig_p2},{BME280Cal.dig_p3}\r\n";
            txt_BME280_log.Text += $"dig_p4-6: {BME280Cal.dig_p4},{BME280Cal.dig_p5},{BME280Cal.dig_p6}\r\n";
            txt_BME280_log.Text += $"dig_p7-9: {BME280Cal.dig_p7},{BME280Cal.dig_p8},{BME280Cal.dig_p9}\r\n";
            txt_BME280_log.Text += $"dig_h1: {BME280Cal.dig_h1}\r\n";
            txt_BME280_log.Text += $"dig_h2: {BME280Cal.dig_h2}\r\n";
            txt_BME280_log.Text += $"dig_h3: {BME280Cal.dig_h3}\r\n";
            txt_BME280_log.Text += $"dig_h4: {BME280Cal.dig_h4}\r\n";
            txt_BME280_log.Text += $"dig_h5: {BME280Cal.dig_h5}\r\n";
            txt_BME280_log.Text += $"dig_h6: {BME280Cal.dig_h6}\r\n";

            bme280_needCal = false;
        }
        void btn_BME280_GetCal_Click(object sender, EventArgs e) {
            try {
                txt_BME280_log.Text = "";
                byte add = (byte)num_add_BME280.Value;
                Read_BME280_Cal(add);
            } catch (Exception ex) {
                MessageBox.Show(ex.Message, "Atmos-Sensor (BME280)");
            }
        }
        void btn_BME280_Read_Click(object sender, EventArgs e) {
            try {
                txt_BME280_log.Text = "";
                byte add = (byte)num_add_BME280.Value;
                if (bme280_needCal) {
                    txt_BME280_log.Text += $"Read Calibration...\r\n";
                    //_board.I2CWrite(add, new byte[2] { 0xF4, 0x27 });
                    Read_BME280_Cal(add);
                }
                byte[] rx = _board.I2CWriteReadDirect(add, 8, new byte[] { 0xF7 });

                if (chk_BME280_ReadTrigger.Checked) {
                    _board.I2CWriteDirect(add, new byte[6] { 0xF2, 0x04, 0xF4, 0xFE, 0xF5, 0x04 });
                    //_board.I2CWrite(add, new byte[2] { 0xF2, 0x07 });
                    //_board.I2CWriteRead(add,1, new byte[1] { 0xF4 });
                    //_board.I2CWrite(add, new byte[2] { 0xF4, 0xFE });
                }
                txt_BME280_log.Text += $"rx: {rx[3].ToString("X02")},{rx[4].ToString("X02")},{rx[5].ToString("X02")} " +
                    $"{rx[6].ToString("X02")},{rx[7].ToString("X02")},{rx[8].ToString("X02")} " +
                    $"{rx[9].ToString("X02")},{rx[10].ToString("X02")}\r\n";
                Int32 rawPress = (rx[3] << 12) | (rx[4] << 4) | ((rx[5] >> 4) & 0xF);
                Int32 rawTemp = (rx[6] << 12) | (rx[7] << 4) | ((rx[8] >> 4) & 0xF);
                Int32 rawHum = (rx[9] << 8) | (rx[10]);
                txt_BME280_log.Text += $"rawPress: 0x{rawPress.ToString("X05")}\r\n";
                txt_BME280_log.Text += $"rawTemp: 0x{rawTemp.ToString("X05")}\r\n";
                txt_BME280_log.Text += $"rawHum: 0x{rawHum.ToString("X02")}\r\n";
                double temp = BME280_comp_Temp(rawTemp);
                txt_BME280_log.Text += $"CalcTemp: {Math.Round(temp, 3)} °C\r\n";
                double Press = BME280_comp_Press(rawPress);
                double Press2 = BME280_comp_Press2(rawPress) * 0.01;
                txt_BME280_log.Text += $"CalcPress: {Math.Round(Press, 2)} hPa\r\n";
                txt_BME280_log.Text += $"CalcPress2: {Math.Round(Press2, 2)} hPa\r\n";
                double Hum = BME280_comp_Hum(rawHum);
                txt_BME280_log.Text += $"CalcHum: {Math.Round(Hum, 2)} %\r\n";

            } catch (Exception ex) {
                MessageBox.Show(ex.Message, "Atmos-Sensor (BME280)");
            }
        }
        //Int32 t_fine;
        double BME280_comp_Temp(Int32 adc_T) {
            double var1, var2, T;
            double temperature_min = -40;
            double temperature_max = 85;
            var1 = (((double)adc_T) / 16384.0d - ((double)BME280Cal.dig_t1) / 1024.0d) *((double)BME280Cal.dig_t2);
            var2 = ((((double)adc_T) / 131072.0d - ((double)BME280Cal.dig_t1) / 8192.0d) *
                (((double)adc_T) / 131072.0d - ((double)BME280Cal.dig_t1) / 8192.0d)) *((double)BME280Cal.dig_t3);
            BME280Cal.t_fine = (Int32)(var1 + var2);
            T = (var1 + var2) / 5120.0d;
            //if (T < temperature_min) { T = temperature_min; } 
            //else if (T > temperature_max) { T = temperature_max; }
            return T;
        }
        double BME280_comp_Press(Int32 adc_P) {
            double var1;
            double var2;
            double var3;
            double pressure;
            double pressure_min = 30000.0;
            double pressure_max = 110000.0;

            var1 = ((double)BME280Cal.t_fine / 2.0) - 64000.0;
            var2 = var1 * var1 * ((double)BME280Cal.dig_p6) / 32768.0;
            var2 = var2 + var1 * ((double)BME280Cal.dig_p5) * 2.0;
            var2 = (var2 / 4.0) + (((double)BME280Cal.dig_p4) * 65536.0);
            var3 = ((double)BME280Cal.dig_p3) * var1 * var1 / 524288.0;
            var1 = (var3 + ((double)BME280Cal.dig_p2) * var1) / 524288.0;
            var1 = (1.0 + var1 / 32768.0) * ((double)BME280Cal.dig_p1);

            /* Avoid exception caused by division by zero */
            if (var1 > (0.0)) {
                pressure = 1048576.0 - (double)adc_P;
                pressure = (pressure - (var2 / 4096.0)) * 6250.0 / var1;
                var1 = ((double)BME280Cal.dig_p9) * pressure * pressure / 2147483648.0;
                var2 = pressure * ((double)BME280Cal.dig_p8) / 32768.0;
                pressure = pressure + (var1 + var2 + ((double)BME280Cal.dig_p7)) / 16.0;

                //if (pressure < pressure_min) {
                //    pressure = pressure_min;
                //} else if (pressure > pressure_max) {
                //    pressure = pressure_max;
                //}
            } else { /* Invalid case */
                pressure = pressure_min;
            }

            return pressure;
        }
        UInt32 BME280_comp_Press2(Int32 adc_P) {
            Int64 var1;
            Int64 var2;
            Int64 var3;
            Int64 var4;
            UInt32 pressure;
            UInt32 pressure_min = 3000000;
            UInt32 pressure_max = 11000000;

            var1 = ((Int64)BME280Cal.t_fine) - 128000;
            var2 = var1 * var1 * (Int64)BME280Cal.dig_p6;
            var2 = var2 + ((var1 * (Int64)BME280Cal.dig_p5) * 131072);
            var2 = var2 + (((Int64)BME280Cal.dig_p4) * 34359738368);
            var1 = ((var1 * var1 * (Int64)BME280Cal.dig_p3) / 256) + ((var1 * ((Int64)BME280Cal.dig_p2) * 4096));
            var3 = ((Int64)1) * 140737488355328;
            var1 = (var3 + var1) * ((Int64)BME280Cal.dig_p1) / 8589934592;

            /* Avoid exception caused by division by zero */
            if (var1 > (0.0)) {
                var4 = 1048576 - adc_P;
                var4 = (((var4 * (Int64)2147483648) - var2) * 3125) / var1;
                var1 = (((Int64)BME280Cal.dig_p9) * (var4 / 8192) * (var4 / 8192)) / 33554432;
                var2 = (((Int64)BME280Cal.dig_p8) * var4) / 524288;
                var4 = ((var4 + var1 + var2) / 256) + (((Int64)BME280Cal.dig_p7) * 16);
                pressure = (UInt32)(((var4 / 2) * 100) / 128);

                //if (pressure < pressure_min) {
                //    pressure = pressure_min;
                //} else if (pressure > pressure_max) {
                //    pressure = pressure_max;
                //}
            } else { /* Invalid case */
                pressure = pressure_min;
            }

            return pressure;
        }
        double BME280_comp_Hum(Int32 adc_H) {
            double humidity;
            double humidity_min = 0.0;
            double humidity_max = 100.0;
            double var1;
            double var2;
            double var3;
            double var4;
            double var5;
            double var6;

            var1 = ((double)BME280Cal.t_fine) - 76800.0;
            var2 = (((double)BME280Cal.dig_h4) * 64.0 + (((double)BME280Cal.dig_h5) / 16384.0) * var1);
            var3 = adc_H - var2;
            var4 = ((double)BME280Cal.dig_h2) / 65536.0;
            var5 = (1.0 + (((double)BME280Cal.dig_h3) / 67108864.0) * var1);
            var6 = 1.0 + (((double)BME280Cal.dig_h6) / 67108864.0) * var1 * var5;
            var6 = var3 * var4 * (var5 * var6);
            humidity = var6 * (1.0 - ((double)BME280Cal.dig_h1) * var6 / 524288.0);

            //if (humidity > humidity_max) {
            //    humidity = humidity_max;
            //} else if (humidity < humidity_min) {
            //    humidity = humidity_min;
            //}

            return humidity;
        }
        //reset write: e0 b6
        //read all data with write f7 and read 8 bytes
        //low power: f4 0
        //measure all x1: f4 27
        #endregion

        
    }
}
