﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Windows.Forms;

namespace MiniStm32JoeC_CoreLibrary.Views {
    public partial class UC_Script : UserControl {

        ScriptCommandInterpreter _script;// = new ScriptCommandInterpreter();
        string ScriptFolder = "";

        #region base
        public UC_Script() {
            InitializeComponent();
        }
        public void Init(MiniStm32BoardJoeC miniStm32) {
            //_board = miniStm32;
            _script = new ScriptCommandInterpreter(miniStm32);
            _script.Event_AddLog += AddLog;
            string path = Application.StartupPath + "\\scripts";
            SetScriptFolder(path);
        }
        public void SetScriptFolder(string path) {
            ScriptFolder = path;
            if (!Directory.Exists(ScriptFolder)) {
                Directory.CreateDirectory(ScriptFolder);
            }
            openFileDialog1.InitialDirectory = ScriptFolder;
            saveFileDialog1.InitialDirectory = ScriptFolder;
            saveFileDialogRtf.InitialDirectory = ScriptFolder;
        }
        bool _closing = false;
        public void Close() {
            _closing = true;
            timer_script.Enabled = false;
        }
        void AddLog(string info) 
        {
            AddLog(info, Color.Black);
        }
        void AddLog(string info, Color txtColor) {
            if (InvokeRequired) {
                this.Invoke(new Action<string, Color>(AddLog), new object[] { info, txtColor });
                return;
            }
            rtxt_log.SelectionStart = rtxt_log.TextLength;
            rtxt_log.SelectionLength = 0;
            rtxt_log.SelectionColor = txtColor;
            rtxt_log.AppendText($"{DateTime.Now.ToString("HH:mm:ss.fff")} | {info}\r\n");
            rtxt_log.SelectionColor = rtxt_log.ForeColor;
            rtxt_log.ScrollToCaret();
            rtxt_log.Refresh();
        }
        void ScriptFileToItems() {
            listBox_ScriptItems.Items.Clear();
            string[] lines = txtScriptContent.Text.Split('\n');
            foreach (string L in lines) {
                string line = L;
                if (L.Contains('#')) {
                    int pos = L.IndexOf('#');
                    line = L.Remove(pos,L.Length-pos);
                }
                if (line.Length < 3) { // not enough data
                    continue;
                }
                listBox_ScriptItems.Items.Add(line.TrimEnd());
            }
        }
        string GetCurrentCmd() {
            try {
                listBox_ScriptItems.SelectedIndex = ScriptCurrentIndex;
                return listBox_ScriptItems.Items[ScriptCurrentIndex].ToString();
            }
            catch (Exception ex) {
                AddLog($"GetCurrentCmd() Ex: {ex.Message}", Color.Fuchsia);
                ScriptEnd();
            }
            return "";
        }
        public void ScriptBegin() {
            if (_script == null) {
                MessageBox.Show("missing call to:\r\nvoid Init(MiniStm32BoardJoeC miniStm32)");
                return;
            }
            if (listBox_ScriptItems.Items.Count == 0) {
                AddLog("Script Items are empty.", Color.Fuchsia);
                return;
            }
            isScriptBusy = false;
            ScriptLastIndex = listBox_ScriptItems.Items.Count-1;
            AddLog("Begin Script", Color.DimGray);
            ScriptCurrentIndex = listBox_ScriptItems.SelectedIndex;
            if (ScriptCurrentIndex == -1) {
                //no selection, start from top
                ScriptCurrentIndex = 0;
            }
            if (ScriptCurrentIndex == (listBox_ScriptItems.Items.Count - 1)) {
                //last selected, start from top
                ScriptCurrentIndex = 0;
            }
            tabControl_ScriptFile.SelectedIndex = 1;
            btnScriptRun.BackColor = Color.LimeGreen;
            TotalScriptTics = DateTime.Now.Ticks;
            timer_script.Start();
        }
        public void ScriptEnd() {
            ScriptEnd(false);
        }
        public void ScriptEnd(bool success) {
            timer_script.Stop();
            if (timer_script.Enabled) {
                TimeSpan timeSpan = new TimeSpan(DateTime.Now.Ticks - TotalScriptTics);
                AddLog($"Script done, TotalSeconds {timeSpan.TotalSeconds}", Color.DimGray);
            }
            if (success) {
                AddLog("End Script success", Color.Green);
            } else {
                AddLog("End Script", Color.DimGray);
            }
            
            btnScriptRun.BackColor = Color.Gainsboro;
            isScriptBusy = false;
        }
        #endregion

        #region Controls
        void btnScriptRun_Click(object sender, EventArgs e) {
            if (listBox_ScriptItems.Items.Count == 0 || tabControl_ScriptFile.SelectedIndex == 0) {
                ScriptFileToItems();
            }
            ScriptBegin();
        }
        void btnScriptStop_Click(object sender, EventArgs e) {
            ScriptEnd();
        }
        

        void btnSaveScript_Click(object sender, EventArgs e) {
            if (saveFileDialog1.ShowDialog() != DialogResult.OK) {
                return;
            }
            string filename = saveFileDialog1.FileName;
            if (!filename.EndsWith(".txt")) {
                filename += ".txt";
            }
            StreamWriter txt = new StreamWriter(filename);
            txt.Write(txtScriptContent.Text);
            txt.Close();
            MessageBox.Show("Saved: " + filename, "Saved...");
        }
        void btnLoadScript_Click(object sender, EventArgs e) {
            if (DialogResult.OK != openFileDialog1.ShowDialog()) { 
                return; 
            }
            try {
                txtScriptFilename.Text = Path.GetFileName(openFileDialog1.FileName);
                StreamReader txt = new StreamReader(openFileDialog1.FileName);
                txtScriptContent.Text = txt.ReadToEnd();
                txt.Close();
                ScriptFileToItems();
            }
            catch (Exception ex) {
                AddLog($"Exception: {ex.Message}", Color.Fuchsia);
            }
        }

        void btnScriptFileToItems_Click(object sender, EventArgs e) {
            ScriptFileToItems();
            tabControl_ScriptFile.SelectedIndex = 1;
        }
        void btnShowHelp_Click(object sender, EventArgs e) {
            AddLog("Usable Commands:\r\n" + _script.ShowHelp(), Color.Blue);
        }

        void btnLogClear_Click(object sender, EventArgs e) {
            rtxt_log.Text = "";
        }

        void btnSaveLog_Click(object sender, EventArgs e) {
            if (saveFileDialogRtf.ShowDialog() != DialogResult.OK) {
                return;
            }
            string filename = saveFileDialogRtf.FileName;
            if (!filename.EndsWith(".rtf")) {
                filename += ".rtf";
            }
            rtxt_log.SaveFile(filename);
            MessageBox.Show("Saved: " + filename, "Saved...");
        }
        #endregion

        long TotalScriptTics = 0;
        string ScriptCurrentCmd = "";
        int ScriptCurrentIndex = 0;
        int ScriptLastIndex = 0;
        bool isScriptBusy = false;
        void timer_script_Tick(object sender, EventArgs e) {
            if (isScriptBusy) {
                return;
            }
            if (ScriptCurrentIndex == listBox_ScriptItems.Items.Count) {
                ScriptEnd(true);
                return;
            }
            ScriptCurrentCmd = GetCurrentCmd();
            if (ScriptCurrentCmd == "") {
                return;
            }
            txtScriptStatus.Text = $"{DateTime.Now.ToString("HH:mm:ss.fff")} | {ScriptCurrentIndex} {ScriptCurrentCmd}";
            txtScriptStatus.Refresh();
            btnScriptRun.BackColor = Color.LimeGreen;
            btnScriptRun.Refresh();
            RunScript();
        }

        void RunScript() {
            try {
                if (ScriptCurrentCmd == "") {
                    throw new Exception("ScriptCurrentCmd is empty.");
                }
                isScriptBusy = true;

                AddLog(ScriptCurrentCmd);
                if (ScriptCurrentCmd.StartsWith("MSGBOX:")) {
                    GuiCmd_MSGBOX(ScriptCurrentCmd);
                } else if (ScriptCurrentCmd.StartsWith("SLEEP:")) {
                    btnScriptRun.BackColor = Color.Gold;
                    btnScriptRun.Refresh();
                    Thread t = new Thread(() => GuiCmd_SLEEP(ScriptCurrentCmd));
                    t.Start();
                    return;
                } else {
                    if (!ScriptCurrentCmd.EndsWith(",")) {
                        ScriptCurrentCmd += ",";
                    }
                    _script.Execute(ScriptCurrentCmd);
                }
                
                ScriptCurrentIndex++;
                isScriptBusy = false;
            }
            catch (Exception ex) {
                AddLog($"RunScript() Ex: {ex.Message}", Color.Fuchsia);
                ScriptEnd();
            }
        }
        void GuiCmd_MSGBOX(string parameter) {
            DialogResult result = MessageBox.Show(parameter.Remove(0,"MSGBOX:".Length) + "\r\nContinue with Script?", "Script popup message", MessageBoxButtons.YesNo);
            if (result != DialogResult.Yes) {
                AddLog("MSGBOX->not continue.", Color.Salmon);
                ScriptEnd();
                return;
            }
            AddLog("MSGBOX->continue.", Color.Green);
        }
        void GuiCmd_SLEEP(string parameter) {
            int value = 1;
            if (!int.TryParse(parameter.Remove(0, "SLEEP:".Length), out value)) {
                AddLog($"cannot parse '{parameter}' to an int.");
            }
            Thread.Sleep(value);
            ScriptCurrentIndex++;
            isScriptBusy = false;
        }

        void ScriptCmd_SENDUART(int uart, string parameter, bool isExecute) {
            if (!isExecute) { return; }
            //TODO ScriptCmd_SENDUART
            //int value = 0;
            //AddScriptLog($"SendUart(port={uart}):{parameter}");
            //if (uart != 1 && uart != 3) {
            //    throw new Exception("Uart ports have to be 1 or 3.");
            //}
            //switch (uart) {
            //    case 1: SendUartHid(1, parameter); break;
            //    case 3: SendUartHid(3, parameter); break;
            //    default:
            //        throw new Exception("Uart ports have to be 1 or 3.");
            //}
        }

    }
}
