﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace MiniStm32JoeC_CoreLibrary.Views {
    public partial class UC_I2C : UserControl {
        MiniStm32BoardJoeC _board;
        public UC_I2C() {
            InitializeComponent();
            txt_i2c_LOAD.Text = "360";
            PrintAddress();
            cb_loop_send1.SelectedIndex = 1;
            cb_loop_send2.SelectedIndex = 0;
            cb_loop_send3.SelectedIndex = 1;
            cb_loop_send4.SelectedIndex = 0;
            cb_loop_send5.SelectedIndex = 2;
        }
        public void Init(MiniStm32BoardJoeC miniStm32) {
            _board = miniStm32;
        }
        bool _closing = false;
        public void Close() {
            _closing = true;
        }
        void WaitforBusy(int timeoutInSeconds) {
            DateTime dtTimeout = DateTime.Now.AddSeconds(timeoutInSeconds);
            while (_board.IsBusy) {
                if (DateTime.Now.Ticks > dtTimeout.Ticks) {
                    throw new Exception($"WaitforBusy timeout after '{timeoutInSeconds}'");
                }
                Application.DoEvents();
                System.Threading.Thread.Sleep(10);
            }
        }

        #region Address
        int Address = 144;
        void chk_add_IncludeRwBit_CheckedChanged(object sender, EventArgs e) {
            lb_Cs_1.Text = (chk_add_IncludeRwBit.Checked) ? "1" : "0";
            lb_Cs_2.Text = (chk_add_IncludeRwBit.Checked) ? "2" : "1";
            lb_Cs_3.Text = (chk_add_IncludeRwBit.Checked) ? "3" : "2";
            lb_Cs_4.Text = (chk_add_IncludeRwBit.Checked) ? "4" : "3";
            lb_Cs_5.Text = (chk_add_IncludeRwBit.Checked) ? "5" : "4";
            lb_Cs_6.Text = (chk_add_IncludeRwBit.Checked) ? "6" : "5";
            lb_Cs_7.Text = (chk_add_IncludeRwBit.Checked) ? "7" : "6";
            PrintAddress();
        }

        void PrintAddress() {
            int add = Address;
            if (!chk_add_IncludeRwBit.Checked) {
                add = add >> 1;
            }
            txt_i2c_AddressD.Text = add.ToString();
            txt_i2c_AddressH.Text = "0x" + add.ToString("X02");

            lb_Cs_0.BackColor = ((Address & 1) == 1) ? Color.Gold : Color.Gainsboro;
            lb_Cs_1.BackColor = ((Address >> 1 & 1) == 1) ? Color.LimeGreen : Color.Gainsboro;
            lb_Cs_2.BackColor = ((Address >> 2 & 1) == 1) ? Color.LimeGreen : Color.Gainsboro;
            lb_Cs_3.BackColor = ((Address >> 3 & 1) == 1) ? Color.LimeGreen : Color.Gainsboro;
            lb_Cs_4.BackColor = ((Address >> 4 & 1) == 1) ? Color.LimeGreen : Color.Gainsboro;
            lb_Cs_5.BackColor = ((Address >> 5 & 1) == 1) ? Color.LimeGreen : Color.Gainsboro;
            lb_Cs_6.BackColor = ((Address >> 6 & 1) == 1) ? Color.LimeGreen : Color.Gainsboro;
            lb_Cs_7.BackColor = ((Address >> 7 & 1) == 1) ? Color.LimeGreen : Color.Gainsboro;
        }
        void lb_Cs_xAll_MouseDown(object sender, MouseEventArgs e) {
            Address = 0;
            //toggle state
            Label lbl = (sender as Label);
            if (lbl.BackColor == Color.Gainsboro) {
                string lblNumber = lbl.Name[lbl.Name.Length - 1].ToString();
                int currentNumber = int.Parse(lblNumber);
                if (currentNumber > 0) {
                    lbl.BackColor = Color.LimeGreen;
                } else {
                    lbl.BackColor = Color.Gold;
                }
            } else {
                lbl.BackColor = Color.Gainsboro;
            }
            lbl.Refresh();

            //read
            if (lb_Cs_0.BackColor != Color.Gainsboro) { Address += 1; }
            if (lb_Cs_1.BackColor != Color.Gainsboro) { Address += 2; }
            if (lb_Cs_2.BackColor != Color.Gainsboro) { Address += 4; }
            if (lb_Cs_3.BackColor != Color.Gainsboro) { Address += 8; }
            if (lb_Cs_4.BackColor != Color.Gainsboro) { Address += 16; }
            if (lb_Cs_5.BackColor != Color.Gainsboro) { Address += 32; }
            if (lb_Cs_6.BackColor != Color.Gainsboro) { Address += 64; }
            if (lb_Cs_7.BackColor != Color.Gainsboro) { Address += 128; }

            PrintAddress();
        }

        void txt_i2c_AddressD_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound
            try {
                int newAdd = int.Parse(txt_i2c_AddressD.Text);
                if (!chk_add_IncludeRwBit.Checked) {
                    newAdd = newAdd << 1;
                }
                Address = newAdd;
                PrintAddress();
            } catch (Exception ex) {
                MessageBox.Show(ex.Message,"Set I2C Address Failed");
            }
        }

        void txt_i2c_AddressH_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound
            try {
                int newAdd = int.Parse(txt_i2c_AddressH.Text.Replace("0x",""),System.Globalization.NumberStyles.HexNumber);
                if (!chk_add_IncludeRwBit.Checked) {
                    newAdd = newAdd << 1;
                }
                Address = newAdd;
                PrintAddress();
            } catch (Exception ex) {
                MessageBox.Show(ex.Message, "Set I2C Address Failed");
            }
        }
        #endregion
        #region ManualSetup
        void rad_man_Dec_CheckedChanged(object sender, EventArgs e) {
            if (isHexMode) {
                ManualSwitchHexDec();
            }
        }
        void rad_man_hex_CheckedChanged(object sender, EventArgs e) {
            if (!isHexMode) {
                ManualSwitchHexDec();
            }
        }
        bool isHexMode = true;
        void ManualSwitchHexDec() {
            try {
                if (isHexMode) {
                    //convert to Dec
                    sub_ManualSwitchHexDec(txt_i2c_SendArray);
                    sub_ManualSwitchHexDec(txt_i2c_SendArray2);
                    sub_ManualSwitchHexDec(txt_i2c_WriteRead);
                    isHexMode = false;
                    return;
                }
                //convert to hex
                sub_ManualSwitchHexDec(txt_i2c_SendArray);
                sub_ManualSwitchHexDec(txt_i2c_SendArray2);
                sub_ManualSwitchHexDec(txt_i2c_WriteRead);
                isHexMode = true;
            } catch (Exception ex) {
                txt_i2c_log.Text += "\r\n" + ex.Message;
            }
        }
        void sub_ManualSwitchHexDec(TextBox txt) { 
            string[] splits = txt.Text.TrimEnd().Split(' ');
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < splits.Length; i++) {
                if (isHexMode) {
                    byte B = byte.Parse(splits[i], System.Globalization.NumberStyles.HexNumber);
                    sb.Append(B + " ");
                } else {
                    byte B = byte.Parse(splits[i]);
                    sb.Append(B.ToString("X02") + " ");
                }
            }
            txt.Text = sb.ToString().Trim();
        }
        void ExecuteI2C_Write(string input) { 
            try {
                WaitforBusy(3);
                _board.IsBusy = true;

                //Build and perform Transmission
                string[] splits = input.TrimEnd().Split(' ');
                byte[] tx = new byte[splits.Length];

                StringBuilder sbDataIn = new StringBuilder();
                sbDataIn.Append($"Write [{Address}]: ");
                for (int i = 0; i < tx.Length; i++) {
                    if (isHexMode) {
                        if (!byte.TryParse(splits[i], System.Globalization.NumberStyles.HexNumber, null, out tx[i])) {
                            throw new Exception($"Can't parse '{splits[i]}' to a byte");
                        }
                        sbDataIn.Append($"{tx[i].ToString("X02")} ");
                    } else {
                        if (!byte.TryParse(splits[i], out tx[i])) {
                            throw new Exception($"Can't parse '{splits[i]}' to a byte");
                        }
                        sbDataIn.Append($"{tx[i].ToString()} ");
                    }
                }

                txt_i2c_log.AppendText($"{sbDataIn.ToString()} -> ");
                byte[] rx = _board.I2CWriteDirect(Address, tx);
                if (rx == null) { txt_i2c_log.AppendText("<NULL>\r\n"); return; }

                sbDataIn = new StringBuilder();
                sbDataIn.Append($"{_board.GetI2CResponseCode(rx[0])} : ");

                for (int i = 0; i < rx.Length; i++) {
                    if (isHexMode) {
                        if (rx[0] == i) {
                            sbDataIn.Append($"[{rx[i].ToString("X02")}] ");
                        } else {
                            sbDataIn.Append($"{rx[i].ToString("X02")} ");
                        }
                    } else {
                        if (rx[0] == i) {
                            sbDataIn.Append($"[{rx[i]}] ");
                        } else {
                            sbDataIn.Append($"{rx[i]} ");
                        }
                    }
                    if (i == 2) {
                        sbDataIn.Append(" | W: ");
                    }
                    if (i==0) {
                        rx[0] = (byte)(rx[1] + 3);
                    }
                }
                
                if (rx[1] != splits.Length) {
                    sbDataIn.Append($" (Not written: {(splits.Length - rx[1])} bytes)");
                }
                txt_i2c_log.AppendText($"{sbDataIn}\r\n");
            } catch (Exception ex) {
                _board.IsBusy = false;
                if (_closing) { return; }
                txt_i2c_log.AppendText($"Error: {ex.Message}\r\n");
            }
            _board.IsBusy = false;
        }
        void txt_i2c_SendArray_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound
            ExecuteI2C_Write(txt_i2c_SendArray.Text);
        }
        void txt_i2c_SendArray2_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound
            ExecuteI2C_Write(txt_i2c_SendArray2.Text);
        }
        void ExecuteI2C_Read(int count) {
            try {
                WaitforBusy(3);
                _board.IsBusy = true;

                //prepare
                StringBuilder sbDataIn = new StringBuilder();
                sbDataIn.Append($"Read [{Address}]: ");
                txt_i2c_log.AppendText($"{sbDataIn.ToString()} -> ");

                //perform Transmission
                byte[] rx = _board.I2CReadDirect(Address, count);
                if (rx == null) { txt_i2c_log.AppendText("<NULL>\r\n"); return; }

                sbDataIn = new StringBuilder();
                sbDataIn.Append($"{_board.GetI2CResponseCode(rx[0])} : ");
                for (int i = 0; i < rx.Length; i++) {
                    if (isHexMode) {
                        if (rx[0] == i) {
                            sbDataIn.Append($"[{rx[i].ToString("X02")}] ");
                        } else {
                            sbDataIn.Append($"{rx[i].ToString("X02")} ");
                        }
                    } else {
                        if (rx[0] == i) {
                            sbDataIn.Append($"[{rx[i]}] ");
                        } else {
                            sbDataIn.Append($"{rx[i]} ");
                        }
                    }
                    if (i == 2) {
                        sbDataIn.Append(" | R: ");
                    }
                    if (i == 0) {
                        rx[0] = (byte)(rx[2] + 3);
                    }
                }
                txt_i2c_log.AppendText($"{sbDataIn}\r\n");
            } catch (Exception ex) {
                _board.IsBusy = false;
                if (_closing) { return; }
                txt_i2c_log.AppendText($"Error: {ex.Message}\r\n");
            }
            _board.IsBusy = false;
        }
        void btn_i2c_ReadBytes_Click(object sender, EventArgs e) {
            ExecuteI2C_Read((int)num_i2c_NrOfBytes.Value);
        }
        void btn_i2c_Debug_Click(object sender, EventArgs e) {
            try {
                WaitforBusy(3);
                _board.IsBusy = true;

                StringBuilder sbDataIn = new StringBuilder();
                sbDataIn.Append($"Debug: ");
                byte[] rx = _board.I2CDebug();
                if (rx == null) { txt_i2c_log.AppendText("<NULL>\r\n"); return; }
                sbDataIn.Append($"{_board.GetI2CResponseCode(rx[0])} _ ");

                for (int i = 0; i < rx.Length; i++) {
                    sbDataIn.Append($"{rx[i]} ");
                }
                txt_i2c_log.AppendText($"{sbDataIn}\r\n");
            } catch (Exception ex) {
                _board.IsBusy = false;
                if (_closing) { return; }
                txt_i2c_log.AppendText($"Error: {ex.Message}\r\n");
            }
            _board.IsBusy = false;
        }
        void btn_i2c_BusUnlock_Click(object sender, EventArgs e) {

            try {
                WaitforBusy(3);
                _board.IsBusy = true;

                StringBuilder sbDataIn = new StringBuilder();
                sbDataIn.Append($"Bus Unlock: ");
                byte[] rx = _board.I2CScanSlavesDirect(2,5);
                if (rx == null) { txt_i2c_log.AppendText("<NULL>\r\n"); return; }
                sbDataIn.Append($"{_board.GetI2CResponseCode(rx[0])} | CLK neeed: {rx[3]}");
                txt_i2c_log.AppendText($"{sbDataIn}\r\n");
            } catch (Exception ex) {
                _board.IsBusy = false;
                if (_closing) { return; }
                txt_i2c_log.AppendText($"Error: {ex.Message}\r\n");
            }
            _board.IsBusy = false;
        }
        void SetupI2CSpeed(string speedValue) { 
            try {
                WaitforBusy(3);
                _board.IsBusy = true;
                PinInfo pinCLK = new PinInfo(txt_i2c_SCL.Text);
                PinInfo pinDATA = new PinInfo(txt_i2c_DATA.Text);
                ushort speed = ushort.Parse(speedValue);

                _board.I2CWriteSetup(pinCLK, pinDATA, speed);
                if (speed > 0) {
                    txt_i2c_log.AppendText($"I2CWriteSetup: SCL({pinCLK.PinCfg}) DATA({pinDATA.PinCfg}) speed({speed})\r\n");
                } else {
                    txt_i2c_log.AppendText($"I2CWriteSetup: SCL({pinCLK.PinCfg}) DATA({pinDATA.PinCfg}) speed({speed})\r\n");
                }
            } catch (Exception ex) {
                _board.IsBusy = false;
                if (_closing) { return; }
                txt_i2c_log.AppendText($"Error: {ex.Message}\r\n");
            }
            _board.IsBusy = false;
        }
        void btn_i2c_WriteSetup_Click(object sender, EventArgs e) {
            SetupI2CSpeed(txt_i2c_LOAD.Text);
        }

        void txt_i2c_LOAD_TextChanged(object sender, EventArgs e) {
            try {
                double val = double.Parse(txt_i2c_LOAD.Text);
                double freq = 72000.0 / val;
                double us = 1.0 / freq * 1000.0;
                txt_I2C_ConfSpeed.ForeColor = (freq > 400.0) ? Color.Red : Color.Black;
                txt_I2C_ConfSpeed.Text = $"{Math.Round((freq/2))} kHz (tick: {Math.Round(us,1)} µs)";
            } catch (Exception ex) {
                txt_I2C_ConfSpeed.Text = ex.Message;
            }
        }

        void btn_I2C_off_Click(object sender, EventArgs e) {
            SetupI2CSpeed("0");
        }
        void btn_i2c_ScanSlaves_Click(object sender, EventArgs e) {
            try {
                WaitforBusy(3);
                _board.IsBusy = true;

                //Build and perform Transmission
                StringBuilder sbDataIn = new StringBuilder();
                sbDataIn.Append($"Scan Slaves: ");
                int mode = 0;
                if (chk_i2c_ScanReadMode.Checked) {
                    mode = 1;
                }

                byte[] rx = _board.I2CScanSlavesDirect((int)num_ScanSlaves_slots.Value, mode);
                if (rx == null) { txt_i2c_log.AppendText("<NULL>\r\n"); return; }
                sbDataIn.Append($"{_board.GetI2CResponseCode(rx[0])} : ");
                int end = rx[1] + 3; //3 = state,CntW,CntR
                if (end > rx.Length) {
                    end = rx.Length;
                }
                for (int i = 3; i < end; i++) {
                    if (isHexMode) {
                        sbDataIn.Append($"{rx[i].ToString("X02")} ");
                    } else {
                        sbDataIn.Append($"{rx[i]} ");
                    }
                }
                txt_i2c_log.AppendText($"{sbDataIn}\r\n");
            } catch (Exception ex) {
                _board.IsBusy = false;
                if (_closing) { return; }
                txt_i2c_log.AppendText($"Error: {ex.Message}\r\n");
            }
            _board.IsBusy = false;
        }

        void txt_i2c_WriteRead_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound
            try {
                WaitforBusy(3);
                _board.IsBusy = true;

                //Build and perform Transmission
                string[] splits = txt_i2c_WriteRead.Text.TrimEnd().Split(' ');
                byte[] tx = new byte[splits.Length];

                StringBuilder sbDataIn = new StringBuilder();
                sbDataIn.Append($"WriteRead [{Address}]: ");
                for (int i = 0; i < tx.Length; i++) {
                    if (isHexMode) {
                        if (!byte.TryParse(splits[i], System.Globalization.NumberStyles.HexNumber, null, out tx[i])) {
                            throw new Exception($"Can't parse '{splits[i]}' to a byte");
                        }
                        sbDataIn.Append($"{tx[i].ToString("X02")} ");
                    } else {
                        if (!byte.TryParse(splits[i], out tx[i])) {
                            throw new Exception($"Can't parse '{splits[i]}' to a byte");
                        }
                        sbDataIn.Append($"{tx[i].ToString()} ");
                    }
                }

                txt_i2c_log.AppendText($"{sbDataIn.ToString()} -> ");
                byte[] rx = _board.I2CWriteReadDirect(Address, (int)num_WriteRead.Value, tx);
                if (rx == null) { txt_i2c_log.AppendText("<NULL>\r\n"); return; }

                sbDataIn = new StringBuilder();
                sbDataIn.Append($"{_board.GetI2CResponseCode(rx[0])} : ");
                for (int i = 0; i < rx.Length; i++) {
                    if (isHexMode) {
                        sbDataIn.Append($"{rx[i].ToString("X02")} ");
                    } else {
                        sbDataIn.Append($"{rx[i]} ");
                    }

                    if (i == 2) {
                        sbDataIn.Append(" | R: ");
                    }
                }
                txt_i2c_log.AppendText($"{sbDataIn}\r\n");
            } catch (Exception ex) {
                _board.IsBusy = false;
                if (_closing) { return; }
                txt_i2c_log.AppendText($"Error: {ex.Message}\r\n");
            }
            _board.IsBusy = false;
        }

        void btn_log_clear_Click(object sender, EventArgs e) {
            txt_i2c_log.Text = "";
        }
        #endregion
        #region Tables

        //Tab Table8
        void btn_table_ReadBytes_Click(object sender, EventArgs e) {
            try {
                WaitforBusy(3);
                _board.IsBusy = true;
                
                int nrOfBytes = (int)num_table_NrOfBytes.Value;
                int BaseRowID = CommonPrepareTable(DGVSpiTable, Address, true);
                DGVSpiTable.Rows[BaseRowID].Cells[2].Value = $"R({nrOfBytes})";
                //Build and perform Transmission
                

                byte[] rx = _board.I2CReadDirect(Address, nrOfBytes);
                if (rx == null) {
                    DGVSpiTable.Rows[BaseRowID].Cells[3].Value = "-";
                    return;
                }

                StringBuilder sbDataIn = new StringBuilder();
                StringBuilder sbDataInAll = new StringBuilder();
                int end = rx[2] + 3; //MaState,CntW,CntR
                if (end > rx.Length) {
                    end = rx.Length;
                }
                for (int i = 3; i < end; i++) {
                    sbDataIn.Append($"{rx[i].ToString("X02")} ");
                }
                for (int i = 0; i < rx.Length; i++) {
                    if (rx[0] == i) {
                        sbDataInAll.Append($"[{rx[i].ToString("X02")}] ");
                    } else {
                        sbDataInAll.Append($"{rx[i].ToString("X02")} ");
                    }
                }

                DGVSpiTable.Rows[BaseRowID].Cells[3].Value = sbDataIn.ToString();
                DGVSpiTable.Rows[BaseRowID].Cells[4].Value = _board.GetI2CResponseCode(rx[0]);
                DGVSpiTable.Rows[BaseRowID].Cells[5].Value = rx[2];
                DGVSpiTable.Rows[BaseRowID].Cells[6].Value = sbDataInAll.ToString();
                switch (rx[0]) {
                    case 155: //DONE
                        DGVSpiTable.Rows[BaseRowID].Cells[4].Style.BackColor = Color.PaleGreen;
                        break;
                    case 201: //$"SLAVE_NAC({code})";
                    case 202: //$"TIMEOUT({code})";
                    case 203: //$"SLAVE_W_NAC({code})";
                        DGVSpiTable.Rows[BaseRowID].Cells[4].Style.BackColor = Color.Salmon;
                        break;
                    default:
                        DGVSpiTable.Rows[BaseRowID].Cells[4].Style.BackColor = Color.Red;
                        break;
                }
                DGVSpiTable.FirstDisplayedScrollingRowIndex = BaseRowID;
                _board.IsBusy = false;
            } catch (Exception ex) {
                _board.IsBusy = false;
                if (_closing) { return; }
                MessageBox.Show(ex.Message, "Exeption Execute_TableWrite");
            }
        }
        void txt_table_SendArray_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound
            Execute_TableWrite(txt_table_SendArray.Text);
        }
        void txt_table_SendArray2_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound
            Execute_TableWrite(txt_table_SendArray2.Text);
        }
        void txt_table_SendArray3_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound
            Execute_TableWrite(txt_table_SendArray3.Text);
        }
        void Execute_TableWrite(string TX) {
            try {
                WaitforBusy(3);
                _board.IsBusy = true;
                int BaseRowID = CommonPrepareTable(DGVSpiTable, Address, false);
                DGVSpiTable.Rows[BaseRowID].Cells[2].Value = TX;
                //Build and perform Transmission
                string[] splits = TX.TrimEnd().Split(' ');
                byte[] tx = new byte[splits.Length];

                for (int i = 0; i < tx.Length; i++) {
                    //convert Hex to decimal for transfer
                    long dec = Convert.ToUInt32(splits[i], 16);
                    tx[i] = (byte)dec;
                }

                byte[] rx = _board.I2CWriteDirect(Address, tx);
                if (rx == null) {
                    DGVSpiTable.Rows[BaseRowID].Cells[3].Value = "-";
                    return; 
                }

                StringBuilder sbDataIn = new StringBuilder();
                StringBuilder sbDataInAll = new StringBuilder();
                int end = rx[2] + 3; //MaState,CntW,CntR
                if (end > rx.Length) {
                    end = rx.Length;
                }
                for (int i = 3; i < end; i++) {
                    sbDataIn.Append($"{rx[i].ToString("X02")} ");
                }
                for (int i = 0; i < rx.Length; i++) {
                    if (rx[0] == i) {
                        sbDataInAll.Append($"[{rx[i].ToString("X02")}] ");
                    } else {
                        sbDataInAll.Append($"{rx[i].ToString("X02")} ");
                    }
                }
                DGVSpiTable.Rows[BaseRowID].Cells[3].Value = sbDataIn.ToString();
                DGVSpiTable.Rows[BaseRowID].Cells[4].Value = _board.GetI2CResponseCode(rx[0]);
                DGVSpiTable.Rows[BaseRowID].Cells[5].Value = rx[1];
                DGVSpiTable.Rows[BaseRowID].Cells[6].Value = sbDataInAll.ToString();
                switch (rx[0]) {
                    case 155: //DONE
                        DGVSpiTable.Rows[BaseRowID].Cells[4].Style.BackColor = Color.PaleGreen;
                        break;
                    case 201: //$"SLAVE_NAC({code})";
                    case 202: //$"TIMEOUT({code})";
                    case 203: //$"SLAVE_W_NAC({code})";
                        DGVSpiTable.Rows[BaseRowID].Cells[4].Style.BackColor = Color.Salmon;
                        break;
                    default:
                        DGVSpiTable.Rows[BaseRowID].Cells[4].Style.BackColor = Color.Red;
                        break;
                }
                DGVSpiTable.FirstDisplayedScrollingRowIndex = BaseRowID;
                _board.IsBusy = false;
            } catch (Exception ex) {
                _board.IsBusy = false;
                if (_closing) { return; }
                MessageBox.Show(ex.Message, "Exeption Execute_TableWrite");
            }
        }
        void btn_table_Clear_Click(object sender, EventArgs e) {
            CommonClearTable(DGVSpiTable);
        }

        //common for all tables
        void CommonClearTable(DataGridView dgv) {
            dgv.Rows.Clear();
            dgv.Columns.Clear();
        }
        int CommonPrepareTable(DataGridView dgv, int address, bool isRead) {
            if (dgv.Columns.Count == 0) {
                dgv.Rows.Clear();
                dgv.Columns.Clear();

                //Build default table columns
                dgv.Columns.Add("Dir", "Direction");
                dgv.Columns.Add("tar", "Target");
                dgv.Columns[1].Width = 40;
                dgv.Columns[1].CellTemplate.Style.Alignment = DataGridViewContentAlignment.MiddleCenter;
                dgv.Columns.Add("tx", "Send");
                dgv.Columns.Add("rsp", "Response");
                dgv.Columns.Add("sta", "I2C State");
                dgv.Columns.Add("nr", "NrOfBytes");
                dgv.Columns.Add("rsp2", "Full Response");
            }
            //Build default table rows
            int BaseRowID = dgv.Rows.Count;
            if (isRead) {
                dgv.Rows.Add($"{BaseRowID + 1} READ", address);
                dgv.Rows[BaseRowID].Cells[0].Style.BackColor = Color.RoyalBlue;
            } else { 
                dgv.Rows.Add($"{BaseRowID + 1} WRITE", address);
                dgv.Rows[BaseRowID].Cells[0].Style.BackColor = Color.Gold;
            }
            
            return BaseRowID;
        }
        #endregion

        #region Loop
        int loopCnt = 0;
        string[] loopLastRx = new string[5];
        void LoopLog(string info) {
            txt_loop_log.AppendText($"{DateTime.Now.ToString("HH:MM:ss:fff")} | {loopCnt} | {info}\r\n");
        }
        void btn_loop_ClearLog_Click(object sender, EventArgs e) {
            txt_loop_log.Text = "";
        }
        void btn_loop_stop_Click(object sender, EventArgs e) {
            timer_loop.Stop();
            btn_loop_Start.BackColor = Color.Gainsboro; btn_loop_Start.Refresh();
            LoopLog("stop");
            loopCnt = 0;
        }
        void btn_loop_Start_Click(object sender, EventArgs e) {
            LoopLog("start");
            btn_loop_Start.BackColor = Color.LimeGreen;
            loopCnt = 0;
            for (int i = 0; i < loopLastRx.Length; i++) {
                loopLastRx[i] = "";
            }
            timer_loop.Start();
        }

        //timer
        bool LoopRunning = false;
        private void timer_loop_Tick(object sender, EventArgs e) {
            loopCnt++;
            if (LoopRunning) {
                return;
            }
            btn_loop_Start.BackColor = Color.Gold; btn_loop_Start.Refresh();
            //LoopLog("tic");
            try {
                LoopRunning = true;
                if (chk_loop_send1.Checked) {
                    LoopTransmission(txt_loop_Send1.Text, cb_loop_send1.SelectedIndex, ref loopLastRx[0]);
                }
                if (chk_loop_send2.Checked) {
                    LoopTransmission(txt_loop_Send2.Text, cb_loop_send2.SelectedIndex, ref loopLastRx[1]);
                }
                if (chk_loop_send3.Checked) {
                    LoopTransmission(txt_loop_Send3.Text, cb_loop_send3.SelectedIndex, ref loopLastRx[2]);
                }
                if (chk_loop_send4.Checked) {
                    LoopTransmission(txt_loop_Send4.Text, cb_loop_send4.SelectedIndex, ref loopLastRx[3]);
                }
                if (chk_loop_send5.Checked) {
                    LoopTransmission(txt_loop_Send5.Text, cb_loop_send5.SelectedIndex, ref loopLastRx[4]);
                }
            } catch (Exception ex) {
                LoopLog("\r\n" + ex.Message);
            }
            LoopRunning = false;
            if (timer_loop.Enabled) {
                btn_loop_Start.BackColor = Color.LimeGreen; btn_loop_Start.Refresh();
            }
        }
        void LoopTransmission(string command, int typeIndex, ref string lastRx) {
            string rx = "";

            if (_board.IsBusy) {
                LoopLog($"IsBusy, skip: [{typeIndex}] {command}");
            }
            _board.IsBusy = true;

            switch (typeIndex) {
                case 0: rx = LoopTrans_Read(command); break;
                case 1: rx = LoopTrans_Write(command); break;
                case 2: rx = LoopTrans_Scan(command); break;
            }

            if (rad_loop_RxFilter_ShowAll.Checked) {
                LoopLog($"{command} -> {rx}");
            }
            if (rad_loop_RxFilter_Lastchanged.Checked) {
                if (lastRx.StartsWith("#")) {
                    LoopLog($"{lastRx} -> {rx}");
                    return;
                }
                if (rx != lastRx) {
                    LoopLog($"Changed -> {rx}");
                }
            }
            if (rad_loop_RxFilter_Contains.Checked) {
                if (rx.Contains(txt_loop_RxFilter_Contains.Text)) {
                    LoopLog($"Contains -> {rx}");
                }
            }
            lastRx = rx;
            _board.IsBusy = false;
        }
        string LoopTrans_Read(string command) {
            //prepare
            StringBuilder sbDataIn = new StringBuilder();
            sbDataIn.Append($"Read [{Address}]: ");
            string[] splits = command.Split(' ');
            int cnt = int.Parse(splits[0], System.Globalization.NumberStyles.HexNumber);

            //perform Transmission
            I2cResponseInfo ri = _board.I2CRead(Address, cnt);
            return ri.GetResponse(true);
        }
        string LoopTrans_Write(string command) {
            //prepare
            StringBuilder sbDataIn = new StringBuilder();
            sbDataIn.Append($"Write [{Address}]: ");

            //Build and perform Transmission
            string[] splits = command.TrimEnd().Split(' ');
            byte[] tx = new byte[splits.Length];

            for (int i = 0; i < tx.Length; i++) {
                //convert Hex to decimal for transfer
                long dec = Convert.ToUInt32(splits[i], 16);
                tx[i] = (byte)dec;
            }

            I2cResponseInfo ri = _board.I2CWrite(Address, tx);
            return ri.GetResponse(true);
        }
        string LoopTrans_Scan(string command) {
            //prepare
            string[] splits = command.Split(' ');
            int cnt = int.Parse(splits[0], System.Globalization.NumberStyles.HexNumber);
            int mode = 0;
            if (splits.Length > 1) {
                int.TryParse(splits[1], out mode);
            }
            StringBuilder sbDataIn = new StringBuilder();
            sbDataIn.Append($"Scan: ");

            //Build and perform Transmission
            I2cResponseInfo ri = _board.I2CScanSlaves(cnt, mode);
            return ri.GetResponse(true);
        }
        #endregion

        #region SignalCheck
        void ExecuteSignalCheck() {
            //_board.SetSensedMasterSignalCheck(9, Mode_Set.AdcMaSenseDone4); //init
            //txt_SignalCheckLog.Text += $"{_board.LastModeSet},";
            //ushort[] adcs = _board.GetAdcArrayReadout(12); //read clk, mosi, miso
            //if (adcs.Length < 12) {
            //    throw new Exception($"Not enough ADC entries, got only '{string.Join(",", adcs)}'");
            //}
            //Adc are <PP_Low>,<InPullDown>,<PP_High>,<InPullUp>
            //Table are <PP_Low>,<PP_High>,<InPullDown>,<InPullUp>
            //dgv_SignalState.Rows.Add("B13", "B0", "SPI2 CLK", adcs[0], adcs[2], adcs[1], adcs[3]);
            //dgv_SignalState.Rows.Add("B14", "A7", "SPI2 MISO", adcs[4], adcs[6], adcs[5], adcs[7]);
            //dgv_SignalState.Rows.Add("B13", "B0", "SPI2 MOSI", adcs[8], adcs[10], adcs[9], adcs[11]);
            _board.SetSensedMasterSignalCheck(9, Mode_Set.AdcMaSenseDone4); //continue
            txt_SignalCheckLog.Text += $"{_board.LastModeSet},";
            ushort[] adcs = _board.GetAdcArrayReadout(12); //read cs0,cs1,cs2
            if (adcs.Length < 12) {
                throw new Exception($"Not enough ADC entries, got only '{string.Join(",", adcs)}'");
            }
            dgv_SignalState.Rows.Add("B6", "A2", "CLK (SCL)", adcs[0], adcs[2], adcs[1], adcs[3]);
            dgv_SignalState.Rows.Add("B7", "A1", "DATA (SDA)", adcs[4], adcs[6], adcs[5], adcs[7]);
            dgv_SignalState.Rows.Add("B9", "A0", "Output", adcs[8], adcs[10], adcs[9], adcs[11]);
        }
        void ExecuteSignalCheckColors() {
            for (int i = 0; i < dgv_SignalState.Rows.Count; i++) {
                SetSignalCheckCellColor(dgv_SignalState.Rows[i].Cells[3], false);
                SetSignalCheckCellColor(dgv_SignalState.Rows[i].Cells[4], true);
                if (i < 2) { //CLK,DATA
                    SetSignalCheckCellColor(dgv_SignalState.Rows[i].Cells[5], true);
                } else {
                    SetSignalCheckCellColor(dgv_SignalState.Rows[i].Cells[5], false);
                }
                SetSignalCheckCellColor(dgv_SignalState.Rows[i].Cells[6], true);
            }
        }
        void SetSignalCheckCellColor(DataGridViewCell cell, bool shouldBeHigh) {
            try {
                double number = double.Parse(cell.Value.ToString());
                double volt = number / 4096.0 * _board.ReferenceVoltage;
                cell.Value = $"{Math.Round(volt,2)} V ({number} {(shouldBeHigh ? "H" : "L")})";
                if (shouldBeHigh) {
                    if (volt > (double)num_SignalCheck_GrHigh.Value) {
                        cell.Style.BackColor = Color.PaleGreen;
                        return;
                    }
                    if (volt > (double)num_SignalCheck_YHigh.Value) {
                        cell.Style.BackColor = Color.Gold;
                        return;
                    }
                } else { //should be low
                    if (volt < (double)num_SignalCheck_GrLow.Value) {
                        cell.Style.BackColor = Color.PaleGreen;
                        return;
                    }
                    if (volt < (double)num_SignalCheck_YLow.Value) {
                        cell.Style.BackColor = Color.Gold;
                        return;
                    }
                }

                cell.Style.BackColor = Color.Salmon;
            } catch (Exception ex) {
                cell.ToolTipText = "Ex: " + ex.Message;
                cell.Style.BackColor = Color.Fuchsia;
            }
        }

        void btn_SignalCheck_Click(object sender, EventArgs e) {
            if (_board.IsBusy) {
                return;
            }
            _board.IsBusy = true;
            dgv_SignalState.Rows.Clear();
            txt_SignalCheckLog.Text = "";
            dgv_SignalState.Refresh();
            try {
                _board.GetTemperatureAndReference();
                ExecuteSignalCheck();
                ExecuteSignalCheckColors();
            } catch (Exception err) {
                txt_SignalCheckLog.Text += "Err:" + err.Message;
            }
            _board.IsBusy = false;
        }











        #endregion

    }
}
